/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundableProcessIndicator
extends ProgressWindow {
    protected StatusBarEx myStatusBar;
    private PerformInBackgroundOption myOption;
    private TaskInfo myInfo;
    private boolean myDisposed;
    private DumbModeAction myDumbModeAction;
    private ProjectManagerListener myListener;

    public BackgroundableProcessIndicator(Task.Backgroundable task) {
        this(task.getProject(), (TaskInfo)task, (PerformInBackgroundOption)task);
        this.myDumbModeAction = task.getDumbModeAction();
        if (this.myDumbModeAction == DumbModeAction.CANCEL) {
            task.getProject().getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    BackgroundableProcessIndicator.this.cancel();
                }

                public void exitDumbMode() {
                }
            });
        }
    }

    public BackgroundableProcessIndicator(final @Nullable Project project, TaskInfo info, @NotNull PerformInBackgroundOption option) {
        if (option == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/progress/impl/BackgroundableProcessIndicator.<init> must not be null");
        }
        super(info.isCancellable(), true, project, info.getCancelText());
        this.myDumbModeAction = DumbModeAction.NOTHING;
        if (project != null) {
            this.myListener = new ProjectManagerAdapter(){

                public void projectClosing(Project closingProject) {
                    if (project == closingProject && BackgroundableProcessIndicator.this.isRunning()) {
                        BackgroundableProcessIndicator.this.cancel();
                    }
                }
            };
            ProjectManager.getInstance().addProjectManagerListener(this.myListener);
        }
        this.setOwnerTask(info);
        this.setProcessId(info.getProcessId());
        this.myOption = option;
        this.myInfo = info;
        this.setTitle(info.getTitle());
        Project nonDefaultProject = project == null || project.isDisposed() ? null : (project.isDefault() ? null : project);
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(nonDefaultProject);
        this.myStatusBar = (StatusBarEx)frame.getStatusBar();
        if (option.shouldStartInBackground()) {
            this.doBackground();
        }
    }

    public BackgroundableProcessIndicator(Project project, final @Nls String progressTitle, @NotNull PerformInBackgroundOption option, final @Nls String cancelButtonText, final @Nls String backgroundStopTooltip, final boolean cancellable) {
        if (option == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/progress/impl/BackgroundableProcessIndicator.<init> must not be null");
        }
        this(project, new TaskInfo(){

            public String getProcessId() {
                return "<unknown>";
            }

            public String getTitle() {
                return progressTitle;
            }

            public String getCancelText() {
                return cancelButtonText;
            }

            public String getCancelTooltipText() {
                return backgroundStopTooltip;
            }

            public boolean isCancellable() {
                return cancellable;
            }
        }, option);
    }

    public DumbModeAction getDumbModeAction() {
        return this.myDumbModeAction;
    }

    @Override
    protected void showDialog() {
        if (this.myDisposed) {
            return;
        }
        if (this.myOption.shouldStartInBackground()) {
            return;
        }
        super.showDialog();
    }

    @Override
    public void background() {
        if (this.myDisposed) {
            return;
        }
        this.myOption.processSentToBackground();
        this.doBackground();
        super.background();
    }

    private void doBackground() {
        this.myStatusBar.add(this, this.myInfo);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.myListener != null) {
            ProjectManager.getInstance().removeProjectManagerListener(this.myListener);
            this.myListener = null;
        }
        this.myDisposed = true;
        this.myInfo = null;
        this.myStatusBar = null;
        this.myOption = null;
    }
}

