/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.util.Function;
import com.intellij.util.ui.update.ComparableObject;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import org.jetbrains.annotations.Nullable;

public class NativeFileIconProvider
implements FileIconProvider {
    private JFileChooser myFileChooser = new JFileChooser();
    private final Map<Ext, Icon> myIconCache = new HashMap<Ext, Icon>();
    private final Set<Ext> myCustomIconExtensions = SystemInfo.isWindows ? new HashSet<Ext>(Arrays.asList(new Ext("exe"), new Ext("ico"))) : new HashSet();
    private final Map<String, Icon> myCustomIconCache = new HashMap<String, Icon>();
    private static final Ext NO_EXT = new Ext(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(VirtualFile file, int flags, @Nullable Project project) {
        Icon icon;
        if (!this.isNativeFileType(file)) {
            return null;
        }
        final Ext ext = file.getExtension() != null ? new Ext(file.getExtension()) : NO_EXT;
        final String filePath = file.getPath();
        Map<Ext, Icon> map = this.myIconCache;
        synchronized (map) {
            icon = !this.myCustomIconExtensions.contains((Object)ext) ? (ext != null ? this.myIconCache.get((Object)ext) : null) : (filePath != null ? this.myCustomIconCache.get(filePath) : null);
        }
        if (icon != null) {
            return icon;
        }
        return new DeferredIconImpl<VirtualFile>(file.getFileType().getIcon(), file, false, new Function<VirtualFile, Icon>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Icon fun(VirtualFile virtualFile) {
                Icon icon;
                File f = new File(filePath);
                if (!f.exists()) {
                    return null;
                }
                try {
                    icon = NativeFileIconProvider.this.myFileChooser.getIcon(f);
                }
                catch (Exception e) {
                    return null;
                }
                if (ext != null) {
                    Map map = NativeFileIconProvider.this.myIconCache;
                    synchronized (map) {
                        if (!NativeFileIconProvider.this.myCustomIconExtensions.contains((Object)ext)) {
                            NativeFileIconProvider.this.myIconCache.put(ext, icon);
                        } else if (filePath != null) {
                            NativeFileIconProvider.this.myCustomIconCache.put(filePath, icon);
                        }
                    }
                }
                return icon;
            }
        });
    }

    protected boolean isNativeFileType(VirtualFile file) {
        return file.getFileType() instanceof NativeFileType || file.getFileType() instanceof UnknownFileType;
    }

    private static class Ext
    extends ComparableObject.Impl {
        private final Object[] myText;

        private Ext(@Nullable String text) {
            this.myText = new Object[]{text};
        }

        public Object[] getEqualityObjects() {
            return this.myText;
        }

        public String toString() {
            return this.myText[0] != null ? this.myText[0].toString() : null;
        }
    }
}

