/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorInfoPane;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.tabs.UiDecorator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public abstract class EditorComposite
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.EditorComposite");
    private final VirtualFile myFile;
    private boolean myPinned;
    protected final FileEditor[] myEditors;
    private final long myInitialFileTimeStamp;
    protected final TabbedPaneWrapper myTabbedPaneWrapper;
    private final MyComponent myComponent;
    private final FocusWatcher myFocusWatcher;
    private FileEditor mySelectedEditor;
    private final FileEditorManagerEx myFileEditorManager;
    private final long myInitialFileModificationStamp;
    private final Map<FileEditor, FileEditorInfoPane> myInfoPanes;
    private final Map<FileEditor, JComponent> myTopComponents;
    private final Map<FileEditor, JComponent> myBottomComponents;

    EditorComposite(@NotNull VirtualFile file, final @NotNull FileEditor[] editors, @NotNull FileEditorManagerEx fileEditorManager) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/EditorComposite.<init> must not be null");
        }
        if (editors == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/EditorComposite.<init> must not be null");
        }
        if (fileEditorManager == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/EditorComposite.<init> must not be null");
        }
        this.myInfoPanes = new HashMap<FileEditor, FileEditorInfoPane>();
        this.myTopComponents = new HashMap<FileEditor, JComponent>();
        this.myBottomComponents = new HashMap<FileEditor, JComponent>();
        this.myFile = file;
        this.myEditors = editors;
        this.myFileEditorManager = fileEditorManager;
        this.myInitialFileTimeStamp = this.myFile.getTimeStamp();
        this.myInitialFileModificationStamp = this.myFile.getModificationStamp();
        Disposer.register((Disposable)fileEditorManager.getProject(), (Disposable)this);
        if (editors.length > 1) {
            PrevNextActionsDescriptor descriptor = new PrevNextActionsDescriptor("NextEditorTab", "PreviousEditorTab");
            final TabbedPaneWrapper.AsJBTabs wrapper = new TabbedPaneWrapper.AsJBTabs(fileEditorManager.getProject(), 3, descriptor, this);
            wrapper.getTabs().getPresentation().setPaintBorder(0, 0, 0, 0).setTabSidePaintBorder(1).setGhostsAlwaysVisible(true).setUiDecorator(new UiDecorator(){

                @NotNull
                public UiDecorator.UiDecoration getDecoration() {
                    UiDecorator.UiDecoration uiDecoration = new UiDecorator.UiDecoration(null, new Insets(0, 8, 0, 8));
                    if (uiDecoration == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/EditorComposite$1.getDecoration must not return null");
                    }
                    return uiDecoration;
                }
            });
            wrapper.getTabs().getComponent().setBorder(new EmptyBorder(0, 0, 1, 0));
            this.myTabbedPaneWrapper = wrapper;
            this.myComponent = new MyComponent(wrapper.getComponent()){

                @Override
                public boolean requestFocusInWindow() {
                    return wrapper.getComponent().requestFocusInWindow();
                }

                @Override
                public void requestFocus() {
                    wrapper.getComponent().requestFocus();
                }

                @Override
                public boolean requestDefaultFocus() {
                    return wrapper.getComponent().requestDefaultFocus();
                }
            };
            for (FileEditor editor : editors) {
                wrapper.addTab(editor.getName(), this.createEditorComponent(editor));
            }
            this.myTabbedPaneWrapper.addChangeListener(new MyChangeListener());
        } else if (editors.length == 1) {
            this.myTabbedPaneWrapper = null;
            this.myComponent = new MyComponent(this.createEditorComponent(editors[0])){

                @Override
                public void requestFocus() {
                    JComponent component = editors[0].getPreferredFocusedComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }

                @Override
                public boolean requestFocusInWindow() {
                    JComponent component = editors[0].getPreferredFocusedComponent();
                    if (component != null) {
                        return component.requestFocusInWindow();
                    }
                    return false;
                }

                @Override
                public boolean requestDefaultFocus() {
                    JComponent component = editors[0].getPreferredFocusedComponent();
                    if (component != null) {
                        return component.requestDefaultFocus();
                    }
                    return false;
                }
            };
        } else {
            throw new IllegalArgumentException("editors array cannot be empty");
        }
        this.mySelectedEditor = editors[0];
        this.myFocusWatcher = new FocusWatcher();
        this.myFocusWatcher.install((Component)this.myComponent);
        this.myFileEditorManager.addFileEditorManagerListener((FileEditorManagerListener)new FileEditorManagerAdapter(){

            public void selectionChanged(FileEditorManagerEvent event) {
                VirtualFile newFile;
                VirtualFile oldFile = event.getOldFile();
                if (oldFile == (newFile = event.getNewFile()) && EditorComposite.this.getFile() == newFile) {
                    FileEditor newEditor;
                    FileEditor oldEditor = event.getOldEditor();
                    if (oldEditor != null) {
                        oldEditor.deselectNotify();
                    }
                    if ((newEditor = event.getNewEditor()) != null) {
                        newEditor.selectNotify();
                    }
                }
            }
        }, this);
    }

    private JComponent createEditorComponent(FileEditor editor) {
        JPanel component = new JPanel(new BorderLayout());
        JComponent comp = editor.getComponent();
        if (!FileEditorManagerImpl.isDumbAware(editor)) {
            comp = DumbService.getInstance((Project)this.myFileEditorManager.getProject()).wrapGently(comp, (Disposable)editor);
        }
        component.add((Component)comp, "Center");
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        this.myTopComponents.put(editor, topPanel);
        component.add((Component)topPanel, "North");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        this.myBottomComponents.put(editor, bottomPanel);
        component.add((Component)bottomPanel, "South");
        FileEditorInfoPane infoPane = new FileEditorInfoPane();
        this.myInfoPanes.put(editor, infoPane);
        this.addTopComponent(editor, infoPane);
        return component;
    }

    public boolean isPinned() {
        return this.myPinned;
    }

    void setPinned(boolean pinned) {
        this.myPinned = pinned;
    }

    private void fireSelectedEditorChanged(FileEditor oldSelectedEditor, FileEditor newSelectedEditor) {
        if (!this.myFileEditorManager.isInsideChange() && !Comparing.equal((Object)oldSelectedEditor, (Object)newSelectedEditor)) {
            FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this.myFileEditorManager, this.myFile, oldSelectedEditor, this.myFile, newSelectedEditor);
            FileEditorManagerListener publisher = (FileEditorManagerListener)this.myFileEditorManager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
            publisher.selectionChanged(event);
        }
    }

    JComponent getPreferredFocusedComponent() {
        Component component = this.myFocusWatcher.getFocusedComponent();
        if (!(component instanceof JComponent && component.isShowing() && component.isEnabled() && component.isFocusable())) {
            return this.getSelectedEditor().getPreferredFocusedComponent();
        }
        return (JComponent)component;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public FileEditorManager getFileEditorManager() {
        return this.myFileEditorManager;
    }

    public long getInitialFileTimeStamp() {
        return this.myInitialFileTimeStamp;
    }

    public long getInitialFileModificationStamp() {
        return this.myInitialFileModificationStamp;
    }

    public FileEditor[] getEditors() {
        return this.myEditors;
    }

    public void addTopComponent(FileEditor editor, JComponent component) {
        this.manageTopOrBottomComponent(editor, component, true, false);
    }

    public void removeTopComponent(FileEditor editor, JComponent component) {
        this.manageTopOrBottomComponent(editor, component, true, true);
    }

    public void addBottomComponent(FileEditor editor, JComponent component) {
        this.manageTopOrBottomComponent(editor, component, false, false);
    }

    public void removeBottomComponent(FileEditor editor, JComponent component) {
        this.manageTopOrBottomComponent(editor, component, false, true);
    }

    private void manageTopOrBottomComponent(FileEditor editor, JComponent component, boolean top, boolean remove) {
        JComponent container;
        JComponent jComponent = container = top ? this.myTopComponents.get(editor) : this.myBottomComponents.get(editor);
        assert (container != null);
        if (remove) {
            container.remove(component);
        } else {
            container.add(component);
        }
        container.revalidate();
    }

    public FileEditorInfoPane getPane(FileEditor editor) {
        return this.myInfoPanes.get(editor);
    }

    @NotNull
    FileEditor getSelectedEditor() {
        FileEditor fileEditor = (FileEditor)this.getSelectedEditorWithProvider().getFirst();
        if (fileEditor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/EditorComposite.getSelectedEditor must not return null");
        }
        return fileEditor;
    }

    public boolean isDisposed() {
        return this.myTabbedPaneWrapper != null && this.myTabbedPaneWrapper.isDisposed();
    }

    public abstract Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider();

    void setSelectedEditor(int index) {
        if (this.myEditors.length == 1) {
            LOG.assertTrue(this.myTabbedPaneWrapper == null);
        } else {
            LOG.assertTrue(this.myTabbedPaneWrapper != null);
            this.myTabbedPaneWrapper.setSelectedIndex(index);
        }
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public boolean isModified() {
        for (int i = this.myEditors.length - 1; i >= 0; --i) {
            if (!this.myEditors[i].isModified()) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    private abstract class MyComponent
    extends JPanel
    implements DataProvider {
        public MyComponent(JComponent realComponent) {
            super(new BorderLayout());
            this.add((Component)realComponent, "Center");
        }

        public final Object getData(String dataId) {
            if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                return EditorComposite.this.getSelectedEditor();
            }
            if (PlatformDataKeys.VIRTUAL_FILE.is(dataId)) {
                return EditorComposite.this.myFile.isValid() ? EditorComposite.this.myFile : null;
            }
            if (PlatformDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                VirtualFile[] virtualFileArray;
                if (EditorComposite.this.myFile.isValid()) {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = EditorComposite.this.myFile;
                } else {
                    virtualFileArray = null;
                }
                return virtualFileArray;
            }
            JComponent component = EditorComposite.this.getPreferredFocusedComponent();
            if (component instanceof DataProvider && component != this) {
                return ((DataProvider)component).getData(dataId);
            }
            return null;
        }
    }

    private final class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FileEditor oldSelectedEditor = EditorComposite.this.mySelectedEditor;
            LOG.assertTrue(oldSelectedEditor != null);
            int selectedIndex = EditorComposite.this.myTabbedPaneWrapper.getSelectedIndex();
            LOG.assertTrue(selectedIndex != -1);
            EditorComposite.this.mySelectedEditor = EditorComposite.this.myEditors[selectedIndex];
            EditorComposite.this.fireSelectedEditorChanged(oldSelectedEditor, EditorComposite.this.mySelectedEditor);
        }
    }
}

