/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;

public class PersistentRangeMarker
extends RangeMarkerImpl {
    private int myStartLine;
    private int myStartColumn;
    private int myEndLine;
    private int myEndColumn;

    public PersistentRangeMarker(DocumentEx document, int startOffset, int endOffset) {
        super(document, startOffset, endOffset);
        this.storeLinesAndCols();
    }

    private void storeLinesAndCols() {
        if (this.getStartOffset() < this.myDocument.getTextLength()) {
            this.myStartLine = this.myDocument.getLineNumber(this.getStartOffset());
            this.myStartColumn = this.getStartOffset() - this.myDocument.getLineStartOffset(this.myStartLine);
            if (this.myStartColumn < 0) {
                this.invalidate();
            }
        }
        if (this.getEndOffset() < this.myDocument.getTextLength()) {
            this.myEndLine = this.myDocument.getLineNumber(this.getEndOffset());
            this.myEndColumn = this.getEndOffset() - this.myDocument.getLineStartOffset(this.myEndLine);
            if (this.myEndColumn < 0) {
                this.invalidate();
            }
        }
    }

    @Override
    protected void changedUpdateImpl(DocumentEvent e) {
        DocumentEventImpl event = (DocumentEventImpl)e;
        if (event.isWholeTextReplaced()) {
            this.myStartLine = event.translateLineViaDiffStrict(this.myStartLine);
            if (this.myStartLine < 0 || this.myStartLine >= this.getDocument().getLineCount()) {
                this.invalidate();
            } else {
                this.myStart = this.getDocument().getLineStartOffset(this.myStartLine) + this.myStartColumn;
            }
            this.myEndLine = event.translateLineViaDiffStrict(this.myEndLine);
            if (this.myEndLine < 0 || this.myEndLine >= this.getDocument().getLineCount()) {
                this.invalidate();
            } else {
                this.myEnd = this.getDocument().getLineStartOffset(this.myEndLine) + this.myEndColumn;
            }
        } else {
            super.changedUpdateImpl(e);
            if (this.isValid()) {
                this.storeLinesAndCols();
            }
        }
        if (this.myEnd < this.myStart || this.myEnd > this.getDocument().getTextLength()) {
            this.invalidate();
        }
    }

    @Override
    public String toString() {
        return "PersistentRangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " " + this.myStartLine + ":" + this.myStartColumn + "-" + this.myEndLine + ":" + this.myEndColumn + (this.isGreedyToRight() ? "]" : ")");
    }
}

