/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.impl.ContentChangeListener;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.DiffVersionComponent;
import com.intellij.openapi.diff.impl.highlighting.DiffMarkup;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.util.ContentDocumentListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;

class EditorPlaceHolder
extends DiffMarkup
implements DiffVersionComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.highlighting.EditorWrapper");
    private EditorEx myEditor;
    private DiffContent myContent;
    private final FragmentSide mySide;
    private ContentChangeListener myListener = null;

    public EditorPlaceHolder(FragmentSide side, Project project) {
        super(project);
        this.mySide = side;
        this.resetHighlighters();
    }

    public void addListener(ContentChangeListener listener) {
        LOG.assertTrue(this.myListener == null);
        this.myListener = listener;
    }

    @Override
    protected void doDispose() {
        LOG.assertTrue(!this.isDisposed());
        super.doDispose();
        this.fireContentChanged();
    }

    private void fireContentChanged() {
        this.myListener.onContentChangedIn(this);
    }

    public void setContent(DiffContent content) {
        this.disposeEditor();
        this.myContent = content;
        if (this.myContent != null) {
            Document document = this.myContent.getDocument();
            final EditorFactory editorFactory = EditorFactory.getInstance();
            this.myEditor = DiffUtil.createEditor(document, this.getProject(), false);
            this.addDisposable(new Disposable(){

                public void dispose() {
                    editorFactory.releaseEditor((Editor)EditorPlaceHolder.this.myEditor);
                    EditorPlaceHolder.this.myEditor = null;
                }
            });
            ContentDocumentListener.install(this.myContent, this);
        }
        this.fireContentChanged();
    }

    @Override
    public EditorEx getEditor() {
        return this.myEditor;
    }

    @Override
    public FragmentSide getSide() {
        return this.mySide;
    }

    @Override
    public DiffContent getContent() {
        return this.myContent;
    }

    @Override
    public void removeContent() {
        this.setContent(null);
    }
}

