/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.impl.CurrentLineMarker;
import com.intellij.openapi.diff.impl.DiffHighlighterFactory;
import com.intellij.openapi.diff.impl.DiffHighlighterFactoryImpl;
import com.intellij.openapi.diff.impl.DiffSidesContainer;
import com.intellij.openapi.diff.impl.EditorSource;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.util.LabeledEditor;
import com.intellij.openapi.diff.impl.util.SyncScrollSupport;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.IJSwingUtilities;
import java.awt.Cursor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DiffSideView {
    private final JComponent MOCK_COMPONENT = new JPanel();
    private static final DiffHighlighterFactory DUMMY_HIGHLIGHTER_FACTORY = new DiffHighlighterFactoryImpl(null, null, null);
    private final LabeledEditor myPanel;
    private final DiffSidesContainer myContainer;
    private final CurrentLineMarker myLineMarker;
    private DiffHighlighterFactory myHighlighterFactory;
    private EditorSource myEditorSource;
    private boolean myIsMaster;
    private String myTitle;

    public DiffSideView(String title, DiffSidesContainer container) {
        this.MOCK_COMPONENT.setFocusable(true);
        this.myPanel = new LabeledEditor();
        this.myLineMarker = new CurrentLineMarker();
        this.myHighlighterFactory = DUMMY_HIGHLIGHTER_FACTORY;
        this.myEditorSource = EditorSource.NULL;
        this.myIsMaster = false;
        this.myTitle = title;
        this.myContainer = container;
        this.insertComponent(this.MOCK_COMPONENT);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void setEditorSource(EditorSource source) {
        MyState state = new MyState();
        this.myEditorSource = source;
        this.myLineMarker.attach(this.myEditorSource);
        EditorEx editor = this.myEditorSource.getEditor();
        if (editor == null) {
            this.insertComponent(this.MOCK_COMPONENT);
            return;
        }
        editor.getScrollingModel().scrollHorizontally(0);
        this.insertComponent(editor.getComponent());
        this.applyHighlighter();
        this.setMouseListeners(source);
        MyEditorFocusListener.install(this);
        state.restore();
    }

    private void insertComponent(JComponent component) {
        this.myPanel.setComponent(component, this.myTitle);
    }

    public void setHighlighterFactory(DiffHighlighterFactory highlighterFactory) {
        this.myHighlighterFactory = highlighterFactory;
        this.applyHighlighter();
    }

    private void applyHighlighter() {
        EditorEx editor = this.myEditorSource.getEditor();
        if (editor == null) {
            return;
        }
        EditorHighlighter highlighter = this.myHighlighterFactory.createHighlighter();
        if (highlighter != null) {
            editor.setHighlighter(highlighter);
        }
        editor.getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, null);
    }

    public void setTitle(String title) {
        this.myTitle = title;
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        boolean readonly = editor.isViewer() || !editor.getDocument().isWritable();
        this.myPanel.updateTitle(this.myTitle, readonly);
    }

    private void setMouseListeners(EditorSource source) {
        DiffContent content = source.getContent();
        MouseLineNumberListener.install(content, source, this.myContainer);
    }

    public void beSlave() {
        this.myIsMaster = false;
        this.myLineMarker.hide();
    }

    public JComponent getFocusableComponent() {
        Editor editor = this.getEditor();
        return editor != null ? editor.getContentComponent() : this.MOCK_COMPONENT;
    }

    public void becomeMaster() {
        if (this.myIsMaster) {
            return;
        }
        this.myIsMaster = true;
        this.myContainer.setCurrentSide(this);
        this.beMaster();
    }

    private void beMaster() {
        this.myLineMarker.set();
    }

    public void scrollToFirstDiff(int logicalLine) {
        EditorEx editor = this.myEditorSource.getEditor();
        SyncScrollSupport.scrollEditor(editor, logicalLine);
    }

    public Editor getEditor() {
        return this.myEditorSource.getEditor();
    }

    public FragmentSide getSide() {
        return this.myEditorSource.getSide();
    }

    private class MyState {
        private final boolean isFocused;

        public MyState() {
            this.isFocused = IJSwingUtilities.hasFocus(DiffSideView.this.getFocusableComponent());
        }

        public void restore() {
            if (this.isFocused) {
                DiffSideView.this.getFocusableComponent().requestFocus();
            }
            if (DiffSideView.this.myIsMaster) {
                DiffSideView.this.beMaster();
            }
        }
    }

    private static class MyEditorFocusListener
    extends FocusAdapter {
        private final DiffSideView mySideView;

        private MyEditorFocusListener(DiffSideView sideView) {
            this.mySideView = sideView;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.mySideView.becomeMaster();
        }

        public static MyEditorFocusListener install(DiffSideView sideView) {
            final MyEditorFocusListener listener = new MyEditorFocusListener(sideView);
            final JComponent focusableComponent = sideView.getFocusableComponent();
            focusableComponent.addFocusListener(listener);
            sideView.myEditorSource.addDisposable(new Disposable(){

                public void dispose() {
                    focusableComponent.removeFocusListener(listener);
                }
            });
            return listener;
        }
    }

    private static class MouseLineNumberListener {
        private static final Cursor HAND__CURSOR = Cursor.getPredefinedCursor(12);
        private final Editor myEditor;
        private final DiffSidesContainer myContainer;
        private final DiffContent myContent;
        private final Project myProject;
        private final EditorMouseAdapter myMouseListener = new EditorMouseAdapter(){

            public void mouseReleased(EditorMouseEvent e) {
                if (!MouseLineNumberListener.this.isInMyArea(e)) {
                    return;
                }
                OpenFileDescriptor descriptor = MouseLineNumberListener.this.getOpenFileDescriptor(e);
                if (descriptor == null) {
                    return;
                }
                MouseLineNumberListener.this.myContainer.showSource(descriptor);
            }
        };
        private final EditorMouseMotionAdapter myMouseMotionListener = new EditorMouseMotionAdapter(){

            public void mouseMoved(EditorMouseEvent e) {
                Editor editor = e.getEditor();
                if (editor.getProject() != null && editor.getProject() != MouseLineNumberListener.this.myProject && MouseLineNumberListener.this.myProject != null) {
                    return;
                }
                if (!MouseLineNumberListener.this.isInMyArea(e)) {
                    return;
                }
                Cursor cursor = MouseLineNumberListener.this.getOpenFileDescriptor(e) != null ? HAND__CURSOR : Cursor.getDefaultCursor();
                e.getMouseEvent().getComponent().setCursor(cursor);
                MouseLineNumberListener.this.myEditor.getContentComponent().setCursor(cursor);
            }
        };

        private OpenFileDescriptor getOpenFileDescriptor(EditorMouseEvent e) {
            int offset = this.myEditor.logicalPositionToOffset(this.myEditor.xyToLogicalPosition(e.getMouseEvent().getPoint()));
            return this.myContent.getOpenFileDescriptor(offset);
        }

        private boolean isInMyArea(EditorMouseEvent e) {
            return e.getArea() == EditorMouseEventArea.LINE_NUMBERS_AREA;
        }

        public MouseLineNumberListener(DiffContent content, Editor editor, DiffSidesContainer container, Project project) {
            this.myEditor = editor;
            this.myContainer = container;
            this.myContent = content;
            this.myProject = project;
        }

        public static void install(DiffContent content, EditorSource source, DiffSidesContainer container) {
            final EditorEx editor = source.getEditor();
            Project project = container.getProject();
            if (project == null) {
                return;
            }
            final MouseLineNumberListener listener = new MouseLineNumberListener(content, editor, container, project);
            editor.addEditorMouseListener((EditorMouseListener)listener.myMouseListener);
            editor.addEditorMouseMotionListener((EditorMouseMotionListener)listener.myMouseMotionListener);
            source.addDisposable(new Disposable(){

                public void dispose() {
                    editor.removeEditorMouseListener((EditorMouseListener)listener.myMouseListener);
                    editor.removeEditorMouseMotionListener((EditorMouseMotionListener)listener.myMouseMotionListener);
                }
            });
        }
    }
}

