/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedo;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CommandMerger {
    private final UndoManagerImpl myManager;
    private Object myLastGroupId;
    private boolean myGlobal;
    private boolean myOnlyUndoTransparents;
    private boolean myHasUndoTransparents;
    private String myCommandName;
    private List<UndoableAction> myCurrentActions;
    private Set<DocumentReference> myAffectedDocuments;
    private EditorAndState myStateBefore;
    private EditorAndState myStateAfter;
    private UndoConfirmationPolicy myUndoConfirmationPolicy;

    public CommandMerger(@NotNull UndoManagerImpl manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/command/impl/CommandMerger.<init> must not be null");
        }
        this.myLastGroupId = null;
        this.myGlobal = false;
        this.myOnlyUndoTransparents = true;
        this.myHasUndoTransparents = false;
        this.myCommandName = null;
        this.myCurrentActions = new ArrayList<UndoableAction>();
        this.myAffectedDocuments = new THashSet();
        this.myUndoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
        this.myManager = manager;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public void addAction(UndoableAction action, boolean isUndoTransparent) {
        if (!isUndoTransparent) {
            this.myOnlyUndoTransparents = false;
        }
        if (isUndoTransparent) {
            this.myHasUndoTransparents = true;
        }
        this.myCurrentActions.add(action);
        DocumentReference[] refs = action.getAffectedDocuments();
        if (refs != null) {
            Collections.addAll(this.myAffectedDocuments, refs);
        }
        this.myGlobal |= action.isGlobal() || !isUndoTransparent && this.affectsMultiplePhysicalDocs();
    }

    public void commandFinished(String commandName, Object groupId, CommandMerger nextCommandToMerge) {
        if (!this.shouldMerge(groupId, nextCommandToMerge)) {
            this.flushCurrentCommand();
            this.myManager.compact();
        }
        this.merge(nextCommandToMerge);
        this.clearRedoStacks(nextCommandToMerge);
        this.myLastGroupId = groupId;
        if (this.myCommandName == null) {
            this.myCommandName = commandName;
        }
    }

    private boolean shouldMerge(Object groupId, CommandMerger nextCommandToMerge) {
        if (this.isTransparent() || nextCommandToMerge.isTransparent()) {
            return ((Object)this.myAffectedDocuments).equals(nextCommandToMerge.myAffectedDocuments);
        }
        return !this.myGlobal && !nextCommandToMerge.isGlobal() && CommandMerger.canMergeGroup(groupId, this.myLastGroupId);
    }

    public static boolean canMergeGroup(Object groupId, Object lastGroupId) {
        return groupId != null && Comparing.equal((Object)lastGroupId, (Object)groupId);
    }

    private void merge(CommandMerger nextCommandToMerge) {
        this.setBeforeState(nextCommandToMerge.myStateBefore);
        this.myCurrentActions.addAll(nextCommandToMerge.myCurrentActions);
        this.myAffectedDocuments.addAll(nextCommandToMerge.myAffectedDocuments);
        this.myGlobal |= nextCommandToMerge.myGlobal;
        this.myOnlyUndoTransparents &= nextCommandToMerge.myOnlyUndoTransparents;
        this.myHasUndoTransparents |= nextCommandToMerge.myHasUndoTransparents;
        this.myStateAfter = nextCommandToMerge.myStateAfter;
        this.mergeUndoConfirmationPolicy(nextCommandToMerge.getUndoConfirmationPolicy());
    }

    public void flushCurrentCommand() {
        if (this.hasActions()) {
            this.myGlobal |= !this.isTransparent() && this.affectsMultiplePhysicalDocs();
            UndoableGroup undoableGroup = new UndoableGroup(this.myCommandName, this.myGlobal, this.myManager.getProject(), this.myStateBefore, this.myStateAfter, this.myCurrentActions, this.myManager.nextCommandTimestamp(), this.myUndoConfirmationPolicy, this.isTransparent());
            this.myManager.getUndoStacksHolder().addToStacks(undoableGroup);
        }
        this.reset();
    }

    private void reset() {
        this.myCurrentActions = new ArrayList<UndoableAction>();
        this.myAffectedDocuments = new THashSet();
        this.myLastGroupId = null;
        this.myGlobal = false;
        this.myOnlyUndoTransparents = true;
        this.myHasUndoTransparents = false;
        this.myCommandName = null;
        this.myStateAfter = null;
        this.myStateBefore = null;
        this.myUndoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
    }

    private void clearRedoStacks(CommandMerger nextMerger) {
        this.myManager.getRedoStacksHolder().clearStacks(this.myGlobal, nextMerger.myAffectedDocuments);
    }

    boolean isGlobal() {
        return this.myGlobal;
    }

    public void markAsGlobal() {
        this.myGlobal = true;
    }

    private boolean isTransparent() {
        return this.myOnlyUndoTransparents && this.myHasUndoTransparents;
    }

    private boolean affectsMultiplePhysicalDocs() {
        int count = 0;
        for (DocumentReference each : this.myAffectedDocuments) {
            VirtualFile file = each.getFile();
            if (file instanceof LightVirtualFile || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    public void undoOrRedo(FileEditor editor, boolean isUndo) {
        this.flushCurrentCommand();
        UndoRedo.execute(this.myManager, editor, isUndo);
    }

    public UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return this.myUndoConfirmationPolicy;
    }

    public boolean hasActions() {
        return !this.myCurrentActions.isEmpty();
    }

    public Collection<DocumentReference> getAffectedDocuments() {
        return this.myAffectedDocuments;
    }

    public boolean isUndoAvailable(Collection<DocumentReference> refs) {
        if (this.hasNonUndoableActions()) {
            return false;
        }
        if (refs.isEmpty()) {
            return this.myGlobal && this.hasActions();
        }
        for (DocumentReference each : refs) {
            if (!this.hasChangesOf(each)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonUndoableActions() {
        for (UndoableAction each : this.myCurrentActions) {
            if (!(each instanceof NonUndoableAction)) continue;
            return true;
        }
        return false;
    }

    private boolean hasChangesOf(DocumentReference ref) {
        for (UndoableAction action : this.myCurrentActions) {
            Object[] refs = action.getAffectedDocuments();
            if (refs != null && !ArrayUtil.contains((Object)ref, (Object[])refs)) continue;
            return true;
        }
        return false;
    }

    public void setBeforeState(EditorAndState state) {
        if (this.myStateBefore == null || !this.hasActions()) {
            this.myStateBefore = state;
        }
    }

    public void setAfterState(EditorAndState state) {
        this.myStateAfter = state;
    }

    public void mergeUndoConfirmationPolicy(UndoConfirmationPolicy undoConfirmationPolicy) {
        if (this.myUndoConfirmationPolicy == UndoConfirmationPolicy.DEFAULT) {
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
        } else if (this.myUndoConfirmationPolicy == UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION && undoConfirmationPolicy == UndoConfirmationPolicy.REQUEST_CONFIRMATION) {
            this.myUndoConfirmationPolicy = UndoConfirmationPolicy.REQUEST_CONFIRMATION;
        }
    }
}

