/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PreloadableAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ButtonToolbarImpl;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ProxyShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;

public final class ActionManagerImpl
extends ActionManagerEx
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.ActionManagerImpl");
    private static final int TIMER_DELAY = 500;
    private static final int UPDATE_DELAY_AFTER_TYPING = 500;
    private final Object myLock = new Object();
    private final THashMap<String, Object> myId2Action;
    private final THashMap<PluginId, THashSet<String>> myPlugin2Id;
    private final TObjectIntHashMap<String> myId2Index;
    private final THashMap<Object, String> myAction2Id;
    private final ArrayList<String> myNotRegisteredInternalActionIds;
    private MyTimer myTimer;
    private int myRegisteredActionsCount;
    private final ArrayList<AnActionListener> myActionListeners;
    private AnActionListener[] myCachedActionListeners = null;
    private String myLastPreformedActionId;
    private final KeymapManager myKeymapManager;
    private final DataManager myDataManager;
    private String myPrevPerformedActionId;
    private long myLastTimeEditorWasTypedIn = 0L;
    @NonNls
    public static final String ACTION_ELEMENT_NAME = "action";
    @NonNls
    public static final String GROUP_ELEMENT_NAME = "group";
    @NonNls
    public static final String ACTIONS_ELEMENT_NAME = "actions";
    @NonNls
    public static final String CLASS_ATTR_NAME = "class";
    @NonNls
    public static final String ID_ATTR_NAME = "id";
    @NonNls
    public static final String INTERNAL_ATTR_NAME = "internal";
    @NonNls
    public static final String ICON_ATTR_NAME = "icon";
    @NonNls
    public static final String ADD_TO_GROUP_ELEMENT_NAME = "add-to-group";
    @NonNls
    public static final String SHORTCUT_ELEMENT_NAME = "keyboard-shortcut";
    @NonNls
    public static final String MOUSE_SHORTCUT_ELEMENT_NAME = "mouse-shortcut";
    @NonNls
    public static final String DESCRIPTION = "description";
    @NonNls
    public static final String TEXT_ATTR_NAME = "text";
    @NonNls
    public static final String POPUP_ATTR_NAME = "popup";
    @NonNls
    public static final String SEPARATOR_ELEMENT_NAME = "separator";
    @NonNls
    public static final String REFERENCE_ELEMENT_NAME = "reference";
    @NonNls
    public static final String GROUPID_ATTR_NAME = "group-id";
    @NonNls
    public static final String ANCHOR_ELEMENT_NAME = "anchor";
    @NonNls
    public static final String FIRST = "first";
    @NonNls
    public static final String LAST = "last";
    @NonNls
    public static final String BEFORE = "before";
    @NonNls
    public static final String AFTER = "after";
    @NonNls
    public static final String SECONDARY = "secondary";
    @NonNls
    public static final String RELATIVE_TO_ACTION_ATTR_NAME = "relative-to-action";
    @NonNls
    public static final String FIRST_KEYSTROKE_ATTR_NAME = "first-keystroke";
    @NonNls
    public static final String SECOND_KEYSTROKE_ATTR_NAME = "second-keystroke";
    @NonNls
    public static final String REMOVE_SHORTCUT_ATTR_NAME = "remove";
    @NonNls
    public static final String KEYMAP_ATTR_NAME = "keymap";
    @NonNls
    public static final String KEYSTROKE_ATTR_NAME = "keystroke";
    @NonNls
    public static final String REF_ATTR_NAME = "ref";
    @NonNls
    public static final String ACTIONS_BUNDLE = "messages.ActionsBundle";
    @NonNls
    public static final String USE_SHORTCUT_OF_ATTR_NAME = "use-shortcut-of";
    private final List<ActionPopupMenuImpl> myPopups = new ArrayList<ActionPopupMenuImpl>();
    private final Map<AnAction, DataContext> myQueuedNotifications = new LinkedHashMap<AnAction, DataContext>();
    private final Map<AnAction, AnActionEvent> myQueuedNotificationsEvents = new LinkedHashMap<AnAction, AnActionEvent>();
    private Runnable myPreloadActionsRunnable;
    private static final Map<String, ResourceBundle> ourBundlesCache = new HashMap<String, ResourceBundle>();
    private int myActionsPreloaded = 0;

    ActionManagerImpl(KeymapManager keymapManager, DataManager dataManager) {
        this.myId2Action = new THashMap();
        this.myId2Index = new TObjectIntHashMap();
        this.myAction2Id = new THashMap();
        this.myPlugin2Id = new THashMap();
        this.myNotRegisteredInternalActionIds = new ArrayList();
        this.myActionListeners = new ArrayList();
        this.myKeymapManager = keymapManager;
        this.myDataManager = dataManager;
        this.registerPluginActions();
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
    }

    public void addTimerListener(int delay, TimerListener listener) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.myTimer == null) {
            this.myTimer = new MyTimer();
            this.myTimer.start();
        }
        this.myTimer.addTimerListener(listener);
    }

    public void removeTimerListener(TimerListener listener) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LOG.assertTrue(this.myTimer != null);
        this.myTimer.removeTimerListener(listener);
    }

    public ActionPopupMenu createActionPopupMenu(String place, @NotNull ActionGroup group, @Nullable PresentationFactory presentationFactory) {
        if (group == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.createActionPopupMenu must not be null");
        }
        return new ActionPopupMenuImpl(place, group, this, presentationFactory);
    }

    public ActionPopupMenu createActionPopupMenu(String place, @NotNull ActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.createActionPopupMenu must not be null");
        }
        return new ActionPopupMenuImpl(place, group, this, null);
    }

    public ActionToolbar createActionToolbar(String place, ActionGroup group, boolean horizontal) {
        return new ActionToolbarImpl(place, group, horizontal, this.myDataManager, this, (KeymapManagerEx)this.myKeymapManager);
    }

    private void registerPluginActions() {
        IdeaPluginDescriptor[] plugins;
        Application app = ApplicationManager.getApplication();
        for (IdeaPluginDescriptor plugin : plugins = app.getPlugins()) {
            List elementList;
            if (PluginManager.shouldSkipPlugin((IdeaPluginDescriptor)plugin) || (elementList = plugin.getActionsDescriptionElements()) == null) continue;
            for (Element e : elementList) {
                this.processActionsChildElement(plugin.getPluginClassLoader(), plugin.getPluginId(), e);
            }
        }
    }

    public AnAction getAction(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.getAction must not be null");
        }
        return this.getActionImpl(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnAction getActionImpl(String id, boolean canReturnStub) {
        Object object = this.myLock;
        synchronized (object) {
            AnAction action = (AnAction)this.myId2Action.get((Object)id);
            if (!canReturnStub && action instanceof ActionStub) {
                action = this.convert((ActionStub)action);
            }
            return action;
        }
    }

    private AnAction convert(ActionStub stub) {
        String iconPath;
        Object obj;
        LOG.assertTrue(this.myAction2Id.contains((Object)stub));
        this.myAction2Id.remove((Object)stub);
        LOG.assertTrue(this.myId2Action.contains((Object)stub.getId()));
        AnAction action = (AnAction)this.myId2Action.remove((Object)stub.getId());
        LOG.assertTrue(action != null);
        LOG.assertTrue(action.equals(stub));
        String className = stub.getClassName();
        try {
            Constructor<?> constructor = Class.forName(className, true, stub.getLoader()).getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            obj = constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            PluginId pluginId = stub.getPluginId();
            if (pluginId != null) {
                throw new PluginException("class with name \"" + className + "\" not found", (Throwable)e, pluginId);
            }
            throw new IllegalStateException("class with name \"" + className + "\" not found");
        }
        catch (UnsupportedClassVersionError e) {
            PluginId pluginId = stub.getPluginId();
            if (pluginId != null) {
                throw new PluginException((Throwable)e, pluginId);
            }
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            PluginId pluginId = stub.getPluginId();
            if (pluginId != null) {
                throw new PluginException("cannot create class \"" + className + "\"", (Throwable)e, pluginId);
            }
            throw new IllegalStateException("cannot create class \"" + className + "\"", e);
        }
        if (!(obj instanceof AnAction)) {
            throw new IllegalStateException("class with name \"" + className + "\" should be instance of " + AnAction.class.getName());
        }
        AnAction anAction = (AnAction)obj;
        stub.initAction(anAction);
        if (StringUtil.isNotEmpty((String)stub.getText())) {
            anAction.getTemplatePresentation().setText(stub.getText());
        }
        if ((iconPath = stub.getIconPath()) != null) {
            ActionManagerImpl.setIconFromClass(anAction.getClass(), anAction.getClass().getClassLoader(), iconPath, stub.getClassName(), anAction.getTemplatePresentation(), stub.getPluginId());
        }
        this.myId2Action.put((Object)stub.getId(), obj);
        this.myAction2Id.put(obj, (Object)stub.getId());
        return anAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.getId must not be null");
        }
        LOG.assertTrue(!(action instanceof ActionStub));
        Object object = this.myLock;
        synchronized (object) {
            return (String)this.myAction2Id.get((Object)action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getActionIds(@NotNull String idPrefix) {
        if (idPrefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.getActionIds must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<String> idList = new ArrayList<String>();
            for (String id : this.myId2Action.keySet()) {
                if (!id.startsWith(idPrefix)) continue;
                idList.add(id);
            }
            return ArrayUtil.toStringArray(idList);
        }
    }

    public boolean isGroup(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.isGroup must not be null");
        }
        return this.getActionImpl(actionId, true) instanceof ActionGroup;
    }

    public JComponent createButtonToolbar(String actionPlace, ActionGroup messageActionGroup) {
        return new ButtonToolbarImpl(actionPlace, messageActionGroup, this.myDataManager, this);
    }

    public AnAction getActionOrStub(String id) {
        return this.getActionImpl(id, true);
    }

    @Nullable
    private AnAction processActionElement(Element element, ClassLoader loader, PluginId pluginId) {
        Application app = ApplicationManager.getApplication();
        IdeaPluginDescriptor plugin = app.getPlugin(pluginId);
        ResourceBundle bundle = ActionManagerImpl.getActionsResourceBundle(loader, plugin);
        if (!ACTION_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String className = element.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null || className.length() == 0) {
            ActionManagerImpl.reportActionError(pluginId, "action element should have specified \"class\" attribute");
            return null;
        }
        String id = element.getAttributeValue(ID_ATTR_NAME);
        if (id == null || id.length() == 0) {
            ActionManagerImpl.reportActionError(pluginId, "ID of the action cannot be an empty string");
            return null;
        }
        if (Boolean.valueOf(element.getAttributeValue(INTERNAL_ATTR_NAME)).booleanValue() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
            this.myNotRegisteredInternalActionIds.add(id);
            return null;
        }
        String text = ActionManagerImpl.loadTextForElement(element, bundle, id, ACTION_ELEMENT_NAME);
        String iconPath = element.getAttributeValue(ICON_ATTR_NAME);
        if (text == null) {
            String message = "'text' attribute is mandatory (action ID=" + id + ";" + (plugin == null ? "" : " plugin path: " + plugin.getPath()) + ")";
            ActionManagerImpl.reportActionError(pluginId, message);
            return null;
        }
        ActionStub stub = new ActionStub(className, id, text, loader, pluginId, iconPath);
        Presentation presentation = stub.getTemplatePresentation();
        presentation.setText(text);
        presentation.setDescription(ActionManagerImpl.loadDescriptionForElement(element, bundle, id, ACTION_ELEMENT_NAME));
        for (Object o : element.getChildren()) {
            Element e = (Element)o;
            if (ADD_TO_GROUP_ELEMENT_NAME.equals(e.getName())) {
                this.processAddToGroupNode((AnAction)stub, e, pluginId, ActionManagerImpl.isSecondary(e));
                continue;
            }
            if (SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                this.processKeyboardShortcutNode(e, id, pluginId);
                continue;
            }
            if (MOUSE_SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processMouseShortcutNode(e, id, pluginId);
                continue;
            }
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + e.getName() + "\"");
            return null;
        }
        if (element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME) != null) {
            ((KeymapManagerEx)this.myKeymapManager).bindShortcuts(element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME), id);
        }
        this.registerAction(id, (AnAction)stub, pluginId);
        return stub;
    }

    private static ResourceBundle getActionsResourceBundle(ClassLoader loader, IdeaPluginDescriptor plugin) {
        String resBundleName = plugin != null && !plugin.getPluginId().getIdString().equals("com.intellij") ? plugin.getResourceBundleBaseName() : ACTIONS_BUNDLE;
        ResourceBundle bundle = null;
        if (resBundleName != null) {
            bundle = ActionManagerImpl.getBundle(loader, resBundleName);
        }
        return bundle;
    }

    private static boolean isSecondary(Element element) {
        return "true".equalsIgnoreCase(element.getAttributeValue(SECONDARY));
    }

    private static void setIcon(@Nullable String iconPath, String className, ClassLoader loader, Presentation presentation, PluginId pluginId) {
        if (iconPath == null) {
            return;
        }
        try {
            Class<?> actionClass = Class.forName(className, true, loader);
            ActionManagerImpl.setIconFromClass(actionClass, loader, iconPath, className, presentation, pluginId);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" not found");
        }
        catch (NoClassDefFoundError e) {
            LOG.error((Throwable)e);
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" not found");
        }
    }

    private static void setIconFromClass(@NotNull Class actionClass, @NotNull ClassLoader classLoader, @NotNull String iconPath, String className, Presentation presentation, PluginId pluginId) {
        if (actionClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.setIconFromClass must not be null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.setIconFromClass must not be null");
        }
        if (iconPath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.setIconFromClass must not be null");
        }
        Icon icon = IconLoader.findIcon((String)iconPath, (Class)actionClass);
        if (icon == null) {
            icon = IconLoader.findIcon((String)iconPath, (ClassLoader)classLoader);
        }
        if (icon == null) {
            ActionManagerImpl.reportActionError(pluginId, "Icon cannot be found in '" + iconPath + "', action class='" + className + "'");
        } else {
            presentation.setIcon(icon);
        }
    }

    private static String loadDescriptionForElement(Element element, ResourceBundle bundle, String id, String elementType) {
        String value = element.getAttributeValue(DESCRIPTION);
        if (bundle != null) {
            String key = elementType + "." + id + ".description";
            return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)key, (String)(value == null ? "" : value), (Object[])new Object[0]);
        }
        return value;
    }

    private static String loadTextForElement(Element element, ResourceBundle bundle, String id, String elementType) {
        String value = element.getAttributeValue(TEXT_ATTR_NAME);
        return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)(elementType + "." + id + "." + TEXT_ATTR_NAME), (String)(value == null ? "" : value), (Object[])new Object[0]);
    }

    private AnAction processGroupElement(Element element, ClassLoader loader, PluginId pluginId) {
        Application app = ApplicationManager.getApplication();
        IdeaPluginDescriptor plugin = app.getPlugin(pluginId);
        ResourceBundle bundle = ActionManagerImpl.getActionsResourceBundle(loader, plugin);
        if (!GROUP_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String className = element.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null) {
            className = DefaultActionGroup.class.getName();
        }
        try {
            String description;
            Class<?> aClass = Class.forName(className, true, loader);
            Object obj = new ConstructorInjectionComponentAdapter((Object)className, aClass).getComponentInstance(ApplicationManager.getApplication().getPicoContainer());
            if (!(obj instanceof ActionGroup)) {
                ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" should be instance of " + ActionGroup.class.getName());
                return null;
            }
            if (element.getChildren().size() != element.getChildren(ADD_TO_GROUP_ELEMENT_NAME).size() && !(obj instanceof DefaultActionGroup)) {
                ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" should be instance of " + DefaultActionGroup.class.getName() + " because there are children specified");
                return null;
            }
            ActionGroup group = (ActionGroup)obj;
            String id = element.getAttributeValue(ID_ATTR_NAME);
            if (id != null && id.length() == 0) {
                ActionManagerImpl.reportActionError(pluginId, "ID of the group cannot be an empty string");
                return null;
            }
            if (Boolean.valueOf(element.getAttributeValue(INTERNAL_ATTR_NAME)).booleanValue() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
                this.myNotRegisteredInternalActionIds.add(id);
                return null;
            }
            if (id != null) {
                this.registerAction(id, (AnAction)group);
            }
            Presentation presentation = group.getTemplatePresentation();
            String text = ActionManagerImpl.loadTextForElement(element, bundle, id, GROUP_ELEMENT_NAME);
            if (!StringUtil.isEmpty((String)text) || presentation.getText() == null) {
                presentation.setText(text);
            }
            if (!StringUtil.isEmpty((String)(description = ActionManagerImpl.loadDescriptionForElement(element, bundle, id, GROUP_ELEMENT_NAME))) || presentation.getDescription() == null) {
                presentation.setDescription(description);
            }
            ActionManagerImpl.setIcon(element.getAttributeValue(ICON_ATTR_NAME), className, loader, presentation, pluginId);
            String popup = element.getAttributeValue(POPUP_ATTR_NAME);
            if (popup != null) {
                group.setPopup(Boolean.valueOf(popup).booleanValue());
            }
            for (Object o : element.getChildren()) {
                AnAction action;
                Element child = (Element)o;
                String name = child.getName();
                if (ACTION_ELEMENT_NAME.equals(name)) {
                    action = this.processActionElement(child, loader, pluginId);
                    if (action == null) continue;
                    ActionManagerImpl.assertActionIsGroupOrStub(action);
                    ((DefaultActionGroup)group).addAction(action, Constraints.LAST, (ActionManager)this).setAsSecondary(ActionManagerImpl.isSecondary(child));
                    continue;
                }
                if (SEPARATOR_ELEMENT_NAME.equals(name)) {
                    this.processSeparatorNode((DefaultActionGroup)group, child, pluginId);
                    continue;
                }
                if (GROUP_ELEMENT_NAME.equals(name)) {
                    action = this.processGroupElement(child, loader, pluginId);
                    if (action == null) continue;
                    ((DefaultActionGroup)group).add(action, (ActionManager)this);
                    continue;
                }
                if (ADD_TO_GROUP_ELEMENT_NAME.equals(name)) {
                    this.processAddToGroupNode((AnAction)group, child, pluginId, ActionManagerImpl.isSecondary(child));
                    continue;
                }
                if (REFERENCE_ELEMENT_NAME.equals(name)) {
                    action = this.processReferenceElement(child, pluginId);
                    if (action == null) continue;
                    ((DefaultActionGroup)group).addAction(action, Constraints.LAST, (ActionManager)this).setAsSecondary(ActionManagerImpl.isSecondary(child));
                    continue;
                }
                ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + name + "\n");
                return null;
            }
            return group;
        }
        catch (ClassNotFoundException e) {
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" not found");
            return null;
        }
        catch (NoClassDefFoundError e) {
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + e.getMessage() + "\" not found");
            return null;
        }
        catch (UnsupportedClassVersionError e) {
            ActionManagerImpl.reportActionError(pluginId, "unsupported class version for " + className);
            return null;
        }
        catch (Exception e) {
            String message = "cannot create class \"" + className + "\"";
            if (pluginId == null) {
                LOG.error(message, (Throwable)e);
            } else {
                LOG.error((Throwable)new PluginException(message, (Throwable)e, pluginId));
            }
            return null;
        }
    }

    private void processReferenceNode(Element element, PluginId pluginId) {
        AnAction action = this.processReferenceElement(element, pluginId);
        for (Object o : element.getChildren()) {
            Element child = (Element)o;
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child.getName())) continue;
            this.processAddToGroupNode(action, child, pluginId, ActionManagerImpl.isSecondary(child));
        }
    }

    private static ResourceBundle getBundle(ClassLoader loader, String resBundleName) {
        if (ourBundlesCache.containsKey(resBundleName)) {
            return ourBundlesCache.get(resBundleName);
        }
        ResourceBundle bundle = ResourceBundle.getBundle(resBundleName, Locale.getDefault(), loader);
        ourBundlesCache.put(resBundleName, bundle);
        return bundle;
    }

    private void processAddToGroupNode(AnAction action, Element element, PluginId pluginId, boolean secondary) {
        String actionName;
        if (!(action instanceof Separator)) {
            ActionManagerImpl.assertActionIsGroupOrStub(action);
        }
        String string = actionName = action instanceof ActionStub ? ((ActionStub)action).getClassName() : action.getClass().getName();
        if (!ADD_TO_GROUP_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return;
        }
        AnAction parentGroup = this.getParentGroup(element.getAttributeValue(GROUPID_ATTR_NAME), actionName, pluginId);
        if (parentGroup == null) {
            return;
        }
        Anchor anchor = ActionManagerImpl.parseAnchor(element.getAttributeValue(ANCHOR_ELEMENT_NAME), actionName, pluginId);
        if (anchor == null) {
            return;
        }
        String relativeToActionId = element.getAttributeValue(RELATIVE_TO_ACTION_ATTR_NAME);
        if (!ActionManagerImpl.checkRelativeToAction(relativeToActionId, anchor, actionName, pluginId)) {
            return;
        }
        DefaultActionGroup group = (DefaultActionGroup)parentGroup;
        group.addAction(action, new Constraints(anchor, relativeToActionId), (ActionManager)this).setAsSecondary(secondary);
    }

    public static boolean checkRelativeToAction(String relativeToActionId, @NotNull Anchor anchor, @NotNull String actionName, @Nullable PluginId pluginId) {
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.checkRelativeToAction must not be null");
        }
        if (actionName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.checkRelativeToAction must not be null");
        }
        if ((Anchor.BEFORE == anchor || Anchor.AFTER == anchor) && relativeToActionId == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": \"relative-to-action\" cannot be null if anchor is \"after\" or \"before\"");
            return false;
        }
        return true;
    }

    @Nullable
    public static Anchor parseAnchor(String anchorStr, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (anchorStr == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": attribute \"anchor\" should be defined");
            return null;
        }
        if (FIRST.equalsIgnoreCase(anchorStr)) {
            return Anchor.FIRST;
        }
        if (LAST.equalsIgnoreCase(anchorStr)) {
            return Anchor.LAST;
        }
        if (BEFORE.equalsIgnoreCase(anchorStr)) {
            return Anchor.BEFORE;
        }
        if (AFTER.equalsIgnoreCase(anchorStr)) {
            return Anchor.AFTER;
        }
        ActionManagerImpl.reportActionError(pluginId, actionName + ": anchor should be one of the following constants: \"first\", \"last\", \"before\" or \"after\"");
        return null;
    }

    @Nullable
    public AnAction getParentGroup(String groupId, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (groupId == null || groupId.length() == 0) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": attribute \"group-id\" should be defined");
            return null;
        }
        AnAction parentGroup = this.getActionImpl(groupId, true);
        if (parentGroup == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": action with id \"" + groupId + "\" isn't registered; action will be added to the \"Other\" group");
            parentGroup = this.getActionImpl("OtherMenu", true);
        }
        if (!(parentGroup instanceof DefaultActionGroup)) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": action with id \"" + groupId + "\" should be instance of " + DefaultActionGroup.class.getName() + " but was " + parentGroup.getClass());
            return null;
        }
        return parentGroup;
    }

    private void processSeparatorNode(DefaultActionGroup parentGroup, Element element, PluginId pluginId) {
        if (!SEPARATOR_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return;
        }
        Separator separator = Separator.getInstance();
        if (parentGroup != null) {
            parentGroup.add((AnAction)separator, (ActionManager)this);
        }
        for (Object o : element.getChildren()) {
            Element child = (Element)o;
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child.getName())) continue;
            this.processAddToGroupNode((AnAction)separator, child, pluginId, ActionManagerImpl.isSecondary(child));
        }
    }

    private void processKeyboardShortcutNode(Element element, String actionId, PluginId pluginId) {
        String firstStrokeString = element.getAttributeValue(FIRST_KEYSTROKE_ATTR_NAME);
        if (firstStrokeString == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        KeyStroke firstKeyStroke = ActionManagerImpl.getKeyStroke(firstStrokeString);
        if (firstKeyStroke == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        KeyStroke secondKeyStroke = null;
        String secondStrokeString = element.getAttributeValue(SECOND_KEYSTROKE_ATTR_NAME);
        if (secondStrokeString != null && (secondKeyStroke = ActionManagerImpl.getKeyStroke(secondStrokeString)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"second-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.trim().length() == 0) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap = this.myKeymapManager.getKeymap(keymapName);
        if (keymap == null) {
            ActionManagerImpl.reportActionError(pluginId, "keymap \"" + keymapName + "\" not found");
            return;
        }
        String removeOption = element.getAttributeValue(REMOVE_SHORTCUT_ATTR_NAME);
        KeyboardShortcut shortcut = new KeyboardShortcut(firstKeyStroke, secondKeyStroke);
        if (Boolean.valueOf(removeOption).booleanValue()) {
            keymap.removeShortcut(actionId, (Shortcut)shortcut);
        } else {
            keymap.addShortcut(actionId, (Shortcut)shortcut);
        }
    }

    private static void processMouseShortcutNode(Element element, String actionId, PluginId pluginId) {
        MouseShortcut shortcut;
        String keystrokeString = element.getAttributeValue(KEYSTROKE_ATTR_NAME);
        if (keystrokeString == null || keystrokeString.trim().length() == 0) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        try {
            shortcut = KeymapUtil.parseMouseShortcut((String)keystrokeString);
        }
        catch (Exception ex) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.length() == 0) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap = KeymapManager.getInstance().getKeymap(keymapName);
        if (keymap == null) {
            ActionManagerImpl.reportActionError(pluginId, "keymap \"" + keymapName + "\" not found");
            return;
        }
        String removeOption = element.getAttributeValue(REMOVE_SHORTCUT_ATTR_NAME);
        if (Boolean.valueOf(removeOption).booleanValue()) {
            keymap.removeShortcut(actionId, (Shortcut)shortcut);
        } else {
            keymap.addShortcut(actionId, (Shortcut)shortcut);
        }
    }

    @Nullable
    private AnAction processReferenceElement(Element element, PluginId pluginId) {
        if (!REFERENCE_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String ref = element.getAttributeValue(REF_ATTR_NAME);
        if (ref == null) {
            ref = element.getAttributeValue(ID_ATTR_NAME);
        }
        if (ref == null || ref.length() == 0) {
            ActionManagerImpl.reportActionError(pluginId, "ID of reference element should be defined");
            return null;
        }
        AnAction action = this.getActionImpl(ref, true);
        if (action == null) {
            if (!this.myNotRegisteredInternalActionIds.contains(ref)) {
                ActionManagerImpl.reportActionError(pluginId, "action specified by reference isn't registered (ID=" + ref + ")");
            }
            return null;
        }
        ActionManagerImpl.assertActionIsGroupOrStub(action);
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processActionsElement(Element element, ClassLoader loader, PluginId pluginId) {
        if (!ACTIONS_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            for (Object o : element.getChildren()) {
                Element child = (Element)o;
                this.processActionsChildElement(loader, pluginId, child);
            }
        }
    }

    private void processActionsChildElement(ClassLoader loader, PluginId pluginId, Element child) {
        String name = child.getName();
        if (ACTION_ELEMENT_NAME.equals(name)) {
            AnAction action = this.processActionElement(child, loader, pluginId);
            if (action != null) {
                ActionManagerImpl.assertActionIsGroupOrStub(action);
            }
        } else if (GROUP_ELEMENT_NAME.equals(name)) {
            this.processGroupElement(child, loader, pluginId);
        } else if (SEPARATOR_ELEMENT_NAME.equals(name)) {
            this.processSeparatorNode(null, child, pluginId);
        } else if (REFERENCE_ELEMENT_NAME.equals(name)) {
            this.processReferenceNode(child, pluginId);
        } else {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + name + "\n");
        }
    }

    private static void assertActionIsGroupOrStub(AnAction action) {
        if (!(action instanceof ActionGroup) && !(action instanceof ActionStub)) {
            LOG.error("Action : " + action + "; class: " + action.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAction(@NotNull String actionId, @NotNull AnAction action, @Nullable PluginId pluginId) {
        if (actionId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.registerAction must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.registerAction must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myId2Action.containsKey((Object)actionId)) {
                ActionManagerImpl.reportActionError(pluginId, "action with the ID \"" + actionId + "\" was already registered. Action being registered is " + action.toString() + "; Registered action is " + this.myId2Action.get((Object)actionId) + ActionManagerImpl.getPluginInfo(pluginId));
                return;
            }
            if (this.myAction2Id.containsKey((Object)action)) {
                ActionManagerImpl.reportActionError(pluginId, "action was already registered for another ID. ID is " + (String)this.myAction2Id.get((Object)action) + ActionManagerImpl.getPluginInfo(pluginId));
                return;
            }
            this.myId2Action.put((Object)actionId, (Object)action);
            this.myId2Index.put((Object)actionId, this.myRegisteredActionsCount++);
            this.myAction2Id.put((Object)action, (Object)actionId);
            if (pluginId != null && !(action instanceof ActionGroup)) {
                THashSet pluginActionIds = (THashSet)this.myPlugin2Id.get((Object)pluginId);
                if (pluginActionIds == null) {
                    pluginActionIds = new THashSet();
                    this.myPlugin2Id.put((Object)pluginId, (Object)pluginActionIds);
                }
                pluginActionIds.add((Object)actionId);
            }
            action.registerCustomShortcutSet((ShortcutSet)new ProxyShortcutSet(actionId, this.myKeymapManager), null);
        }
    }

    private static void reportActionError(PluginId pluginId, @NonNls String message) {
        if (pluginId == null) {
            LOG.error(message);
        } else {
            LOG.error((Throwable)new PluginException(message, null, pluginId));
        }
    }

    @NonNls
    private static String getPluginInfo(@Nullable PluginId id) {
        IdeaPluginDescriptor plugin;
        if (id != null && (plugin = ApplicationManager.getApplication().getPlugin(id)) != null) {
            String name = plugin.getName();
            if (name == null) {
                name = id.getIdString();
            }
            return " Plugin: " + name;
        }
        return "";
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action) {
        if (actionId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.registerAction must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.registerAction must not be null");
        }
        this.registerAction(actionId, action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAction(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.unregisterAction must not be null");
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myId2Action.containsKey((Object)actionId) && LOG.isDebugEnabled()) {
                LOG.debug("action with ID " + actionId + " wasn't registered");
                return;
            }
            AnAction oldValue = (AnAction)this.myId2Action.remove((Object)actionId);
            this.myAction2Id.remove((Object)oldValue);
            this.myId2Index.remove((Object)actionId);
            for (PluginId pluginName : this.myPlugin2Id.keySet()) {
                THashSet pluginActions = (THashSet)this.myPlugin2Id.get((Object)pluginName);
                if (pluginActions == null) continue;
                pluginActions.remove((Object)actionId);
            }
        }
    }

    @NotNull
    public String getComponentName() {
        if ("ActionManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/actionSystem/impl/ActionManagerImpl.getComponentName must not return null");
        }
        return "ActionManager";
    }

    @Override
    public Comparator<String> getRegistrationOrderComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String id1, String id2) {
                return ActionManagerImpl.this.myId2Index.get((Object)id1) - ActionManagerImpl.this.myId2Index.get((Object)id2);
            }
        };
    }

    @Override
    public String[] getPluginActions(PluginId pluginName) {
        if (this.myPlugin2Id.containsKey((Object)pluginName)) {
            THashSet pluginActions = (THashSet)this.myPlugin2Id.get((Object)pluginName);
            return ArrayUtil.toStringArray((Collection)pluginActions);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void addActionPopup(ActionPopupMenuImpl menu) {
        this.myPopups.add(menu);
    }

    public void removeActionPopup(ActionPopupMenuImpl menu) {
        boolean removed = this.myPopups.remove(menu);
        if (removed && this.myPopups.isEmpty()) {
            this.flushActionPerformed();
        }
    }

    @Override
    public void queueActionPerformedEvent(AnAction action, DataContext context, AnActionEvent event) {
        if (!this.myPopups.isEmpty()) {
            this.myQueuedNotifications.put(action, context);
        } else {
            this.fireAfterActionPerformed(action, context, event);
        }
    }

    @Override
    public boolean isActionPopupStackEmpty() {
        return this.myPopups.isEmpty();
    }

    private void flushActionPerformed() {
        Set<AnAction> actions = this.myQueuedNotifications.keySet();
        for (AnAction eachAction : actions) {
            DataContext eachContext = this.myQueuedNotifications.get(eachAction);
            this.fireAfterActionPerformed(eachAction, eachContext, this.myQueuedNotificationsEvents.get(eachAction));
        }
        this.myQueuedNotifications.clear();
        this.myQueuedNotificationsEvents.clear();
    }

    private AnActionListener[] getActionListeners() {
        if (this.myCachedActionListeners == null) {
            this.myCachedActionListeners = this.myActionListeners.toArray(new AnActionListener[this.myActionListeners.size()]);
        }
        return this.myCachedActionListeners;
    }

    @Override
    public void addAnActionListener(AnActionListener listener) {
        this.myActionListeners.add(listener);
        this.myCachedActionListeners = null;
    }

    @Override
    public void addAnActionListener(final AnActionListener listener, Disposable parentDisposable) {
        this.addAnActionListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ActionManagerImpl.this.removeAnActionListener(listener);
            }
        });
    }

    @Override
    public void removeAnActionListener(AnActionListener listener) {
        this.myActionListeners.remove(listener);
        this.myCachedActionListeners = null;
    }

    @Override
    public void fireBeforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        AnActionListener[] listeners;
        if (action != null) {
            this.myPrevPerformedActionId = this.myLastPreformedActionId;
            IdeaLogger.ourLastActionId = this.myLastPreformedActionId = this.getId(action);
        }
        for (AnActionListener listener : listeners = this.getActionListeners()) {
            listener.beforeActionPerformed(action, dataContext, event);
        }
    }

    @Override
    public void fireAfterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        AnActionListener[] listeners;
        if (action != null) {
            this.myPrevPerformedActionId = this.myLastPreformedActionId;
            IdeaLogger.ourLastActionId = this.myLastPreformedActionId = this.getId(action);
        }
        for (AnActionListener listener : listeners = this.getActionListeners()) {
            try {
                listener.afterActionPerformed(action, dataContext, event);
            }
            catch (AbstractMethodError e) {
                // empty catch block
            }
        }
    }

    @Override
    public KeyboardShortcut getKeyboardShortcut(@NotNull String actionId) {
        Shortcut[] shortcuts;
        if (actionId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.getKeyboardShortcut must not be null");
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        ShortcutSet shortcutSet = action.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyboardShortcut kb;
            if (!(shortcut instanceof KeyboardShortcut) || (kb = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            return (KeyboardShortcut)shortcut;
        }
        return null;
    }

    @Override
    public void fireBeforeEditorTyping(char c, DataContext dataContext) {
        AnActionListener[] listeners;
        this.myLastTimeEditorWasTypedIn = System.currentTimeMillis();
        for (AnActionListener listener : listeners = this.getActionListeners()) {
            listener.beforeEditorTyping(c, dataContext);
        }
    }

    @Override
    public String getLastPreformedActionId() {
        return this.myLastPreformedActionId;
    }

    @Override
    public String getPrevPreformedActionId() {
        return this.myPrevPerformedActionId;
    }

    public Set<String> getActionIds() {
        return new HashSet<String>(this.myId2Action.keySet());
    }

    public void preloadActions() {
        if (this.myPreloadActionsRunnable == null) {
            this.myPreloadActionsRunnable = new Runnable(){

                @Override
                public void run() {
                    ActionManagerImpl.this.doPreloadActions();
                }
            };
            ApplicationManager.getApplication().executeOnPooledThread(this.myPreloadActionsRunnable);
        }
    }

    private void doPreloadActions() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.preloadActionGroup("EditorPopupMenu");
        this.preloadActionGroup("EditorTabPopupMenu");
        this.preloadActionGroup("ProjectViewPopupMenu");
        this.preloadActionGroup("MainMenu");
        LOG.debug("Actions preloading completed");
    }

    public void preloadActionGroup(String groupId) {
        AnAction action = this.getAction(groupId);
        if (action instanceof ActionGroup) {
            this.preloadActionGroup((ActionGroup)action);
        }
    }

    private void preloadActionGroup(final ActionGroup group) {
        AnAction[] children;
        for (AnAction action : children = (AnAction[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<AnAction[]>(){

            public AnAction[] compute() {
                if (ApplicationManager.getApplication().isDisposed()) {
                    return AnAction.EMPTY_ARRAY;
                }
                return group.getChildren(null);
            }
        })) {
            if (action instanceof PreloadableAction) {
                ((PreloadableAction)action).preload();
            } else if (action instanceof ActionGroup) {
                this.preloadActionGroup((ActionGroup)action);
            }
            ++this.myActionsPreloaded;
            if (this.myActionsPreloaded % 10 != 0) continue;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public ActionCallback tryToExecute(final @NotNull AnAction action, final @NotNull InputEvent inputEvent, final @Nullable Component contextComponent, final @Nullable String place, boolean now) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.tryToExecute must not be null");
        }
        if (inputEvent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionManagerImpl.tryToExecute must not be null");
        }
        Application app = ApplicationManager.getApplication();
        assert (app.isDispatchThread());
        final ActionCallback result = new ActionCallback();
        Runnable doRunnable = new Runnable(){

            @Override
            public void run() {
                ActionManagerImpl.this.tryToExecuteNow(action, inputEvent, contextComponent, place, result);
            }
        };
        if (now) {
            doRunnable.run();
        } else {
            SwingUtilities.invokeLater(doRunnable);
        }
        return result;
    }

    private void tryToExecuteNow(final AnAction action, final InputEvent inputEvent, final Component contextComponent, final String place, final ActionCallback result) {
        final Presentation presenation = (Presentation)action.getTemplatePresentation().clone();
        IdeFocusManager.findInstanceByContext((DataContext)ActionManagerImpl.getContextBy(contextComponent)).doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                DataContext context = ActionManagerImpl.getContextBy(contextComponent);
                AnActionEvent event = new AnActionEvent(inputEvent, context, place != null ? place : "unknown", presenation, (ActionManager)ActionManagerImpl.this, inputEvent.getModifiersEx());
                ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)event, (boolean)false);
                if (!event.getPresentation().isEnabled()) {
                    result.setRejected();
                    return;
                }
                ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false);
                if (!event.getPresentation().isEnabled()) {
                    result.setRejected();
                    return;
                }
                Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
                if (component != null && !component.isShowing()) {
                    result.setRejected();
                    return;
                }
                ActionManagerImpl.this.fireBeforeActionPerformed(action, context, event);
                UIUtil.addAwtListener((AWTEventListener)new AWTEventListener(){

                    @Override
                    public void eventDispatched(AWTEvent event) {
                        if (!(event.getID() != 200 && event.getID() != 205 || result.isProcessed())) {
                            WindowEvent we = (WindowEvent)event;
                            IdeFocusManager.findInstanceByComponent((Component)we.getWindow()).doWhenFocusSettlesDown(new Runnable(){

                                @Override
                                public void run() {
                                    result.setDone();
                                }
                            });
                        }
                    }
                }, (long)64L, (Disposable)result);
                action.actionPerformed(event);
                result.setDone();
                ActionManagerImpl.this.queueActionPerformedEvent(action, context, event);
            }
        });
    }

    private static DataContext getContextBy(Component contextComponent) {
        DataManager dataManager = DataManager.getInstance();
        return contextComponent != null ? dataManager.getDataContext(contextComponent) : dataManager.getDataContext();
    }

    private class MyTimer
    extends Timer
    implements ActionListener {
        private final List<TimerListener> myTimerListeners;
        private int myLastTimePerformed;

        MyTimer() {
            super(500, null);
            this.myTimerListeners = Collections.synchronizedList(new ArrayList());
            this.addActionListener(this);
            this.setRepeats(true);
        }

        public void addTimerListener(TimerListener listener) {
            this.myTimerListeners.add(listener);
        }

        public void removeTimerListener(TimerListener listener) {
            this.myTimerListeners.remove(listener);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ActionManagerImpl.this.myLastTimeEditorWasTypedIn + 500L > System.currentTimeMillis()) {
                return;
            }
            int lastEventCount = this.myLastTimePerformed;
            this.myLastTimePerformed = ActivityTracker.getInstance().getCount();
            if (this.myLastTimePerformed == lastEventCount) {
                return;
            }
            final TimerListener[] listeners = this.myTimerListeners.toArray(new TimerListener[this.myTimerListeners.size()]);
            IdeFocusManager.getInstance(null).doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    for (TimerListener listener : listeners) {
                        if (!MyTimer.this.myTimerListeners.contains(listener)) continue;
                        MyTimer.this.runListenerAction(listener);
                    }
                }
            });
        }

        private void runListenerAction(TimerListener listener) {
            ModalityState modalityState = listener.getModalityState();
            if (modalityState == null) {
                return;
            }
            if (!ModalityState.current().dominates(modalityState)) {
                try {
                    listener.run();
                }
                catch (ProcessCanceledException ex) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }
}

