/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.lexer._JavaLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;

public class JavaLexer
extends LexerBase {
    private CharSequence myBuffer;
    private int myBufferIndex;
    private int myBufferEndOffset;
    private IElementType myTokenType;
    private _JavaLexer myFlexlexer;
    private int myTokenEndOffset;
    private final HashTable myTable;
    private static final HashTable ourTableWithoutAssert = new HashTable(false, false);
    private static final HashTable ourTableWithAssert = new HashTable(true, false);
    private static final HashTable ourTableWithAssertAndJDK15 = new HashTable(true, true);
    private static final HashTable ourTableWithJDK15 = new HashTable(false, true);

    private JavaLexer(boolean isAssertKeywordEnabled, boolean isJDK15) {
        this.myTable = JavaLexer.getTable(isAssertKeywordEnabled, isJDK15);
        this.myFlexlexer = new _JavaLexer(isAssertKeywordEnabled, isJDK15);
    }

    public JavaLexer(LanguageLevel level) {
        this(level.hasAssertKeyword(), level.hasEnumKeywordAndAutoboxing());
    }

    private static HashTable getTable(boolean isAssertKeywordEnabled, boolean isJDK15) {
        return isAssertKeywordEnabled ? (isJDK15 ? ourTableWithAssertAndJDK15 : ourTableWithAssert) : (isJDK15 ? ourTableWithJDK15 : ourTableWithoutAssert);
    }

    private static HashTable getTable(LanguageLevel level) {
        return JavaLexer.getTable(level.hasAssertKeyword(), level.hasEnumKeywordAndAutoboxing());
    }

    public static boolean isKeyword(String id, LanguageLevel level) {
        return JavaLexer.getTable(level).contains(id);
    }

    public final void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myBufferIndex = startOffset;
        this.myBufferEndOffset = endOffset;
        this.myTokenType = null;
        this.myTokenEndOffset = startOffset;
        this.myFlexlexer.reset(this.myBuffer, startOffset, endOffset, 0);
    }

    public int getState() {
        return 0;
    }

    public final IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public final int getTokenStart() {
        return this.myBufferIndex;
    }

    public final int getTokenEnd() {
        this.locateToken();
        return this.myTokenEndOffset;
    }

    public final void advance() {
        this.locateToken();
        this.myTokenType = null;
    }

    protected final void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        this._locateToken();
    }

    private void _locateToken() {
        if (this.myTokenEndOffset == this.myBufferEndOffset) {
            this.myTokenType = null;
            this.myBufferIndex = this.myBufferEndOffset;
            return;
        }
        this.myBufferIndex = this.myTokenEndOffset;
        char c = this.myBuffer.charAt(this.myBufferIndex);
        switch (c) {
            default: {
                this.flexLocateToken();
                break;
            }
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this.myTokenType = TokenType.WHITE_SPACE;
                this.myTokenEndOffset = this.getWhitespaces(this.myBufferIndex + 1);
                break;
            }
            case '/': {
                if (this.myBufferIndex + 1 >= this.myBufferEndOffset) {
                    this.myTokenType = JavaTokenType.DIV;
                    this.myTokenEndOffset = this.myBufferEndOffset;
                    break;
                }
                char nextChar = this.myBuffer.charAt(this.myBufferIndex + 1);
                if (nextChar == '/') {
                    this.myTokenType = JavaTokenType.END_OF_LINE_COMMENT;
                    this.myTokenEndOffset = this.getLineTerminator(this.myBufferIndex + 2);
                    break;
                }
                if (nextChar == '*') {
                    if (this.myBufferIndex + 2 >= this.myBufferEndOffset || this.myBuffer.charAt(this.myBufferIndex + 2) != '*') {
                        this.myTokenType = JavaTokenType.C_STYLE_COMMENT;
                        this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + 2);
                        break;
                    }
                    this.myTokenType = JavaTokenType.DOC_COMMENT;
                    this.myTokenEndOffset = this.getDocClosingComment(this.myBufferIndex + 3);
                    break;
                }
                if (c > '\u007f' && Character.isJavaIdentifierStart(c)) {
                    this.myTokenEndOffset = this.getIdentifier(this.myBufferIndex + 1);
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '\"': 
            case '\'': {
                this.myTokenType = c == '\"' ? JavaTokenType.STRING_LITERAL : JavaTokenType.CHARACTER_LITERAL;
                this.myTokenEndOffset = this.getClosingParenthesys(this.myBufferIndex + 1, c);
            }
        }
        if (this.myTokenEndOffset > this.myBufferEndOffset) {
            this.myTokenEndOffset = this.myBufferEndOffset;
        }
    }

    private int getWhitespaces(int pos) {
        if (pos >= this.myBufferEndOffset) {
            return this.myBufferEndOffset;
        }
        CharSequence lBuffer = this.myBuffer;
        char c = lBuffer.charAt(pos);
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f') {
            if (++pos == this.myBufferEndOffset) {
                return pos;
            }
            c = lBuffer.charAt(pos);
        }
        return pos;
    }

    private void flexLocateToken() {
        try {
            this.myFlexlexer.goTo(this.myBufferIndex);
            this.myTokenType = this.myFlexlexer.advance();
            this.myTokenEndOffset = this.myFlexlexer.getTokenEnd();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getClosingParenthesys(int offset, char c) {
        int pos;
        block6: {
            pos = offset;
            int lBufferEnd = this.myBufferEndOffset;
            if (pos >= lBufferEnd) {
                return lBufferEnd;
            }
            CharSequence lBuffer = this.myBuffer;
            char cur = lBuffer.charAt(pos);
            while (true) {
                if (cur != c && cur != '\n' && cur != '\r' && cur != '\\') {
                    if (++pos >= lBufferEnd) {
                        return lBufferEnd;
                    }
                    cur = lBuffer.charAt(pos);
                    continue;
                }
                if (cur != '\\') break;
                if (++pos >= lBufferEnd) {
                    return lBufferEnd;
                }
                cur = lBuffer.charAt(pos);
                if (cur == '\n' || cur == '\r') continue;
                if (++pos >= lBufferEnd) {
                    return lBufferEnd;
                }
                cur = lBuffer.charAt(pos);
            }
            if (cur == c) break block6;
            --pos;
        }
        return pos + 1;
    }

    private int getDocClosingComment(int offset) {
        char c;
        int pos;
        int lBufferEnd = this.myBufferEndOffset;
        CharSequence lBuffer = this.myBuffer;
        if (offset < lBufferEnd && lBuffer.charAt(offset) == '/') {
            return offset + 1;
        }
        for (pos = offset; pos < lBufferEnd - 1 && ((c = lBuffer.charAt(pos)) != '*' || lBuffer.charAt(pos + 1) != '/'); ++pos) {
        }
        return pos + 2;
    }

    private int getClosingComment(int offset) {
        char c;
        int pos;
        int lBufferEnd = this.myBufferEndOffset;
        CharSequence lBuffer = this.myBuffer;
        for (pos = offset; pos < lBufferEnd - 1 && ((c = lBuffer.charAt(pos)) != '*' || lBuffer.charAt(pos + 1) != '/'); ++pos) {
        }
        return pos + 2;
    }

    private int getLineTerminator(int offset) {
        char c;
        int pos;
        int lBufferEnd = this.myBufferEndOffset;
        CharSequence lBuffer = this.myBuffer;
        for (pos = offset; pos < lBufferEnd && (c = lBuffer.charAt(pos)) != '\r' && c != '\n'; ++pos) {
        }
        return pos;
    }

    private int getIdentifier(int offset) {
        CharSequence lBuffer = this.myBuffer;
        int hashCode = lBuffer.charAt(offset - 1) * 2;
        int pos = offset;
        int lBufferEnd = this.myBufferEndOffset;
        if (pos < lBufferEnd) {
            char c = lBuffer.charAt(pos);
            while (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$' || c > '\u007f' && Character.isJavaIdentifierPart(c)) {
                hashCode += c;
                if (++pos == lBufferEnd) break;
                c = lBuffer.charAt(pos);
            }
        }
        this.myTokenType = this.myTable.contains(hashCode, lBuffer, offset - 1) ? this.myTable.getTokenType(hashCode) : JavaTokenType.IDENTIFIER;
        return pos;
    }

    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    public final int getBufferEnd() {
        return this.myBufferEndOffset;
    }

    public static void main(String[] args) throws IOException {
        File root = new File(args[0]);
        Stats stats = new Stats();
        JavaLexer.walk(root, stats);
        System.out.println("Scanned " + stats.files + " files, total of " + stats.lines + " lines in " + stats.time / 1000000L + " ms.");
        System.out.println("Size:" + stats.bytes);
    }

    private static void lex(File root, Stats stats) throws IOException {
        String s;
        ++stats.files;
        BufferedReader reader = new BufferedReader(new FileReader(root));
        StringBuilder buf = new StringBuilder();
        while ((s = reader.readLine()) != null) {
            ++stats.lines;
            buf.append(s).append("\n");
        }
        stats.bytes += (long)buf.length();
        long start = System.nanoTime();
        JavaLexer.lexText(buf);
        stats.time += System.nanoTime() - start;
    }

    private static void lexText(StringBuilder buf) {
        JavaLexer lexer = new JavaLexer(LanguageLevel.JDK_1_5);
        lexer.start(buf);
        while (lexer.getTokenType() != null) {
            lexer.advance();
        }
    }

    private static void walk(File root, Stats stats) throws IOException {
        if (root.isDirectory()) {
            System.out.println("Lexing in " + root.getPath());
            for (File file : root.listFiles()) {
                JavaLexer.walk(file, stats);
            }
        } else if (root.getName().endsWith(".java")) {
            JavaLexer.lex(root, stats);
        }
    }

    private static class Stats {
        public int files;
        public int lines;
        public long time;
        public long bytes;

        private Stats() {
        }
    }

    private static final class HashTable {
        private static final int NUM_ENTRIES = 999;
        private static final Logger LOG = Logger.getInstance((String)"com.intellij.Lexer.JavaLexer");
        private final char[][] myTable = new char[999][];
        private final IElementType[] myKeywords = new IElementType[999];
        private final Set<String> myKeywordsInSet = new THashSet();

        private void add(String s, IElementType tokenType) {
            char[] chars = s.toCharArray();
            int hashCode = chars[0] * 2;
            for (int j = 1; j < chars.length; ++j) {
                hashCode += chars[j];
            }
            int modHashCode = hashCode % 999;
            LOG.assertTrue(this.myTable[modHashCode] == null);
            this.myTable[modHashCode] = chars;
            this.myKeywords[modHashCode] = tokenType;
            this.myKeywordsInSet.add(s);
        }

        public boolean contains(String s) {
            return this.myKeywordsInSet.contains(s);
        }

        private boolean contains(int hashCode, CharSequence buffer, int offset) {
            int modHashCode = hashCode % 999;
            char[] kwd = this.myTable[modHashCode];
            if (kwd == null) {
                return false;
            }
            for (int j = 0; j < kwd.length; ++j) {
                if (buffer.charAt(j + offset) == kwd[j]) continue;
                return false;
            }
            return true;
        }

        private IElementType getTokenType(int hashCode) {
            return this.myKeywords[hashCode % 999];
        }

        private HashTable(boolean isAssertKeywordEnabled, boolean isJDK15) {
            if (isAssertKeywordEnabled) {
                this.add("assert", JavaTokenType.ASSERT_KEYWORD);
            }
            if (isJDK15) {
                this.add("enum", JavaTokenType.ENUM_KEYWORD);
            }
            this.add("abstract", JavaTokenType.ABSTRACT_KEYWORD);
            this.add("default", JavaTokenType.DEFAULT_KEYWORD);
            this.add("if", JavaTokenType.IF_KEYWORD);
            this.add("private", JavaTokenType.PRIVATE_KEYWORD);
            this.add("this", JavaTokenType.THIS_KEYWORD);
            this.add("boolean", JavaTokenType.BOOLEAN_KEYWORD);
            this.add("do", JavaTokenType.DO_KEYWORD);
            this.add("implements", JavaTokenType.IMPLEMENTS_KEYWORD);
            this.add("protected", JavaTokenType.PROTECTED_KEYWORD);
            this.add("throw", JavaTokenType.THROW_KEYWORD);
            this.add("break", JavaTokenType.BREAK_KEYWORD);
            this.add("double", JavaTokenType.DOUBLE_KEYWORD);
            this.add("import", JavaTokenType.IMPORT_KEYWORD);
            this.add("public", JavaTokenType.PUBLIC_KEYWORD);
            this.add("throws", JavaTokenType.THROWS_KEYWORD);
            this.add("byte", JavaTokenType.BYTE_KEYWORD);
            this.add("else", JavaTokenType.ELSE_KEYWORD);
            this.add("instanceof", JavaTokenType.INSTANCEOF_KEYWORD);
            this.add("return", JavaTokenType.RETURN_KEYWORD);
            this.add("transient", JavaTokenType.TRANSIENT_KEYWORD);
            this.add("case", JavaTokenType.CASE_KEYWORD);
            this.add("extends", JavaTokenType.EXTENDS_KEYWORD);
            this.add("int", JavaTokenType.INT_KEYWORD);
            this.add("short", JavaTokenType.SHORT_KEYWORD);
            this.add("try", JavaTokenType.TRY_KEYWORD);
            this.add("catch", JavaTokenType.CATCH_KEYWORD);
            this.add("final", JavaTokenType.FINAL_KEYWORD);
            this.add("interface", JavaTokenType.INTERFACE_KEYWORD);
            this.add("static", JavaTokenType.STATIC_KEYWORD);
            this.add("void", JavaTokenType.VOID_KEYWORD);
            this.add("char", JavaTokenType.CHAR_KEYWORD);
            this.add("finally", JavaTokenType.FINALLY_KEYWORD);
            this.add("long", JavaTokenType.LONG_KEYWORD);
            this.add("strictfp", JavaTokenType.STRICTFP_KEYWORD);
            this.add("volatile", JavaTokenType.VOLATILE_KEYWORD);
            this.add("class", JavaTokenType.CLASS_KEYWORD);
            this.add("float", JavaTokenType.FLOAT_KEYWORD);
            this.add("native", JavaTokenType.NATIVE_KEYWORD);
            this.add("super", JavaTokenType.SUPER_KEYWORD);
            this.add("while", JavaTokenType.WHILE_KEYWORD);
            this.add("const", JavaTokenType.CONST_KEYWORD);
            this.add("for", JavaTokenType.FOR_KEYWORD);
            this.add("new", JavaTokenType.NEW_KEYWORD);
            this.add("switch", JavaTokenType.SWITCH_KEYWORD);
            this.add("continue", JavaTokenType.CONTINUE_KEYWORD);
            this.add("goto", JavaTokenType.GOTO_KEYWORD);
            this.add("package", JavaTokenType.PACKAGE_KEYWORD);
            this.add("synchronized", JavaTokenType.SYNCHRONIZED_KEYWORD);
            this.add("true", JavaTokenType.TRUE_KEYWORD);
            this.add("false", JavaTokenType.FALSE_KEYWORD);
            this.add("null", JavaTokenType.NULL_KEYWORD);
        }
    }
}

