/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlTagUtil;

public class XMLExternalAnnotator
implements ExternalAnnotator,
Validator.ValidationHost {
    private AnnotationHolder myHolder;
    private static final Validator.ValidationHost.ErrorType[] types = Validator.ValidationHost.ErrorType.values();

    public void annotate(PsiFile file, AnnotationHolder holder) {
        XmlNSDescriptor nsDescriptor;
        if (!(file instanceof XmlFile)) {
            return;
        }
        this.myHolder = holder;
        XmlDocument document = ((XmlFile)file).getDocument();
        if (document == null) {
            return;
        }
        XmlTag rootTag = document.getRootTag();
        XmlNSDescriptor xmlNSDescriptor = nsDescriptor = rootTag == null ? null : rootTag.getNSDescriptor(rootTag.getNamespace(), false);
        if (nsDescriptor instanceof Validator) {
            ((Validator)nsDescriptor).validate(document, this);
        }
    }

    @Override
    public void addMessage(PsiElement context, String message, int type) {
        this.addMessage(context, message, types[type], new IntentionAction[0]);
    }

    @Override
    public void addMessage(PsiElement context, String message, Validator.ValidationHost.ErrorType type, IntentionAction ... fixes) {
        if (message != null && message.length() > 0) {
            if (context instanceof XmlTag) {
                this.addMessagesForTag((XmlTag)context, message, type, fixes);
            } else if (type == Validator.ValidationHost.ErrorType.ERROR) {
                XMLExternalAnnotator.appendFixes(this.myHolder.createErrorAnnotation(context, message), fixes);
            } else {
                XMLExternalAnnotator.appendFixes(this.myHolder.createWarningAnnotation(context, message), fixes);
            }
        }
    }

    private void addMessagesForTag(XmlTag tag, String message, Validator.ValidationHost.ErrorType type, IntentionAction ... actions) {
        XmlToken childByRole = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        this.addMessagesForTreeChild(childByRole, type, message, actions);
        childByRole = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
        this.addMessagesForTreeChild(childByRole, type, message, actions);
    }

    private void addMessagesForTreeChild(XmlToken childByRole, Validator.ValidationHost.ErrorType type, String message, IntentionAction ... actions) {
        if (childByRole != null) {
            Annotation annotation = type == Validator.ValidationHost.ErrorType.ERROR ? this.myHolder.createErrorAnnotation((PsiElement)childByRole, message) : this.myHolder.createWarningAnnotation((PsiElement)childByRole, message);
            XMLExternalAnnotator.appendFixes(annotation, actions);
        }
    }

    private static void appendFixes(Annotation annotation, IntentionAction ... actions) {
        if (actions != null) {
            for (IntentionAction action : actions) {
                annotation.registerFix(action);
            }
        }
    }
}

