/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NamePathComponent
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.projectWizard.NamePathComponent");
    private JTextField myTfName = new JTextField();
    private JTextField myTfPath;
    private boolean myIsNameChangedByUser = false;
    private boolean myIsPathChangedByUser = false;
    private boolean myIsPathNameSyncEnabled = true;
    private boolean myIsNamePathSyncEnabled = true;
    private boolean myIsSyncEnabled = true;
    private FieldPanel myPathPanel;
    private JLabel myNameLabel;
    private boolean myForceSync;

    public NamePathComponent(String nameLabelText, String pathLabelText, char nameMnemonic, char locationMnemonic, String pathChooserTitle, String pathChooserDescription) {
        this(nameLabelText, pathLabelText, pathChooserTitle, pathChooserDescription, true);
    }

    public NamePathComponent(String nameLabelText, String pathLabelText, String pathChooserTitle, String pathChooserDescription, boolean hideIgnored) {
        this(nameLabelText, pathLabelText, pathChooserTitle, pathChooserDescription, hideIgnored, true);
    }

    public NamePathComponent(String nameLabelText, String pathLabelText, String pathChooserTitle, String pathChooserDescription, boolean hideIgnored, boolean bold) {
        super(new GridBagLayout());
        this.myTfName.setDocument(new NameFieldDocument());
        this.myTfName.setPreferredSize(new Dimension(200, this.myTfName.getPreferredSize().height));
        this.myTfPath = new JTextField();
        this.myTfPath.setDocument(new PathFieldDocument());
        this.myTfPath.setPreferredSize(new Dimension(200, this.myTfPath.getPreferredSize().height));
        this.myNameLabel = new JLabel(nameLabelText);
        if (bold) {
            this.myNameLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        }
        this.myNameLabel.setLabelFor(this.myTfName);
        this.add((Component)this.myNameLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.myTfName, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 8, 0), 0, 0));
        FileChooserDescriptor chooserDescriptor = (FileChooserDescriptor)BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR.clone();
        chooserDescriptor.setHideIgnored(hideIgnored);
        BrowseFilesListener browseButtonActionListener = new BrowseFilesListener(this.myTfPath, pathChooserTitle, pathChooserDescription, chooserDescriptor){

            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                NamePathComponent.this.myIsPathChangedByUser = true;
            }
        };
        this.myPathPanel = new FieldPanel(this.myTfPath, pathLabelText, null, (ActionListener)browseButtonActionListener, null);
        JLabel locationLabel = this.myPathPanel.getFieldLabel();
        locationLabel.setLabelFor(this.myTfPath);
        if (bold) {
            locationLabel.setFont(UIUtil.getLabelFont().deriveFont(1));
        }
        this.add((Component)this.myPathPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 0, 0, 0), 0, 0));
    }

    public String getNameValue() {
        return this.myTfName.getText().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNameValue(String name) {
        boolean isNameChangedByUser = this.myIsNameChangedByUser;
        this.setNamePathSyncEnabled(false);
        try {
            this.myTfName.setText(name);
        }
        finally {
            this.myIsNameChangedByUser = isNameChangedByUser;
            this.setNamePathSyncEnabled(true);
        }
    }

    public String getPath() {
        return this.myTfPath.getText().trim().replace(File.separatorChar, '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String path) {
        boolean isPathChangedByUser = this.myIsPathChangedByUser;
        this.setPathNameSyncEnabled(false);
        try {
            this.myTfPath.setText(path);
        }
        finally {
            this.myIsPathChangedByUser = isPathChangedByUser;
            this.setPathNameSyncEnabled(true);
        }
    }

    public JTextField getNameComponent() {
        return this.myTfName;
    }

    public JTextField getPathComponent() {
        return this.myTfPath;
    }

    public void setPathComponentVisible(boolean visible) {
        this.myPathPanel.setVisible(visible);
    }

    public void setNameComponentVisible(boolean visible) {
        this.myTfName.setVisible(visible);
        this.myNameLabel.setVisible(visible);
    }

    public boolean isNameChangedByUser() {
        return this.myIsNameChangedByUser;
    }

    public boolean isPathChangedByUser() {
        return this.myIsPathChangedByUser;
    }

    public boolean isSyncEnabled() {
        return this.myIsSyncEnabled;
    }

    public void setSyncEnabled(boolean isSyncEnabled) {
        this.myIsSyncEnabled = isSyncEnabled;
    }

    private boolean isPathNameSyncEnabled() {
        if (!this.isSyncEnabled()) {
            return false;
        }
        return this.myIsPathNameSyncEnabled;
    }

    private void setPathNameSyncEnabled(boolean isPathNameSyncEnabled) {
        this.myIsPathNameSyncEnabled = isPathNameSyncEnabled;
    }

    private boolean isNamePathSyncEnabled() {
        if (!this.isSyncEnabled()) {
            return false;
        }
        return this.myIsNamePathSyncEnabled;
    }

    private void setNamePathSyncEnabled(boolean isNamePathSyncEnabled) {
        this.myIsNamePathSyncEnabled = isNamePathSyncEnabled;
    }

    public void syncNameToPath(boolean b) {
        this.myForceSync = b;
        if (b) {
            ((PathFieldDocument)this.myTfPath.getDocument()).syncPathAndName();
        }
    }

    private class PathFieldDocument
    extends PlainDocument {
        public PathFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(DocumentEvent event) {
                    NamePathComponent.this.myIsPathChangedByUser = true;
                    PathFieldDocument.this.syncPathAndName();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncPathAndName() {
            if (NamePathComponent.this.isPathNameSyncEnabled() && (NamePathComponent.this.myForceSync || !NamePathComponent.this.myIsNameChangedByUser)) {
                try {
                    NamePathComponent.this.setNamePathSyncEnabled(false);
                    String path = this.getText(0, this.getLength());
                    int lastSeparatorIndex = path.lastIndexOf(File.separator);
                    if (lastSeparatorIndex >= 0 && lastSeparatorIndex + 1 < path.length()) {
                        NamePathComponent.this.setNameValue(path.substring(lastSeparatorIndex + 1));
                    }
                }
                catch (BadLocationException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    NamePathComponent.this.setNamePathSyncEnabled(true);
                }
            }
        }
    }

    private class NameFieldDocument
    extends PlainDocument {
        public NameFieldDocument() {
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void textChanged(DocumentEvent event) {
                    NamePathComponent.this.myIsNameChangedByUser = true;
                    NameFieldDocument.this.syncNameAndPath();
                }
            });
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            boolean ok = true;
            for (int idx = 0; idx < str.length() && ok; ++idx) {
                char ch = str.charAt(idx);
                ok = ch != File.separatorChar && ch != '\\' && ch != '/' && ch != '|' && ch != ':';
            }
            if (ok) {
                super.insertString(offs, str, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncNameAndPath() {
            if (NamePathComponent.this.isNamePathSyncEnabled() && (NamePathComponent.this.myForceSync || !NamePathComponent.this.myIsPathChangedByUser)) {
                try {
                    NamePathComponent.this.setPathNameSyncEnabled(false);
                    String name = this.getText(0, this.getLength());
                    String path = NamePathComponent.this.myTfPath.getText().trim();
                    int lastSeparatorIndex = path.lastIndexOf(File.separator);
                    if (lastSeparatorIndex >= 0) {
                        NamePathComponent.this.setPath(path.substring(0, lastSeparatorIndex + 1) + name);
                    }
                }
                catch (BadLocationException e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    NamePathComponent.this.setPathNameSyncEnabled(true);
                }
            }
        }
    }
}

