/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.PsiClassChildrenSource;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeClassChooserDialog
extends DialogWrapper
implements TreeClassChooser {
    private Tree myTree;
    private PsiClass mySelectedClass = null;
    private final Project myProject;
    private BaseProjectTreeBuilder myBuilder;
    private TabbedPaneWrapper myTabbedPane;
    private ChooseByNamePanel myGotoByNamePanel;
    private final GlobalSearchScope myScope;
    @NotNull
    private final TreeClassChooser.ClassFilter myClassFilter;
    private final PsiClass myBaseClass;
    private PsiClass myInitialClass;
    private final PsiClassChildrenSource myClassChildrens;

    public TreeClassChooserDialog(String title, Project project) {
        this(title, project, null);
    }

    public TreeClassChooserDialog(String title, Project project, PsiClass initialClass) {
        this(title, project, GlobalSearchScope.projectScope((Project)project), null, initialClass);
    }

    public TreeClassChooserDialog(String title, Project project, GlobalSearchScope scope, TreeClassChooser.ClassFilter classFilter, PsiClass initialClass) {
        this(title, project, scope, classFilter, null, initialClass, PsiClassChildrenSource.NONE);
    }

    public TreeClassChooserDialog(String title, Project project, GlobalSearchScope scope, TreeClassChooser.ClassFilter classFilter, PsiClass baseClass, PsiClass initialClass, PsiClassChildrenSource classChildrens) {
        super(project, true);
        this.myScope = scope;
        this.myClassFilter = classFilter == null ? TreeClassChooser.ClassFilter.ALL : classFilter;
        this.myBaseClass = baseClass;
        this.myInitialClass = initialClass;
        this.myClassChildrens = classChildrens;
        this.setTitle(title);
        this.myProject = project;
        this.init();
        if (initialClass != null) {
            this.selectClass(initialClass);
        }
        this.handleSelectionChanged();
    }

    public static TreeClassChooserDialog withInnerClasses(String title, Project project, GlobalSearchScope scope, final TreeClassChooser.ClassFilter classFilter, PsiClass initialClass) {
        return new TreeClassChooserDialog(title, project, scope, classFilter, null, initialClass, new PsiClassChildrenSource(){

            @Override
            public void addChildren(PsiClass psiClass, List<PsiElement> children) {
                ArrayList<PsiElement> innerClasses = new ArrayList<PsiElement>();
                PsiClassChildrenSource.CLASSES.addChildren(psiClass, innerClasses);
                for (PsiElement innerClass : innerClasses) {
                    if (!classFilter.isAccepted((PsiClass)innerClass)) continue;
                    children.add(innerClass);
                }
            }
        });
    }

    protected JComponent createCenterPanel() {
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model);
        AbstractProjectTreeStructure treeStructure = new AbstractProjectTreeStructure(this.myProject){

            public boolean isFlattenPackages() {
                return false;
            }

            @Override
            public boolean isShowMembers() {
                return TreeClassChooserDialog.this.myClassChildrens != PsiClassChildrenSource.NONE;
            }

            public boolean isHideEmptyMiddlePackages() {
                return true;
            }

            public boolean isAbbreviatePackageNames() {
                return false;
            }

            public boolean isShowLibraryContents() {
                return true;
            }

            public boolean isShowModules() {
                return false;
            }
        };
        this.myBuilder = new ProjectTreeBuilder(this.myProject, (JTree)this.myTree, model, AlphaComparator.INSTANCE, treeStructure);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.expandRow(0);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        JScrollPane scrollPane = new JScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize(new Dimension(500, 300));
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    TreeClassChooserDialog.this.doOKAction();
                }
            }
        });
        this.myTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (e.getClickCount() == 2 && (path = TreeClassChooserDialog.this.myTree.getPathForLocation(e.getX(), e.getY())) != null && TreeClassChooserDialog.this.myTree.isPathSelected(path)) {
                    TreeClassChooserDialog.this.doOKAction();
                }
            }
        });
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeClassChooserDialog.this.handleSelectionChanged();
            }
        });
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTabbedPane = new TabbedPaneWrapper(this.getDisposable());
        final JPanel dummyPanel = new JPanel(new BorderLayout());
        String name = null;
        this.myGotoByNamePanel = new ChooseByNamePanel(this.myProject, this.createChooseByNameModel(), name, this.myScope.isSearchInLibraries(), (PsiElement)this.getContext()){

            @Override
            protected void showTextFieldPanel() {
            }

            @Override
            protected void close(boolean isOk) {
                super.close(isOk);
                if (isOk) {
                    TreeClassChooserDialog.this.doOKAction();
                } else {
                    TreeClassChooserDialog.this.doCancelAction();
                }
            }

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback, modalityState, allowMultipleSelection);
                dummyPanel.add((Component)TreeClassChooserDialog.this.myGotoByNamePanel.getPanel(), "Center");
                IdeFocusTraversalPolicy.getPreferredFocusedComponent(TreeClassChooserDialog.this.myGotoByNamePanel.getPanel()).requestFocus();
            }

            @Override
            protected void showList() {
                super.showList();
                if (TreeClassChooserDialog.this.myInitialClass != null && this.myList.getModel().getSize() > 0) {
                    this.myList.setSelectedValue(TreeClassChooserDialog.this.myInitialClass, true);
                    TreeClassChooserDialog.this.myInitialClass = null;
                }
            }

            @Override
            protected void choosenElementMightChange() {
                TreeClassChooserDialog.this.handleSelectionChanged();
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myGotoByNamePanel);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.search.by.name", (Object[])new Object[0]), dummyPanel);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.project", (Object[])new Object[0]), scrollPane);
        this.myGotoByNamePanel.invoke(new MyCallback(), this.getModalityState(), false);
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TreeClassChooserDialog.this.handleSelectionChanged();
            }
        });
        return this.myTabbedPane.getComponent();
    }

    protected ChooseByNameModel createChooseByNameModel() {
        return this.myBaseClass == null ? new MyGotoClassModel(this.myProject) : new SubclassGotoClassModel(this.myProject);
    }

    private void handleSelectionChanged() {
        PsiClass selection = this.calcSelectedClass();
        this.setOKActionEnabled(selection != null);
    }

    protected void doOKAction() {
        this.mySelectedClass = this.calcSelectedClass();
        if (this.mySelectedClass == null) {
            return;
        }
        if (!this.myClassFilter.isAccepted(this.mySelectedClass)) {
            Messages.showErrorDialog((Component)this.myTabbedPane.getComponent(), (String)(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)this.mySelectedClass) + " is not acceptable"));
            return;
        }
        super.doOKAction();
    }

    public PsiClass getSelectedClass() {
        return this.mySelectedClass;
    }

    public void selectClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/TreeClassChooserDialog.selectClass must not be null");
        }
        this.selectElementInTree((PsiElement)aClass);
    }

    public void selectDirectory(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/TreeClassChooserDialog.selectDirectory must not be null");
        }
        this.selectElementInTree((PsiElement)directory);
    }

    public void showDialog() {
        this.show();
    }

    public void showPopup() {
        ChooseByNamePopup popup = ChooseByNamePopup.createPopup(this.myProject, this.createChooseByNameModel(), (PsiElement)this.getContext());
        popup.invoke(new ChooseByNamePopupComponent.Callback(){

            public void elementChosen(Object element) {
                TreeClassChooserDialog.this.mySelectedClass = (PsiClass)element;
                ((Navigatable)element).navigate(true);
            }
        }, this.getModalityState(), true);
    }

    private PsiClass getContext() {
        return this.myBaseClass != null ? this.myBaseClass : (this.myInitialClass != null ? this.myInitialClass : null);
    }

    private void selectElementInTree(final @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/TreeClassChooserDialog.selectElementInTree must not be null");
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TreeClassChooserDialog.this.myBuilder == null) {
                    return;
                }
                VirtualFile vFile = PsiUtilBase.getVirtualFile((PsiElement)element);
                TreeClassChooserDialog.this.myBuilder.select(element, vFile, false);
            }
        }, this.getModalityState());
    }

    private ModalityState getModalityState() {
        return ModalityState.stateForComponent((Component)this.getRootPane());
    }

    @Nullable
    private PsiClass calcSelectedClass() {
        if (this.myTabbedPane.getSelectedIndex() == 0) {
            return (PsiClass)this.myGotoByNamePanel.getChosenElement();
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ClassTreeNode)) {
            return null;
        }
        ClassTreeNode descriptor = (ClassTreeNode)((Object)userObject);
        return descriptor.getPsiClass();
    }

    public void dispose() {
        if (this.myBuilder != null) {
            Disposer.dispose((Disposable)this.myBuilder);
            this.myBuilder = null;
        }
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.TreeClassChooserDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGotoByNamePanel.getPreferredFocusedComponent();
    }

    public static class InheritanceClassFilterImpl
    implements TreeClassChooser.InheritanceClassFilter {
        private final PsiClass myBase;
        private final boolean myAcceptsSelf;
        private final boolean myAcceptsInner;
        private final Condition<? super PsiClass> myAdditionalCondition;

        public InheritanceClassFilterImpl(PsiClass base, boolean acceptsSelf, boolean acceptInner, Condition<? super PsiClass> additionalCondition) {
            this.myAcceptsSelf = acceptsSelf;
            this.myAcceptsInner = acceptInner;
            if (additionalCondition == null) {
                additionalCondition = Conditions.alwaysTrue();
            }
            this.myAdditionalCondition = additionalCondition;
            this.myBase = base;
        }

        public boolean isAccepted(PsiClass aClass) {
            if (!this.myAcceptsInner && !(aClass.getParent() instanceof PsiJavaFile)) {
                return false;
            }
            if (!this.myAdditionalCondition.value((Object)aClass)) {
                return false;
            }
            return this.myAcceptsSelf || !aClass.getManager().areElementsEquivalent((PsiElement)aClass, (PsiElement)this.myBase);
        }
    }

    private class MyCallback
    extends ChooseByNamePopupComponent.Callback {
        private MyCallback() {
        }

        public void elementChosen(Object element) {
            TreeClassChooserDialog.this.mySelectedClass = (PsiClass)element;
            TreeClassChooserDialog.this.close(0);
        }
    }

    private class SubclassGotoClassModel
    extends MyGotoClassModel {
        public SubclassGotoClassModel(Project project) {
            super(project);
            assert (TreeClassChooserDialog.this.myBaseClass != null);
        }

        @Override
        public String[] getNames(boolean checkBoxState) {
            return JavaPsiFacade.getInstance((Project)this.myProject).getShortNamesCache().getAllClassNames();
        }

        @Override
        protected boolean isAccepted(PsiClass aClass) {
            return (aClass == TreeClassChooserDialog.this.myBaseClass || aClass.isInheritor(TreeClassChooserDialog.this.myBaseClass, true)) && TreeClassChooserDialog.this.myClassFilter.isAccepted(aClass);
        }
    }

    private class MyGotoClassModel
    extends GotoClassModel2 {
        public MyGotoClassModel(Project project) {
            super(project);
        }

        @Override
        public Object[] getElementsByName(String name, boolean checkBoxState, String pattern) {
            PsiShortNamesCache cache = JavaPsiFacade.getInstance((Project)this.myProject).getShortNamesCache();
            PsiClass[] classes = cache.getClassesByName(name, checkBoxState ? TreeClassChooserDialog.this.myScope : GlobalSearchScope.projectScope((Project)this.myProject).intersectWith(TreeClassChooserDialog.this.myScope));
            if (classes.length == 0) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            if (classes.length == 1) {
                return this.isAccepted(classes[0]) ? classes : ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            ArrayList<PsiClass> list = new ArrayList<PsiClass>(classes.length);
            for (PsiClass aClass : classes) {
                if (!this.isAccepted(aClass)) continue;
                list.add(aClass);
            }
            return list.toArray(new PsiClass[list.size()]);
        }

        @Override
        @Nullable
        public String getPromptText() {
            return null;
        }

        protected boolean isAccepted(PsiClass aClass) {
            return TreeClassChooserDialog.this.myClassFilter.isAccepted(aClass);
        }
    }
}

