/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.xml;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.impl.xml.DtdFileTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlFileTreeElement;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class XmlStructureViewTreeModel
extends TextEditorBasedStructureViewModel {
    private final XmlFile myFile;
    private static final Class[] myClasses = new Class[]{XmlTag.class, XmlFile.class, XmlEntityDecl.class, XmlElementDecl.class, XmlAttlistDecl.class, XmlConditionalSection.class};
    private static Sorter[] mySorters = new Sorter[]{Sorter.ALPHA_SORTER};

    public XmlStructureViewTreeModel(XmlFile file) {
        super((PsiFile)file);
        this.myFile = file;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public StructureViewTreeElement getRoot() {
        PsiTreeElementBase psiTreeElementBase;
        if (this.myFile.getLanguage() == DTDLanguage.INSTANCE) {
            psiTreeElementBase = new DtdFileTreeElement(this.myFile);
            if (psiTreeElementBase == null) throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/xml/XmlStructureViewTreeModel.getRoot must not return null");
            return psiTreeElementBase;
        }
        psiTreeElementBase = new XmlFileTreeElement(this.myFile);
        if (psiTreeElementBase != null) return psiTreeElementBase;
        throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/xml/XmlStructureViewTreeModel.getRoot must not return null");
    }

    public boolean shouldEnterElement(Object element) {
        return element instanceof XmlTag && ((XmlTag)element).getSubTags().length > 0;
    }

    protected PsiFile getPsiFile() {
        return this.myFile;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        if (myClasses == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/xml/XmlStructureViewTreeModel.getSuitableClasses must not return null");
        }
        return myClasses;
    }

    public Object getCurrentEditorElement() {
        Object editorElement = super.getCurrentEditorElement();
        if (editorElement instanceof XmlTag) {
            Collection<StructureViewExtension> structureViewExtensions = StructureViewFactoryEx.getInstanceEx(this.myFile.getProject()).getAllExtensions(XmlTag.class);
            for (StructureViewExtension extension : structureViewExtensions) {
                Object element = extension.getCurrentEditorElement(this.getEditor(), (PsiElement)editorElement);
                if (element == null) continue;
                return element;
            }
        }
        return editorElement;
    }

    @NotNull
    public Sorter[] getSorters() {
        if (mySorters == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/xml/XmlStructureViewTreeModel.getSorters must not return null");
        }
        return mySorters;
    }
}

