/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.net.IOExceptionDialog;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;

public class ActionInstallPlugin
extends AnAction
implements DumbAware {
    private static final String updateMessage = IdeBundle.message((String)"action.update.plugin", (Object[])new Object[0]);
    private final PluginManagerMain host;

    public ActionInstallPlugin(PluginManagerMain mgr) {
        super(IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/install.png"));
        this.host = mgr;
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        Presentation presentation = e.getPresentation();
        IdeaPluginDescriptor[] selection = this.getPluginTable().getSelectedObjects();
        boolean bl = enabled = selection != null;
        if (enabled) {
            for (IdeaPluginDescriptor descr : selection) {
                presentation.setText(IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
                presentation.setDescription(IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]));
                if (descr instanceof PluginNode) {
                    int status = PluginManagerColumnInfo.getRealNodeState((PluginNode)descr);
                    enabled &= status != 5;
                    if (((PluginNode)descr).getStatus() != 1) continue;
                    presentation.setText(updateMessage);
                    presentation.setDescription(updateMessage);
                    continue;
                }
                if (!(descr instanceof IdeaPluginDescriptorImpl)) continue;
                presentation.setText(updateMessage);
                presentation.setDescription(updateMessage);
                PluginId id = descr.getPluginId();
                enabled = enabled && InstalledPluginsTableModel.hasNewerVersion(id);
            }
        }
        presentation.setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        IdeaPluginDescriptor[] selection = this.getPluginTable().getSelectedObjects();
        if (this.userConfirm(selection)) {
            ArrayList<PluginNode> list = new ArrayList<PluginNode>();
            for (IdeaPluginDescriptor descr : selection) {
                PluginNode pluginNode = null;
                if (descr instanceof PluginNode) {
                    pluginNode = (PluginNode)descr;
                } else if (descr instanceof IdeaPluginDescriptorImpl) {
                    pluginNode = new PluginNode(descr.getPluginId());
                    pluginNode.setName(descr.getName());
                    pluginNode.setDepends(Arrays.asList(descr.getDependentPluginIds()));
                    pluginNode.setSize("-1");
                }
                if (pluginNode == null) continue;
                list.add(pluginNode);
            }
            try {
                if (PluginManagerMain.downloadPlugins(list)) {
                    this.host.getInstalledPluginsModel().modifyData(new ArrayList<IdeaPluginDescriptor>(list));
                    this.host.setRequireShutdown(true);
                }
            }
            catch (IOException e1) {
                PluginManagerMain.LOG.error((Throwable)e1);
                IOExceptionDialog.showErrorDialog((String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), (String)IdeBundle.message((String)"error.plugin.download.failed", (Object[])new Object[0]));
            }
            this.getPluginTable().updateUI();
        }
    }

    public PluginTable getPluginTable() {
        return this.host.getPluginTable();
    }

    private boolean userConfirm(IdeaPluginDescriptor[] selection) {
        String message = selection.length == 1 ? (selection[0] instanceof IdeaPluginDescriptorImpl ? IdeBundle.message((String)"prompt.update.plugin", (Object[])new Object[]{selection[0].getName()}) : IdeBundle.message((String)"prompt.download.and.install.plugin", (Object[])new Object[]{selection[0].getName()})) : IdeBundle.message((String)"prompt.install.several.plugins", (Object[])new Object[]{selection.length});
        return Messages.showYesNoDialog((Component)this.host.getMainPanel(), (String)message, (String)IdeBundle.message((String)"action.download.and.install.plugin", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
    }
}

