/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.LinkedHashSet;
import java.util.Set;

@State(name="GotoFileConfiguration", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class GotoFileConfiguration
implements PersistentStateComponent<FileTypes> {
    private FileTypes fileTypes = new FileTypes();

    public FileTypes getState() {
        return this.fileTypes;
    }

    public void loadState(FileTypes state) {
        this.fileTypes = state;
    }

    public void setFileTypeVisible(FileType type, boolean value) {
        if (value) {
            this.fileTypes.getFilteredOutFileTypeNames().remove(type.getName());
        } else {
            this.fileTypes.getFilteredOutFileTypeNames().add(type.getName());
        }
    }

    public boolean isFileTypeVisible(FileType type) {
        return !this.fileTypes.getFilteredOutFileTypeNames().contains(type.getName());
    }

    public static GotoFileConfiguration getInstance(Project project) {
        return (GotoFileConfiguration)ServiceManager.getService((Project)project, GotoFileConfiguration.class);
    }

    public static class FileTypes {
        private Set<String> filteredOutFileTypeNames = new LinkedHashSet<String>();

        @Tag(value="file-type-list")
        @AbstractCollection(elementTag="filtered-out-file-type", elementValueAttribute="name", surroundWithTag=false)
        public Set<String> getFilteredOutFileTypeNames() {
            return this.filteredOutFileTypeNames;
        }

        public void setFilteredOutFileTypeNames(Set<String> fileTypeNames) {
            this.filteredOutFileTypeNames = fileTypeNames;
        }
    }
}

