/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public class CloseAllEditorsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(final AnActionEvent e) {
        final Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, new Runnable(){

            @Override
            public void run() {
                VirtualFile[] openFiles;
                EditorWindow window = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
                if (window != null) {
                    VirtualFile[] files;
                    for (VirtualFile file : files = window.getFiles()) {
                        window.closeFile(file);
                    }
                    return;
                }
                FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project);
                VirtualFile selectedFile = fileEditorManager.getSelectedFiles()[0];
                for (VirtualFile openFile : openFiles = fileEditorManager.getSiblings(selectedFile)) {
                    fileEditorManager.closeFile(openFile);
                }
            }
        }, IdeBundle.message((String)"command.close.all.editors", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        EditorWindow editorWindow = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        if (editorWindow != null && editorWindow.inSplitter()) {
            presentation.setText(IdeBundle.message((String)"action.close.all.editors.in.tab.group", (Object[])new Object[0]));
        } else {
            presentation.setText(IdeBundle.message((String)"action.close.all.editors", (Object[])new Object[0]));
        }
        Project project = (Project)event.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(FileEditorManager.getInstance((Project)project).getSelectedFiles().length > 0);
    }
}

