/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralSettingsConfigurable
extends CompositeConfigurable<Configurable>
implements SearchableConfigurable {
    public static ExtensionPointName<Configurable> EP_NAME = ExtensionPointName.create((String)"com.intellij.generalOptionsProvider");
    private MyComponent myComponent;

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        GeneralSettings settings = GeneralSettings.getInstance();
        settings.setReopenLastProject(this.myComponent.myChkReopenLastProject.isSelected());
        settings.setSyncOnFrameActivation(this.myComponent.myChkSyncOnFrameActivation.isSelected());
        settings.setSaveOnFrameDeactivation(this.myComponent.myChkSaveOnFrameDeactivation.isSelected());
        settings.setConfirmExit(this.myComponent.myConfirmExit.isSelected());
        settings.setAutoSaveIfInactive(this.myComponent.myChkAutoSaveIfInactive.isSelected());
        try {
            int newInactiveTimeout = Integer.parseInt(this.myComponent.myTfInactiveTimeout.getText());
            if (newInactiveTimeout > 0) {
                settings.setInactiveTimeout(newInactiveTimeout);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        boolean isModified = false;
        GeneralSettings settings = GeneralSettings.getInstance();
        isModified |= settings.isReopenLastProject() != this.myComponent.myChkReopenLastProject.isSelected();
        isModified |= settings.isSyncOnFrameActivation() != this.myComponent.myChkSyncOnFrameActivation.isSelected();
        isModified |= settings.isSaveOnFrameDeactivation() != this.myComponent.myChkSaveOnFrameDeactivation.isSelected();
        isModified |= settings.isAutoSaveIfInactive() != this.myComponent.myChkAutoSaveIfInactive.isSelected();
        isModified |= settings.isConfirmExit() != this.myComponent.myConfirmExit.isSelected();
        int inactiveTimeout = -1;
        try {
            inactiveTimeout = Integer.parseInt(this.myComponent.myTfInactiveTimeout.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return isModified |= inactiveTimeout > 0 && settings.getInactiveTimeout() != inactiveTimeout;
    }

    public JComponent createComponent() {
        this.myComponent = new MyComponent();
        this.myComponent.myChkAutoSaveIfInactive.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GeneralSettingsConfigurable.this.myComponent.myTfInactiveTimeout.setEditable(GeneralSettingsConfigurable.this.myComponent.myChkAutoSaveIfInactive.isSelected());
            }
        });
        List list = this.getConfigurables();
        if (!list.isEmpty()) {
            this.myComponent.myPluginOptionsPanel.setLayout(new GridLayout(list.size(), 1));
            for (Configurable c : list) {
                this.myComponent.myPluginOptionsPanel.add(c.createComponent());
            }
        }
        return this.myComponent.myPanel;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.general", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return IconLoader.getIcon((String)"/general/configurableGeneral.png");
    }

    @Override
    public void reset() {
        super.reset();
        GeneralSettings settings = GeneralSettings.getInstance();
        this.myComponent.myChkReopenLastProject.setSelected(settings.isReopenLastProject());
        this.myComponent.myChkSyncOnFrameActivation.setSelected(settings.isSyncOnFrameActivation());
        this.myComponent.myChkSaveOnFrameDeactivation.setSelected(settings.isSaveOnFrameDeactivation());
        this.myComponent.myChkAutoSaveIfInactive.setSelected(settings.isAutoSaveIfInactive());
        this.myComponent.myTfInactiveTimeout.setText(Integer.toString(settings.getInactiveTimeout()));
        this.myComponent.myTfInactiveTimeout.setEditable(settings.isAutoSaveIfInactive());
        this.myComponent.myConfirmExit.setSelected(settings.isConfirmExit());
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        this.myComponent = null;
    }

    @NotNull
    public String getHelpTopic() {
        if ("preferences.general" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/GeneralSettingsConfigurable.getHelpTopic must not return null");
        }
        return "preferences.general";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Override
    protected List<Configurable> createConfigurables() {
        return Arrays.asList(Extensions.getExtensions(EP_NAME));
    }

    private static class MyComponent {
        JPanel myPanel;
        private JCheckBox myChkReopenLastProject;
        private JCheckBox myChkSyncOnFrameActivation;
        private JCheckBox myChkSaveOnFrameDeactivation;
        private JCheckBox myChkAutoSaveIfInactive;
        private JTextField myTfInactiveTimeout;
        public JCheckBox myConfirmExit;
        private JPanel myPluginOptionsPanel;

        public MyComponent() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            JTextField jTextField;
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JPanel jPanel2;
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Startup/Shutdown", 0, 0, null, null));
            this.myChkReopenLastProject = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.reopen.last.project.on.startup"));
            jCheckBox5.setMargin(new Insets(2, 0, 2, 2));
            jCheckBox5.setSelected(true);
            jPanel3.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel3.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myConfirmExit = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.confirm.application.exit"));
            jCheckBox4.setMargin(new Insets(2, 0, 2, 2));
            jPanel3.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Synchronization", 0, 0, null, null));
            this.myChkSyncOnFrameActivation = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.synchronize.files.on.frame.activation"));
            jCheckBox3.setMargin(new Insets(2, 0, 2, 2));
            jCheckBox3.setSelected(true);
            jPanel4.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel4.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer4 = new Spacer();
            jPanel4.add((Component)spacer4, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myChkSaveOnFrameDeactivation = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.save.files.on.frame.deactivation"));
            jCheckBox2.setMargin(new Insets(2, 0, 2, 2));
            jCheckBox2.setSelected(true);
            jPanel4.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myChkAutoSaveIfInactive = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.save.files.automatically"));
            jCheckBox.setMargin(new Insets(2, 0, 2, 2));
            jPanel4.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel5, new GridConstraints(2, 1, 1, 1, 8, 2, 0, 3, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("label.inactive.timeout.sec"));
            jPanel5.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myTfInactiveTimeout = jTextField = new JTextField();
            jTextField.setMargin(new Insets(0, 2, 0, 4));
            jTextField.setColumns(10);
            jPanel5.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 0, 0, new Dimension(50, -1), new Dimension(50, -1), new Dimension(50, -1)));
            Spacer spacer5 = new Spacer();
            jPanel2.add((Component)spacer5, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myPluginOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

