/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;

public class IndentInfo {
    private final int mySpaces;
    private final int myIndentSpaces;
    private final int myLineFeeds;
    private boolean myIsChanged = true;
    private TextRange myInitialTextRange;

    public IndentInfo(int lineFeeds, int indentSpaces, int spaces) {
        this.mySpaces = spaces;
        this.myIndentSpaces = indentSpaces;
        this.myLineFeeds = lineFeeds;
    }

    public int getSpaces() {
        return this.mySpaces;
    }

    public void setInitialTextRange(TextRange initialTextRange) {
        this.myInitialTextRange = initialTextRange;
    }

    public int getIndentSpaces() {
        return this.myIndentSpaces;
    }

    public int getLineFeeds() {
        return this.myLineFeeds;
    }

    public String generateNewWhiteSpace(CodeStyleSettings.IndentOptions options) {
        StringBuffer buffer = new StringBuffer();
        StringUtil.repeatSymbol((Appendable)buffer, (char)'\n', (int)this.myLineFeeds);
        if (options.USE_TAB_CHARACTER) {
            if (options.SMART_TABS) {
                int tabCount = this.myIndentSpaces / options.TAB_SIZE;
                int leftSpaces = this.myIndentSpaces - tabCount * options.TAB_SIZE;
                StringUtil.repeatSymbol((Appendable)buffer, (char)'\t', (int)tabCount);
                StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)(leftSpaces + this.mySpaces));
            } else {
                int size = this.getTotalSpaces();
                while (size > 0) {
                    if (size >= options.TAB_SIZE) {
                        buffer.append('\t');
                        size -= options.TAB_SIZE;
                        continue;
                    }
                    buffer.append(' ');
                    --size;
                }
            }
        } else {
            StringUtil.repeatSymbol((Appendable)buffer, (char)' ', (int)this.getTotalSpaces());
        }
        return buffer.toString();
    }

    public int getTotalSpaces() {
        return this.myIndentSpaces + this.mySpaces;
    }

    public int getIndentCount(CodeStyleSettings.IndentOptions indentOptions) {
        return this.myIndentSpaces / indentOptions.INDENT_SIZE;
    }

    public int getSpacesCount(CodeStyleSettings.IndentOptions indentOptions) {
        int indentSpaces = this.getIndentCount(indentOptions);
        return this.myIndentSpaces - indentSpaces * indentOptions.INDENT_SIZE + this.mySpaces;
    }

    public boolean isChanged() {
        return this.myIsChanged;
    }

    public void setIsChanged(boolean value) {
        this.myIsChanged = value;
    }

    public TextRange getInitialTextRange() {
        return this.myInitialTextRange;
    }
}

