/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.find.impl.RevealingSpaceComboboxEditor;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;

class FindDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.impl.FindDialog");
    private ComboBox myInputComboBox;
    private ComboBox myReplaceComboBox;
    private StateRestoringCheckBox myCbCaseSensitive;
    private StateRestoringCheckBox myCbPreserveCase;
    private StateRestoringCheckBox myCbWholeWordsOnly;
    private StateRestoringCheckBox myCbInCommentsOnly;
    private StateRestoringCheckBox myCbInStringLiteralsOnly;
    private StateRestoringCheckBox myCbRegularExpressions;
    private JRadioButton myRbGlobal;
    private JRadioButton myRbSelectedText;
    private JRadioButton myRbForward;
    private JRadioButton myRbBackward;
    private JRadioButton myRbFromCursor;
    private JRadioButton myRbEntireScope;
    private JRadioButton myRbProject;
    private JRadioButton myRbDirectory;
    private JRadioButton myRbModule;
    private ComboBox myModuleComboBox;
    private ComboBox myDirectoryComboBox;
    private StateRestoringCheckBox myCbWithSubdirectories;
    private JCheckBox myCbToOpenInNewTab;
    private final FindModel myModel;
    private final Runnable myOkHandler;
    private FixedSizeButton mySelectDirectoryButton;
    private StateRestoringCheckBox useFileFilter;
    private ComboBox myFileFilter;
    private JCheckBox myCbToSkipResultsWhenOneUsage;
    private final Project myProject;
    private final Map<EditorTextField, DocumentAdapter> myComboBoxListeners = new HashMap<EditorTextField, DocumentAdapter>();
    private Action myFindAllAction;
    private JRadioButton myRbCustomScope;
    private ScopeChooserCombo myScopeCombo;

    public FindDialog(Project project, FindModel model, Runnable myOkHandler) {
        super(project, true);
        this.myProject = project;
        this.myModel = model;
        this.myOkHandler = myOkHandler;
        if (this.myModel.isReplaceState()) {
            if (this.myModel.isMultipleFiles()) {
                this.setTitle(FindBundle.message("find.replace.in.project.dialog.title", new Object[0]));
            } else {
                this.setTitle(FindBundle.message("find.replace.text.dialog.title", new Object[0]));
            }
        } else {
            this.setButtonsMargin(null);
            if (this.myModel.isMultipleFiles()) {
                this.setTitle(FindBundle.message("find.in.path.dialog.title", new Object[0]));
            } else {
                this.setTitle(FindBundle.message("find.text.dialog.title", new Object[0]));
            }
        }
        this.setOKButtonText(FindBundle.message("find.button", new Object[0]));
        this.setOKButtonIcon(IconLoader.getIcon((String)"/actions/find.png"));
        this.init();
        this.initByModel();
    }

    protected void dispose() {
        for (Map.Entry<EditorTextField, DocumentAdapter> e : this.myComboBoxListeners.entrySet()) {
            e.getKey().removeDocumentListener((DocumentListener)e.getValue());
        }
        this.myComboBoxListeners.clear();
        super.dispose();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myInputComboBox;
    }

    protected String getDimensionServiceKey() {
        return this.myModel.isReplaceState() ? "replaceTextDialog" : "findTextDialog";
    }

    protected Action[] createActions() {
        if (!this.myModel.isMultipleFiles() && !this.myModel.isReplaceState() && this.myModel.isFindAllEnabled()) {
            return new Action[]{this.getFindAllAction(), this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        }
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    private Action getFindAllAction() {
        this.myFindAllAction = new AbstractAction(FindBundle.message("find.all.button", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.doOKAction(true);
            }
        };
        return this.myFindAllAction;
    }

    public JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 4, 4, 4);
        gbConstraints.fill = 3;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 13;
        JLabel prompt = new JLabel(FindBundle.message("find.text.to.find.label", new Object[0]));
        panel.add((Component)prompt, gbConstraints);
        this.myInputComboBox = new ComboBox(300);
        this.revealWhitespaces(this.myInputComboBox);
        this.initCombobox(this.myInputComboBox);
        if (this.myModel.isReplaceState()) {
            this.myReplaceComboBox = new ComboBox(300);
            this.revealWhitespaces(this.myReplaceComboBox);
            this.initCombobox(this.myReplaceComboBox);
            final Component editorComponent = this.myReplaceComboBox.getEditor().getEditorComponent();
            editorComponent.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    FindDialog.this.myReplaceComboBox.getEditor().selectAll();
                    editorComponent.removeFocusListener(this);
                }
            });
        }
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        panel.add((Component)this.myInputComboBox, gbConstraints);
        prompt.setLabelFor(this.myInputComboBox.getEditor().getEditorComponent());
        if (this.myModel.isReplaceState()) {
            gbConstraints.gridwidth = -1;
            gbConstraints.fill = 3;
            gbConstraints.weightx = 0.0;
            JLabel replacePrompt = new JLabel(FindBundle.message("find.replace.with.label", new Object[0]));
            panel.add((Component)replacePrompt, gbConstraints);
            gbConstraints.gridwidth = 0;
            gbConstraints.fill = 1;
            gbConstraints.weightx = 1.0;
            panel.add((Component)this.myReplaceComboBox, gbConstraints);
            replacePrompt.setLabelFor(this.myReplaceComboBox.getEditor().getEditorComponent());
        }
        return panel;
    }

    private void revealWhitespaces(ComboBox comboBox) {
        RevealingSpaceComboboxEditor comboBoxEditor = new RevealingSpaceComboboxEditor(this.myProject, comboBox);
        comboBox.setEditor((ComboBoxEditor)comboBoxEditor);
        comboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)comboBoxEditor));
    }

    private void initCombobox(final ComboBox comboBox) {
        comboBox.setEditable(true);
        comboBox.setMaximumRowCount(8);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.validateFindButton();
            }
        });
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof EditorTextField) {
            EditorTextField etf = (EditorTextField)editorComponent;
            DocumentAdapter listener = new DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    FindDialog.this.handleComboBoxValueChanged(comboBox);
                }
            };
            etf.addDocumentListener((DocumentListener)listener);
            this.myComboBoxListeners.put(etf, listener);
        } else {
            editorComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    FindDialog.this.handleComboBoxValueChanged(comboBox);
                }
            });
        }
    }

    private void handleComboBoxValueChanged(ComboBox comboBox) {
        Object item = comboBox.getEditor().getItem();
        if (item != null && !item.equals(comboBox.getSelectedItem())) {
            int caretPosition = FindDialog.getCaretPosition((JComboBox)comboBox);
            comboBox.setSelectedItem(item);
            FindDialog.setCaretPosition((JComboBox)comboBox, caretPosition);
        }
        this.validateFindButton();
    }

    private static int getCaretPosition(JComboBox comboBox) {
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField textField = (JTextField)editorComponent;
            return textField.getCaretPosition();
        }
        return 0;
    }

    private static void setCaretPosition(JComboBox comboBox, int position) {
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField textField = (JTextField)editorComponent;
            textField.setCaretPosition(position);
        }
    }

    private void validateFindButton() {
        String toFind = this.getStringToFind();
        if (toFind == null || toFind.length() == 0) {
            this.setOKStatus(false);
            return;
        }
        if (this.myRbDirectory != null && this.myRbDirectory.isSelected() && (this.getDirectory() == null || this.getDirectory().length() == 0)) {
            this.setOKStatus(false);
            return;
        }
        this.setOKStatus(true);
    }

    private void setOKStatus(boolean value) {
        this.setOKActionEnabled(value);
        if (this.myFindAllAction != null) {
            this.myFindAllAction.setEnabled(value);
        }
    }

    public JComponent createCenterPanel() {
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        JPanel topOptionsPanel = new JPanel();
        topOptionsPanel.setLayout(new GridLayout(1, 2, 8, 0));
        optionsPanel.add((Component)topOptionsPanel, gbConstraints);
        topOptionsPanel.add(this.createFindOptionsPanel());
        if (!this.myModel.isMultipleFiles()) {
            if (FindManagerImpl.ourHasSearchInCommentsAndLiterals) {
                JPanel leftOptionsPanel = new JPanel();
                leftOptionsPanel.setLayout(new GridLayout(3, 1, 0, 4));
                leftOptionsPanel.add(this.createDirectionPanel());
                leftOptionsPanel.add(this.createOriginPanel());
                leftOptionsPanel.add(this.createScopePanel());
                topOptionsPanel.add(leftOptionsPanel);
            } else {
                topOptionsPanel.add(this.createDirectionPanel());
                gbConstraints.gridwidth = -1;
                JPanel bottomOptionsPanel = new JPanel();
                bottomOptionsPanel.setLayout(new GridLayout(1, 2, 8, 0));
                optionsPanel.add((Component)bottomOptionsPanel, gbConstraints);
                bottomOptionsPanel.add(this.createScopePanel());
                bottomOptionsPanel.add(this.createOriginPanel());
            }
        } else {
            optionsPanel.add((Component)this.createGlobalScopePanel(), gbConstraints);
            gbConstraints.weightx = 1.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.fill = 2;
            gbConstraints.gridwidth = 0;
            optionsPanel.add((Component)this.createFilterPanel(), gbConstraints);
            if (!this.myModel.isReplaceState()) {
                this.myCbToSkipResultsWhenOneUsage = FindDialog.createCheckbox(FindSettings.getInstance().isSkipResultsWithOneUsage(), FindBundle.message("find.options.skip.results.tab.with.one.usage.checkbox", new Object[0]));
                optionsPanel.add((Component)this.myCbToSkipResultsWhenOneUsage, gbConstraints);
            }
        }
        if (this.myModel.isOpenInNewTabVisible()) {
            JPanel openInNewTabWindowPanel = new JPanel(new BorderLayout());
            this.myCbToOpenInNewTab = new JCheckBox(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0]));
            this.myCbToOpenInNewTab.setFocusable(false);
            this.myCbToOpenInNewTab.setSelected(this.myModel.isOpenInNewTab());
            this.myCbToOpenInNewTab.setEnabled(this.myModel.isOpenInNewTabEnabled());
            openInNewTabWindowPanel.add((Component)this.myCbToOpenInNewTab, "East");
            optionsPanel.add((Component)openInNewTabWindowPanel, gbConstraints);
        }
        return optionsPanel;
    }

    private JComponent createFilterPanel() {
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BorderLayout());
        filterPanel.setBorder(IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.filter.file.name.group", new Object[0])));
        this.myFileFilter = new ComboBox(100);
        this.initCombobox(this.myFileFilter);
        this.useFileFilter = FindDialog.createCheckbox(FindBundle.message("find.filter.file.mask.checkbox", new Object[0]));
        filterPanel.add((Component)this.useFileFilter, "West");
        filterPanel.add((Component)this.myFileFilter, "Center");
        this.myFileFilter.setEditable(true);
        String[] fileMasks = FindSettings.getInstance().getRecentFileMasks();
        for (int i = fileMasks.length - 1; i >= 0; --i) {
            this.myFileFilter.addItem((Object)fileMasks[i]);
        }
        this.myFileFilter.setEnabled(false);
        this.useFileFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FindDialog.this.useFileFilter.isSelected()) {
                    FindDialog.this.myFileFilter.setEnabled(false);
                } else {
                    FindDialog.this.myFileFilter.setEnabled(true);
                    FindDialog.this.myFileFilter.getEditor().selectAll();
                    FindDialog.this.myFileFilter.getEditor().getEditorComponent().requestFocusInWindow();
                }
            }
        });
        return filterPanel;
    }

    public void doOKAction() {
        this.doOKAction(false);
    }

    private void doOKAction(boolean findAll) {
        PsiDirectory directory;
        FindModel validateModel = (FindModel)this.myModel.clone();
        this.applyTo(validateModel);
        validateModel.setFindAll(findAll);
        if (validateModel.getDirectoryName() != null && (directory = FindInProjectUtil.getPsiDirectory(validateModel, this.myProject)) == null) {
            Messages.showMessageDialog((Project)this.myProject, (String)FindBundle.message("find.directory.not.found.error", validateModel.getDirectoryName()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        if (validateModel.isRegularExpressions()) {
            String toFind = validateModel.getStringToFind();
            try {
                Pattern pattern = Pattern.compile(toFind, validateModel.isCaseSensitive() ? 8 : 10);
                if (pattern.matcher("").matches() && !toFind.endsWith("$") && !toFind.startsWith("^")) {
                    throw new PatternSyntaxException(FindBundle.message("find.empty.match.regular.expression.error", new Object[0]), toFind, -1);
                }
            }
            catch (PatternSyntaxException e) {
                Messages.showMessageDialog((Project)this.myProject, (String)FindBundle.message("find.invalid.regular.expression.error", toFind, e.getDescription()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        validateModel.setFileFilter(null);
        FindSettings.getInstance().setFileMask(null);
        if (this.useFileFilter != null && this.useFileFilter.isSelected() && this.myFileFilter.getSelectedItem() != null) {
            String mask = (String)this.myFileFilter.getSelectedItem();
            if (mask.length() > 0) {
                try {
                    FindInProjectUtil.createFileMaskRegExp(mask);
                    validateModel.setFileFilter(mask);
                    FindSettings.getInstance().setFileMask(mask);
                }
                catch (PatternSyntaxException ex) {
                    Messages.showMessageDialog((Project)this.myProject, (String)FindBundle.message("find.filter.invalid.file.mask.error", this.myFileFilter.getSelectedItem()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    return;
                }
            } else {
                Messages.showMessageDialog((Project)this.myProject, (String)FindBundle.message("find.filter.empty.file.mask.error", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
        }
        if (this.myCbToSkipResultsWhenOneUsage != null) {
            FindSettings.getInstance().setSkipResultsWithOneUsage(this.isSkipResultsWhenOneUsage());
        }
        this.myModel.copyFrom(validateModel);
        super.doOKAction();
        this.myOkHandler.run();
    }

    public void doHelpAction() {
        String id = this.myModel.isReplaceState() ? (this.myModel.isMultipleFiles() ? "reference.dialogs.findinpath" : "find.replaceOptions") : (this.myModel.isMultipleFiles() ? "reference.dialogs.findinpath" : "find.findOptions");
        HelpManager.getInstance().invokeHelp(id);
    }

    private boolean isSkipResultsWhenOneUsage() {
        return this.myCbToSkipResultsWhenOneUsage != null && this.myCbToSkipResultsWhenOneUsage.isSelected();
    }

    private JPanel createFindOptionsPanel() {
        JPanel findOptionsPanel = new JPanel();
        findOptionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.options.group", new Object[0])));
        findOptionsPanel.setLayout(new BoxLayout(findOptionsPanel, 1));
        this.myCbCaseSensitive = FindDialog.createCheckbox(FindBundle.message("find.options.case.sensitive", new Object[0]));
        findOptionsPanel.add(this.myCbCaseSensitive);
        if (this.myModel.isReplaceState()) {
            this.myCbPreserveCase = FindDialog.createCheckbox(FindBundle.message("find.options.replace.preserve.case", new Object[0]));
            findOptionsPanel.add(this.myCbPreserveCase);
        }
        this.myCbWholeWordsOnly = FindDialog.createCheckbox(FindBundle.message("find.options.whole.words.only", new Object[0]));
        findOptionsPanel.add(this.myCbWholeWordsOnly);
        this.myCbRegularExpressions = FindDialog.createCheckbox(FindBundle.message("find.options.regular.expressions", new Object[0]));
        final JPanel regExPanel = new JPanel();
        regExPanel.setAlignmentX(0.0f);
        regExPanel.setLayout(new BoxLayout(regExPanel, 0));
        regExPanel.add(this.myCbRegularExpressions);
        regExPanel.add((Component)new LinkLabel("[Help]", null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                try {
                    JBPopup helpPopup = RegExHelpPopup.createRegExHelpPopup();
                    helpPopup.showInCenterOf((Component)regExPanel);
                }
                catch (BadLocationException e) {
                    LOG.info((Throwable)e);
                }
            }
        }));
        findOptionsPanel.add(regExPanel);
        this.myCbInCommentsOnly = FindDialog.createCheckbox(FindBundle.message("find.options.comments.only", new Object[0]));
        this.myCbInStringLiteralsOnly = FindDialog.createCheckbox(FindBundle.message("find.options.string.literals.only", new Object[0]));
        if (FindManagerImpl.ourHasSearchInCommentsAndLiterals) {
            findOptionsPanel.add(this.myCbInCommentsOnly);
            findOptionsPanel.add(this.myCbInStringLiteralsOnly);
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.updateControls();
            }
        };
        this.myCbRegularExpressions.addActionListener(actionListener);
        this.myCbRegularExpressions.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FindDialog.this.setupRegExpSetting();
            }
        });
        if (this.myModel.isReplaceState()) {
            this.myCbCaseSensitive.addActionListener(actionListener);
            this.myCbPreserveCase.addActionListener(actionListener);
        }
        return findOptionsPanel;
    }

    private void setupRegExpSetting() {
        this.updateFileTypeForEditorComponent(this.myInputComboBox);
        if (this.myReplaceComboBox != null) {
            this.updateFileTypeForEditorComponent(this.myReplaceComboBox);
        }
    }

    private void updateFileTypeForEditorComponent(ComboBox inputComboBox) {
        Component editorComponent = inputComboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof EditorTextField) {
            boolean selected = this.myCbRegularExpressions.isSelectedWhenSelectable();
            String s = selected ? "*.regexp" : "*.txt";
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(s);
            if (selected && fileType == FileTypes.UNKNOWN) {
                fileType = FileTypeManager.getInstance().getFileTypeByFileName("*.txt");
            }
            PsiFile file = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(s, fileType, (CharSequence)((EditorTextField)editorComponent).getText(), -1L, true);
            ((EditorTextField)editorComponent).setNewDocumentAndFileType(fileType, PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file));
        }
    }

    private void updateControls() {
        if (this.myCbRegularExpressions.isSelected()) {
            this.myCbWholeWordsOnly.makeUnselectable(false);
        } else {
            this.myCbWholeWordsOnly.makeSelectable();
        }
        if (this.myModel.isReplaceState()) {
            if (this.myCbRegularExpressions.isSelected() || this.myCbCaseSensitive.isSelected()) {
                this.myCbPreserveCase.makeUnselectable(false);
            } else {
                this.myCbPreserveCase.makeSelectable();
            }
            if (this.myCbPreserveCase.isSelected()) {
                this.myCbRegularExpressions.makeUnselectable(false);
                this.myCbCaseSensitive.makeUnselectable(false);
            } else {
                this.myCbRegularExpressions.makeSelectable();
                this.myCbCaseSensitive.makeSelectable();
            }
        }
        if (!this.myModel.isMultipleFiles()) {
            this.myRbFromCursor.setEnabled(this.myRbGlobal.isSelected());
            this.myRbEntireScope.setEnabled(this.myRbGlobal.isSelected());
        }
    }

    private JPanel createDirectionPanel() {
        JPanel directionPanel = new JPanel();
        directionPanel.setBorder(IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.direction.group", new Object[0])));
        directionPanel.setLayout(new BoxLayout(directionPanel, 1));
        this.myRbForward = new JRadioButton(FindBundle.message("find.direction.forward.radio", new Object[0]), true);
        directionPanel.add(this.myRbForward);
        this.myRbBackward = new JRadioButton(FindBundle.message("find.direction.backward.radio", new Object[0]));
        directionPanel.add(this.myRbBackward);
        ButtonGroup bgDirection = new ButtonGroup();
        bgDirection.add(this.myRbForward);
        bgDirection.add(this.myRbBackward);
        return directionPanel;
    }

    private JComponent createGlobalScopePanel() {
        JPanel scopePanel = new JPanel();
        scopePanel.setLayout(new GridBagLayout());
        scopePanel.setBorder(IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.scope.group", new Object[0])));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 2;
        gbConstraints.weightx = 1.0;
        this.myRbProject = new JRadioButton(FindBundle.message("find.scope.whole.project.radio", new Object[0]), true);
        scopePanel.add((Component)this.myRbProject, gbConstraints);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        this.myRbModule = new JRadioButton(FindBundle.message("find.scope.module.radio", new Object[0]), false);
        scopePanel.add((Component)this.myRbModule, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        Object[] names = new String[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            names[i] = modules[i].getName();
        }
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        this.myModuleComboBox = new ComboBox(names, -1);
        scopePanel.add((Component)this.myModuleComboBox, gbConstraints);
        if (modules.length == 1) {
            this.myModuleComboBox.setVisible(false);
            this.myRbModule.setVisible(false);
        }
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        this.myRbDirectory = new JRadioButton(FindBundle.message("find.scope.directory.radio", new Object[0]), false);
        scopePanel.add((Component)this.myRbDirectory, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        this.myDirectoryComboBox = new ComboBox(-1);
        Component editorComponent = this.myDirectoryComboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField field = (JTextField)editorComponent;
            field.setColumns(40);
        }
        this.initCombobox(this.myDirectoryComboBox);
        scopePanel.add((Component)this.myDirectoryComboBox, gbConstraints);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 2;
        gbConstraints.insets = new Insets(0, 1, 0, 0);
        this.mySelectDirectoryButton = new FixedSizeButton((JComponent)this.myDirectoryComboBox);
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)this.mySelectDirectoryButton, (JComponent)this.myDirectoryComboBox);
        this.mySelectDirectoryButton.setMargin(new Insets(0, 0, 0, 0));
        scopePanel.add((Component)this.mySelectDirectoryButton, gbConstraints);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 2;
        gbConstraints.insets = new Insets(0, 16, 0, 0);
        this.myCbWithSubdirectories = FindDialog.createCheckbox(true, FindBundle.message("find.scope.directory.recursive.checkbox", new Object[0]));
        this.myCbWithSubdirectories.setSelected(true);
        scopePanel.add((Component)this.myCbWithSubdirectories, gbConstraints);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.insets = new Insets(0, 1, 0, 0);
        this.myRbCustomScope = new JRadioButton(FindBundle.message("find.scope.custom.radio", new Object[0]), false);
        scopePanel.add((Component)this.myRbCustomScope, gbConstraints);
        ++gbConstraints.gridx;
        gbConstraints.gridwidth = 0;
        this.myScopeCombo = new ScopeChooserCombo(this.myProject, true, true, FindSettings.getInstance().getDefaultScopeName());
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeCombo);
        scopePanel.add((Component)((Object)this.myScopeCombo), gbConstraints);
        ButtonGroup bgScope = new ButtonGroup();
        bgScope.add(this.myRbDirectory);
        bgScope.add(this.myRbProject);
        bgScope.add(this.myRbModule);
        bgScope.add(this.myRbCustomScope);
        this.myRbProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.validateScopeControls();
                FindDialog.this.validateFindButton();
            }
        });
        this.myRbCustomScope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.validateScopeControls();
                FindDialog.this.validateFindButton();
            }
        });
        this.myRbDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.validateScopeControls();
                FindDialog.this.validateFindButton();
                FindDialog.this.myDirectoryComboBox.getEditor().getEditorComponent().requestFocusInWindow();
            }
        });
        this.myRbModule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.validateScopeControls();
                FindDialog.this.validateFindButton();
                FindDialog.this.myModuleComboBox.requestFocusInWindow();
            }
        });
        this.mySelectDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                VirtualFile[] files = FileChooser.chooseFiles((Project)FindDialog.this.myProject, (FileChooserDescriptor)descriptor);
                if (files.length != 0) {
                    FindDialog.this.myDirectoryComboBox.setSelectedItem((Object)files[0].getPresentableUrl());
                    FindDialog.this.validateFindButton();
                }
            }
        });
        return scopePanel;
    }

    private static StateRestoringCheckBox createCheckbox(String message) {
        StateRestoringCheckBox cb = new StateRestoringCheckBox(message);
        cb.setFocusable(false);
        return cb;
    }

    private static StateRestoringCheckBox createCheckbox(boolean selected, String message) {
        StateRestoringCheckBox cb = new StateRestoringCheckBox(message, selected);
        cb.setFocusable(false);
        return cb;
    }

    private void validateScopeControls() {
        if (this.myRbDirectory.isSelected()) {
            this.myCbWithSubdirectories.makeSelectable();
        } else {
            this.myCbWithSubdirectories.makeUnselectable(this.myCbWithSubdirectories.isSelected());
        }
        this.myDirectoryComboBox.setEnabled(this.myRbDirectory.isSelected());
        this.mySelectDirectoryButton.setEnabled(this.myRbDirectory.isSelected());
        this.myModuleComboBox.setEnabled(this.myRbModule.isSelected());
        this.myScopeCombo.setEnabled(this.myRbCustomScope.isSelected());
    }

    private JPanel createScopePanel() {
        JPanel scopePanel = new JPanel();
        scopePanel.setBorder(IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.scope.group", new Object[0])));
        scopePanel.setLayout(new BoxLayout(scopePanel, 1));
        this.myRbGlobal = new JRadioButton(FindBundle.message("find.scope.global.radio", new Object[0]), true);
        scopePanel.add(this.myRbGlobal);
        this.myRbSelectedText = new JRadioButton(FindBundle.message("find.scope.selected.text.radio", new Object[0]));
        scopePanel.add(this.myRbSelectedText);
        ButtonGroup bgScope = new ButtonGroup();
        bgScope.add(this.myRbGlobal);
        bgScope.add(this.myRbSelectedText);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.updateControls();
            }
        };
        this.myRbGlobal.addActionListener(actionListener);
        this.myRbSelectedText.addActionListener(actionListener);
        return scopePanel;
    }

    private JPanel createOriginPanel() {
        JPanel originPanel = new JPanel();
        originPanel.setBorder(IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.origin.group", new Object[0])));
        originPanel.setLayout(new BoxLayout(originPanel, 1));
        this.myRbFromCursor = new JRadioButton(FindBundle.message("find.origin.from.cursor.radio", new Object[0]), true);
        originPanel.add(this.myRbFromCursor);
        this.myRbEntireScope = new JRadioButton(FindBundle.message("find.origin.entire.scope.radio", new Object[0]));
        originPanel.add(this.myRbEntireScope);
        ButtonGroup bgOrigin = new ButtonGroup();
        bgOrigin.add(this.myRbFromCursor);
        bgOrigin.add(this.myRbEntireScope);
        return originPanel;
    }

    private String getStringToFind() {
        return (String)this.myInputComboBox.getEditor().getItem();
    }

    private String getStringToReplace() {
        return (String)this.myReplaceComboBox.getEditor().getItem();
    }

    private String getDirectory() {
        return (String)this.myDirectoryComboBox.getSelectedItem();
    }

    private static void setStringsToComboBox(String[] strings, ComboBox combo, String selected) {
        if (combo.getItemCount() > 0) {
            combo.removeAllItems();
        }
        if (selected != null && selected.indexOf(10) < 0) {
            strings = (String[])ArrayUtil.remove((Object[])strings, (Object)selected);
            strings = (String[])ArrayUtil.append((Object[])strings, (Object)selected);
        }
        for (int i = strings.length - 1; i >= 0; --i) {
            combo.addItem((Object)strings[i]);
        }
    }

    private void setDirectories(ArrayList strings, String directoryName) {
        if (this.myDirectoryComboBox.getItemCount() > 0) {
            this.myReplaceComboBox.removeAllItems();
        }
        if (directoryName != null && directoryName.length() > 0) {
            if (strings.contains(directoryName)) {
                strings.remove(directoryName);
            }
            this.myDirectoryComboBox.addItem((Object)directoryName);
        }
        for (int i = strings.size() - 1; i >= 0; --i) {
            this.myDirectoryComboBox.addItem(strings.get(i));
        }
        if (this.myDirectoryComboBox.getItemCount() == 0) {
            this.myDirectoryComboBox.addItem((Object)"");
        }
    }

    private void applyTo(FindModel model) {
        FindSettings findSettings = FindSettings.getInstance();
        model.setCaseSensitive(this.myCbCaseSensitive.isSelected());
        findSettings.setCaseSensitive(this.myCbCaseSensitive.isSelected());
        if (model.isReplaceState()) {
            model.setPreserveCase(this.myCbPreserveCase.isSelected());
            findSettings.setPreserveCase(this.myCbPreserveCase.isSelected());
        }
        model.setWholeWordsOnly(this.myCbWholeWordsOnly.isSelected());
        findSettings.setWholeWordsOnly(this.myCbWholeWordsOnly.isSelected());
        model.setInStringLiteralsOnly(this.myCbInStringLiteralsOnly.isSelected());
        findSettings.setInStringLiteralsOnly(this.myCbInStringLiteralsOnly.isSelected());
        model.setInCommentsOnly(this.myCbInCommentsOnly.isSelected());
        findSettings.setInCommentsOnly(this.myCbInCommentsOnly.isSelected());
        model.setRegularExpressions(this.myCbRegularExpressions.isSelected());
        findSettings.setRegularExpressions(this.myCbRegularExpressions.isSelected());
        model.setStringToFind(this.getStringToFind());
        if (model.isReplaceState()) {
            model.setPromptOnReplace(true);
            model.setReplaceAll(false);
            String stringToReplace = this.getStringToReplace();
            if (stringToReplace == null) {
                stringToReplace = "";
            }
            model.setStringToReplace(StringUtil.convertLineSeparators((String)stringToReplace));
        }
        if (!model.isMultipleFiles()) {
            model.setForward(this.myRbForward.isSelected());
            findSettings.setForward(this.myRbForward.isSelected());
            model.setFromCursor(this.myRbFromCursor.isSelected());
            findSettings.setFromCursor(this.myRbFromCursor.isSelected());
            model.setGlobal(this.myRbGlobal.isSelected());
            findSettings.setGlobal(this.myRbGlobal.isSelected());
        } else {
            if (this.myCbToOpenInNewTab != null) {
                model.setOpenInNewTab(this.myCbToOpenInNewTab.isSelected());
            }
            model.setProjectScope(this.myRbProject.isSelected());
            model.setDirectoryName(null);
            model.setModuleName(null);
            model.setCustomScopeName(null);
            model.setCustomScope(null);
            if (this.myRbDirectory.isSelected()) {
                String directory = this.getDirectory();
                model.setDirectoryName(directory == null ? "" : directory);
                model.setWithSubdirectories(this.myCbWithSubdirectories.isSelected());
                findSettings.setWithSubdirectories(this.myCbWithSubdirectories.isSelected());
            } else if (this.myRbModule.isSelected()) {
                model.setModuleName((String)this.myModuleComboBox.getSelectedItem());
            } else if (this.myRbCustomScope.isSelected()) {
                SearchScope selectedScope = this.myScopeCombo.getSelectedScope();
                String customScopeName = selectedScope == null ? null : selectedScope.getDisplayName();
                model.setCustomScopeName(customScopeName);
                model.setCustomScope(selectedScope == null ? null : selectedScope);
                findSettings.setCustomScope(customScopeName);
            }
        }
    }

    private void initByModel() {
        this.myCbCaseSensitive.setSelected(this.myModel.isCaseSensitive());
        this.myCbWholeWordsOnly.setSelected(this.myModel.isWholeWordsOnly());
        this.myCbInStringLiteralsOnly.setSelected(this.myModel.isInStringLiteralsOnly());
        this.myCbInCommentsOnly.setSelected(this.myModel.isInCommentsOnly());
        this.myCbRegularExpressions.setSelected(this.myModel.isRegularExpressions());
        if (this.myModel.isMultipleFiles()) {
            Module module;
            VirtualFile dir;
            String dirName = this.myModel.getDirectoryName();
            this.setDirectories(FindSettings.getInstance().getRecentDirectories(), dirName);
            if (!StringUtil.isEmptyOrSpaces((String)dirName) && (dir = LocalFileSystem.getInstance().findFileByPath(dirName)) != null && (module = ModuleUtil.findModuleForFile((VirtualFile)dir, (Project)this.myProject)) != null) {
                this.myModuleComboBox.setSelectedItem((Object)module.getName());
            }
            if (this.myModel.isProjectScope()) {
                this.myRbProject.setSelected(true);
                this.myCbWithSubdirectories.setEnabled(false);
                this.myDirectoryComboBox.setEnabled(false);
                this.mySelectDirectoryButton.setEnabled(false);
                this.myModuleComboBox.setEnabled(false);
                this.myScopeCombo.setEnabled(false);
            } else if (dirName != null) {
                this.myRbDirectory.setSelected(true);
                this.myCbWithSubdirectories.setEnabled(true);
                this.myDirectoryComboBox.setEnabled(true);
                this.mySelectDirectoryButton.setEnabled(true);
                this.myModuleComboBox.setEnabled(false);
                this.myScopeCombo.setEnabled(false);
            } else if (this.myModel.getModuleName() != null) {
                this.myRbModule.setSelected(true);
                this.myCbWithSubdirectories.setEnabled(false);
                this.myDirectoryComboBox.setEnabled(false);
                this.mySelectDirectoryButton.setEnabled(false);
                this.myModuleComboBox.setEnabled(true);
                this.myModuleComboBox.setSelectedItem((Object)this.myModel.getModuleName());
                this.myScopeCombo.setEnabled(false);
                this.myRbModule.setVisible(true);
                this.myModuleComboBox.setVisible(true);
            } else if (this.myModel.getCustomScopeName() != null) {
                this.myRbCustomScope.setSelected(true);
                this.myScopeCombo.setEnabled(true);
                this.myScopeCombo.init(this.myProject, true, true, this.myModel.getCustomScopeName());
                this.myCbWithSubdirectories.setEnabled(false);
                this.myDirectoryComboBox.setEnabled(false);
                this.mySelectDirectoryButton.setEnabled(false);
                this.myModuleComboBox.setEnabled(false);
            } else assert (false);
            this.myCbWithSubdirectories.setSelected(this.myModel.isWithSubdirectories());
            if (this.myModel.getFileFilter() != null && this.myModel.getFileFilter().length() > 0) {
                this.myFileFilter.setSelectedItem((Object)this.myModel.getFileFilter());
                this.myFileFilter.setEnabled(true);
                this.useFileFilter.setSelected(true);
            }
        } else {
            if (this.myModel.isForward()) {
                this.myRbForward.setSelected(true);
            } else {
                this.myRbBackward.setSelected(true);
            }
            if (this.myModel.isFromCursor()) {
                this.myRbFromCursor.setSelected(true);
            } else {
                this.myRbEntireScope.setSelected(true);
            }
            if (this.myModel.isGlobal()) {
                this.myRbGlobal.setSelected(true);
            } else {
                this.myRbSelectedText.setSelected(true);
            }
        }
        FindDialog.setStringsToComboBox(FindSettings.getInstance().getRecentFindStrings(), this.myInputComboBox, this.myModel.getStringToFind());
        if (this.myModel.isReplaceState()) {
            this.myCbPreserveCase.setSelected(this.myModel.isPreserveCase());
            FindDialog.setStringsToComboBox(FindSettings.getInstance().getRecentReplaceStrings(), this.myReplaceComboBox, this.myModel.getStringToReplace());
        }
        this.updateControls();
        this.validateFindButton();
    }
}

