/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.LibraryDownloadingMirrorsMap;
import com.intellij.facet.ui.libraries.LibraryDownloadInfo;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.io.UrlConnectionUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IOExceptionDialog;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDownloader {
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int READ_TIMEOUT = 60000;
    @NonNls
    private static final String LIB_SCHEMA = "lib://";
    private LibraryDownloadInfo[] myLibraryInfos;
    private final LibraryDownloadingMirrorsMap myMirrorsMap;
    private JComponent myParent;
    @Nullable
    private Project myProject;
    private String myDirectoryForDownloadedLibrariesPath;
    @Nullable
    private final String myLibraryPresentableName;

    public LibraryDownloader(LibraryDownloadInfo[] libraryInfos, @Nullable Project project, JComponent parent, @Nullable String directoryForDownloadedLibrariesPath, @Nullable String libraryPresentableName, LibraryDownloadingMirrorsMap mirrorsMap) {
        this.myProject = project;
        this.myLibraryInfos = libraryInfos;
        this.myParent = parent;
        this.myDirectoryForDownloadedLibrariesPath = directoryForDownloadedLibrariesPath;
        this.myLibraryPresentableName = libraryPresentableName;
        this.myMirrorsMap = mirrorsMap;
    }

    public LibraryDownloader(LibraryDownloadInfo[] libraryInfos, @Nullable Project project, @NotNull JComponent parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryDownloader.<init> must not be null");
        }
        this(libraryInfos, project, parent, null, null, new LibraryDownloadingMirrorsMap());
    }

    public LibraryDownloader(LibraryDownloadInfo[] libraryInfos, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryDownloader.<init> must not be null");
        }
        this.myLibraryInfos = libraryInfos;
        this.myProject = project;
        this.myLibraryPresentableName = null;
        this.myMirrorsMap = new LibraryDownloadingMirrorsMap();
    }

    public VirtualFile[] download() {
        VirtualFile dir = null;
        if (this.myDirectoryForDownloadedLibrariesPath != null) {
            File ioDir = new File(FileUtil.toSystemDependentName((String)this.myDirectoryForDownloadedLibrariesPath));
            ioDir.mkdirs();
            dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myDirectoryForDownloadedLibrariesPath);
        }
        if (dir == null) {
            dir = this.chooseDirectoryForLibraries();
        }
        if (dir != null) {
            return this.doDownload(dir);
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    private VirtualFile[] doDownload(final VirtualFile dir) {
        HttpConfigurable.getInstance().setAuthenticator();
        final ArrayList<Pair<LibraryDownloadInfo, File>> downloadedFiles = new ArrayList<Pair<LibraryDownloadInfo, File>>();
        final ArrayList<VirtualFile> existingFiles = new ArrayList<VirtualFile>();
        final Ref exceptionRef = Ref.create(null);
        final Ref currentLibrary = new Ref();
        String dialogTitle = IdeBundle.message((String)"progress.download.libraries.title", (Object[])new Object[0]);
        if (this.myLibraryPresentableName != null) {
            dialogTitle = IdeBundle.message((String)"progress.download.0.libraries.title", (Object[])new Object[]{StringUtil.capitalize((String)this.myLibraryPresentableName)});
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                try {
                    for (int i = 0; i < LibraryDownloader.this.myLibraryInfos.length; ++i) {
                        VirtualFile existing;
                        long size;
                        LibraryDownloadInfo info = LibraryDownloader.this.myLibraryInfos[i];
                        currentLibrary.set((Object)info);
                        if (indicator != null) {
                            indicator.checkCanceled();
                            indicator.setText(IdeBundle.message((String)"progress.0.of.1.file.downloaded.text", (Object[])new Object[]{i, LibraryDownloader.this.myLibraryInfos.length}));
                        }
                        long l = size = (existing = dir.findChild(LibraryDownloader.getExpectedFileName(info))) != null ? existing.getLength() : -1L;
                        if (LibraryDownloader.this.download(info, size, downloadedFiles)) continue;
                        existingFiles.add(existing);
                    }
                }
                catch (ProcessCanceledException e) {
                    exceptionRef.set((Object)e);
                }
                catch (IOException e) {
                    exceptionRef.set((Object)e);
                }
            }
        }, dialogTitle, true, this.myProject, this.myParent);
        Exception exception = (Exception)exceptionRef.get();
        if (exception == null) {
            try {
                return LibraryDownloader.moveToDir(existingFiles, downloadedFiles, dir);
            }
            catch (IOException e) {
                String title = IdeBundle.message((String)"progress.download.libraries.title", (Object[])new Object[0]);
                if (this.myProject != null) {
                    Messages.showErrorDialog((Project)this.myProject, (String)title, (String)e.getMessage());
                } else {
                    Messages.showErrorDialog((Component)this.myParent, (String)title, (String)e.getMessage());
                }
                return VirtualFile.EMPTY_ARRAY;
            }
        }
        LibraryDownloader.deleteFiles(downloadedFiles);
        if (exception instanceof IOException) {
            boolean tryAgain;
            String message = IdeBundle.message((String)"error.library.download.failed", (Object[])new Object[]{exception.getMessage()});
            if (currentLibrary.get() != null) {
                message = message + ": " + this.myMirrorsMap.getDownloadingUrl((LibraryDownloadInfo)currentLibrary.get());
            }
            if (tryAgain = IOExceptionDialog.showErrorDialog((String)IdeBundle.message((String)"progress.download.libraries.title", (Object[])new Object[0]), (String)message)) {
                return this.doDownload(dir);
            }
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @Nullable
    private VirtualFile chooseDirectoryForLibraries() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(IdeBundle.message((String)"dialog.directory.for.libraries.title", (Object[])new Object[0]));
        VirtualFile[] files = this.myProject != null ? FileChooser.chooseFiles((Project)this.myProject, (FileChooserDescriptor)descriptor, (VirtualFile)this.myProject.getBaseDir()) : FileChooser.chooseFiles((Component)this.myParent, (FileChooserDescriptor)descriptor);
        return files.length > 0 ? files[0] : null;
    }

    private static VirtualFile[] moveToDir(List<VirtualFile> existingFiles, List<Pair<LibraryDownloadInfo, File>> downloadedFiles, VirtualFile dir) throws IOException {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        File ioDir = VfsUtil.virtualToIoFile((VirtualFile)dir);
        for (Pair<LibraryDownloadInfo, File> pair : downloadedFiles) {
            VirtualFile file;
            File toFile;
            LibraryDownloadInfo info = (LibraryDownloadInfo)pair.getFirst();
            boolean dontTouch = info.getDownloadUrl().startsWith(LIB_SCHEMA) || info.getDownloadUrl().startsWith("file://");
            File file2 = toFile = dontTouch ? (File)pair.getSecond() : LibraryDownloader.generateName(info, ioDir);
            if (!dontTouch) {
                FileUtil.rename((File)((File)pair.getSecond()), (File)toFile);
            }
            if ((file = (VirtualFile)new WriteAction<VirtualFile>(){

                protected void run(Result<VirtualFile> result) {
                    String url = VfsUtil.getUrlForLibraryRoot((File)toFile);
                    LocalFileSystem.getInstance().refreshAndFindFileByIoFile(toFile);
                    result.setResult((Object)VirtualFileManager.getInstance().refreshAndFindFileByUrl(url));
                }
            }.execute().getResultObject()) == null) continue;
            files.add(file);
        }
        for (final VirtualFile file : existingFiles) {
            VirtualFile libraryRootFile = (VirtualFile)new WriteAction<VirtualFile>(){

                protected void run(Result<VirtualFile> result) {
                    String url = VfsUtil.getUrlForLibraryRoot((File)VfsUtil.virtualToIoFile((VirtualFile)file));
                    result.setResult((Object)VirtualFileManager.getInstance().refreshAndFindFileByUrl(url));
                }
            }.execute().getResultObject();
            if (libraryRootFile == null) continue;
            files.add(libraryRootFile);
        }
        return VfsUtil.toVirtualFileArray(files);
    }

    private static String getExpectedFileName(LibraryDownloadInfo info) {
        return info.getFileNamePrefix() + info.getFileNameSuffix();
    }

    private static File generateName(LibraryDownloadInfo info, File dir) {
        String prefix = info.getFileNamePrefix();
        String suffix = info.getFileNameSuffix();
        File file = new File(dir, prefix + suffix);
        int count = 1;
        while (file.exists()) {
            file = new File(dir, prefix + "_" + count + suffix);
            ++count;
        }
        return file;
    }

    private static void deleteFiles(List<Pair<LibraryDownloadInfo, File>> pairs) {
        for (Pair<LibraryDownloadInfo, File> pair : pairs) {
            FileUtil.delete((File)((File)pair.getSecond()));
        }
        pairs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean download(LibraryDownloadInfo libraryInfo, long existingFileSize, List<Pair<LibraryDownloadInfo, File>> downloadedFiles) throws IOException {
        File tempFile;
        boolean deleteFile;
        FilterOutputStream output;
        HttpURLConnection connection;
        block17: {
            int size;
            InputStream input;
            String presentableUrl;
            ProgressIndicator indicator;
            block15: {
                boolean bl;
                block16: {
                    indicator = ProgressManager.getInstance().getProgressIndicator();
                    presentableUrl = this.myMirrorsMap.getPresentableUrl(libraryInfo);
                    String url = this.myMirrorsMap.getDownloadingUrl(libraryInfo);
                    if (url.startsWith(LIB_SCHEMA)) {
                        indicator.setText2(IdeBundle.message((String)"progress.locate.jar.text", (Object[])new Object[]{LibraryDownloader.getExpectedFileName(libraryInfo)}));
                        String path = url.substring(LIB_SCHEMA.length()).replace('/', File.separatorChar);
                        File file = PathManager.findFileInLibDirectory((String)path);
                        downloadedFiles.add((Pair<LibraryDownloadInfo, File>)Pair.create((Object)libraryInfo, (Object)file));
                        return true;
                    }
                    if (url.startsWith("file://")) {
                        String path = url.substring("file://".length()).replace('/', File.separatorChar).replace('\\', File.separatorChar);
                        File file = new File(path);
                        if (!file.exists()) return true;
                        downloadedFiles.add((Pair<LibraryDownloadInfo, File>)Pair.create((Object)libraryInfo, (Object)file));
                        return true;
                    }
                    indicator.setText2(IdeBundle.message((String)"progress.connecting.to.dowload.jar.text", (Object[])new Object[]{presentableUrl}));
                    indicator.setIndeterminate(true);
                    connection = (HttpURLConnection)new URL(url).openConnection();
                    connection.setConnectTimeout(60000);
                    connection.setReadTimeout(60000);
                    input = null;
                    output = null;
                    deleteFile = true;
                    tempFile = null;
                    int responseCode = connection.getResponseCode();
                    if (responseCode != 200) {
                        throw new IOException(IdeBundle.message((String)"error.connection.failed.with.http.code.N", (Object[])new Object[]{responseCode}));
                    }
                    size = connection.getContentLength();
                    if (size == -1 || (long)size != existingFileSize) break block15;
                    bl = false;
                    if (input == null) break block16;
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
                if (deleteFile && tempFile != null) {
                    FileUtil.delete((File)tempFile);
                }
                connection.disconnect();
                return bl;
            }
            try {
                int len;
                tempFile = FileUtil.createTempFile((String)"downloaded", (String)"jar");
                input = UrlConnectionUtil.getConnectionInputStreamWithException(connection, indicator);
                output = new BufferedOutputStream(new FileOutputStream(tempFile));
                indicator.setText2(IdeBundle.message((String)"progress.download.jar.text", (Object[])new Object[]{LibraryDownloader.getExpectedFileName(libraryInfo), presentableUrl}));
                indicator.setIndeterminate(size == -1);
                byte[] buf = new byte[1024];
                int count = 0;
                while ((len = input.read(buf)) > 0) {
                    indicator.checkCanceled();
                    count += len;
                    if (size > 0) {
                        indicator.setFraction((double)count / (double)size);
                    }
                    ((BufferedOutputStream)output).write(buf, 0, len);
                }
                deleteFile = false;
                downloadedFiles.add((Pair<LibraryDownloadInfo, File>)Pair.create((Object)libraryInfo, (Object)tempFile));
                if (input == null) break block17;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
                if (deleteFile && tempFile != null) {
                    FileUtil.delete(tempFile);
                }
                connection.disconnect();
                throw throwable;
            }
            input.close();
        }
        if (output != null) {
            output.close();
        }
        if (deleteFile && tempFile != null) {
            FileUtil.delete((File)tempFile);
        }
        connection.disconnect();
        return true;
    }

    public static LibraryDownloadInfo[] getDownloadingInfos(LibraryInfo[] libraries) {
        ArrayList<LibraryDownloadInfo> downloadInfos = new ArrayList<LibraryDownloadInfo>();
        for (LibraryInfo library : libraries) {
            LibraryDownloadInfo downloadInfo = library.getDownloadingInfo();
            if (downloadInfo == null) continue;
            downloadInfos.add(downloadInfo);
        }
        return downloadInfos.toArray(new LibraryDownloadInfo[downloadInfos.size()]);
    }
}

