/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.autodetecting.FacetDetector;
import com.intellij.facet.autodetecting.UnderlyingFacetSelector;
import com.intellij.facet.impl.autodetecting.AutodetectionFilter;
import com.intellij.facet.impl.autodetecting.model.DetectedFacetInfo;
import com.intellij.facet.impl.autodetecting.model.FacetInfo2;
import com.intellij.facet.impl.autodetecting.model.ProjectFacetInfoSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiManager;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetDetectorWrapper<S, C extends FacetConfiguration, F extends Facet<C>, U extends FacetConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.autodetecting.FacetDetectorWrapper");
    private final AutodetectionFilter myAutodetectionFilter;
    private final VirtualFileFilter myVirtualFileFilter;
    private final FacetDetector<S, C> myFacetDetector;
    private final UnderlyingFacetSelector<VirtualFile, U> myUnderlyingFacetSelector;
    private final ProjectFacetInfoSet myDetectedFacetSet;
    private final FacetType<F, C> myFacetType;

    protected FacetDetectorWrapper(ProjectFacetInfoSet projectFacetSet, FacetType<F, C> facetType, AutodetectionFilter autodetectionFilter, VirtualFileFilter virtualFileFilter, FacetDetector<S, C> facetDetector, UnderlyingFacetSelector<VirtualFile, U> selector) {
        this.myDetectedFacetSet = projectFacetSet;
        this.myFacetType = facetType;
        this.myAutodetectionFilter = autodetectionFilter;
        this.myVirtualFileFilter = virtualFileFilter;
        this.myFacetDetector = facetDetector;
        this.myUnderlyingFacetSelector = selector;
    }

    public VirtualFileFilter getVirtualFileFilter() {
        return this.myVirtualFileFilter;
    }

    public FacetType<?, C> getFacetType() {
        return this.myFacetType;
    }

    @Nullable
    protected FacetInfo2<Module> detectFacet(@NotNull Module module, VirtualFile virtualFile, S source) {
        Map configurations;
        FacetConfiguration detectedConfiguration;
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetDetectorWrapper.detectFacet must not be null");
        }
        String url = virtualFile.getUrl();
        if (!this.myAutodetectionFilter.isAutodetectionEnabled(module, this.myFacetType, url)) {
            LOG.debug("Autodetection disabled for " + this.myFacetType.getPresentableName() + " facets in module " + module.getName());
            return null;
        }
        FacetInfo2<Module> underlyingFacet = null;
        FacetTypeId underlyingFacetType = this.myFacetType.getUnderlyingFacetType();
        if (underlyingFacetType != null) {
            if (this.myUnderlyingFacetSelector != null) {
                Map underlyingFacets = this.myDetectedFacetSet.getConfigurations(underlyingFacetType, module);
                FacetConfiguration undelyingConfiguration = this.myUnderlyingFacetSelector.selectUnderlyingFacet((Object)virtualFile, Collections.unmodifiableSet(underlyingFacets.keySet()));
                underlyingFacet = underlyingFacets.get(undelyingConfiguration);
            }
            if (underlyingFacet == null) {
                LOG.debug("Underlying " + underlyingFacetType + " facet not found for " + url);
                return null;
            }
        }
        if ((detectedConfiguration = this.myFacetDetector.detectFacet(source, Collections.unmodifiableSet((configurations = this.myDetectedFacetSet.getConfigurations(this.myFacetType.getId(), module)).keySet()))) == null) {
            return null;
        }
        if (configurations.containsKey(detectedConfiguration)) {
            return configurations.get(detectedConfiguration);
        }
        String name = this.myDetectedFacetSet.generateName(module, this.myFacetType);
        DetectedFacetInfo<Module> detected = this.myDetectedFacetSet.createInfo(module, url, underlyingFacet, detectedConfiguration, name, this.myFacetType, this.myFacetDetector.getId());
        this.myDetectedFacetSet.addFacetInfo((FacetInfo2<Module>)detected);
        return detected;
    }

    public String toString() {
        return this.myFacetType.getStringId() + ": " + this.myFacetDetector.getId();
    }

    @Nullable
    public abstract FacetInfo2<Module> detectFacet(VirtualFile var1, PsiManager var2);
}

