/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.testIntegration.TestLocationProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUrlProvider
implements TestLocationProvider {
    private static final Logger LOG = Logger.getInstance((String)FileUrlProvider.class.getName());
    @NonNls
    private static final String FILE_PROTOCOL_ID = "file";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocolId, @NotNull String path, Project project) {
        int lineNumber;
        String filePath;
        List<Object> list;
        if (protocolId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/FileUrlProvider.getLocation must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/FileUrlProvider.getLocation must not be null");
        }
        if (!FILE_PROTOCOL_ID.equals(protocolId)) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/execution/testframework/sm/FileUrlProvider.getLocation must not return null");
            return list;
        }
        String normalizedPath = path.replace(File.separatorChar, '/');
        int lineNoSeparatorIndex = normalizedPath.lastIndexOf(58);
        if (lineNoSeparatorIndex > 3) {
            String lineNumStr = normalizedPath.substring(lineNoSeparatorIndex + 1);
            int lineNum = 0;
            try {
                lineNum = Integer.parseInt(lineNumStr);
            }
            catch (NumberFormatException e) {
                LOG.warn(protocolId + ": Malformed location path: " + path, (Throwable)e);
            }
            filePath = normalizedPath.substring(0, lineNoSeparatorIndex);
            lineNumber = lineNum;
        } else {
            lineNumber = 1;
            filePath = normalizedPath;
        }
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)filePath);
        List<VirtualFile> virtualFiles = TestsLocationProviderUtil.findSuitableFilesFor(systemIndependentPath, project);
        if (virtualFiles.isEmpty()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/execution/testframework/sm/FileUrlProvider.getLocation must not return null");
            return list;
        }
        ArrayList<Location> locations = new ArrayList<Location>(2);
        for (VirtualFile file : virtualFiles) {
            locations.add(FileUrlProvider.createLocationFor(project, file, lineNumber));
        }
        list = locations;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/execution/testframework/sm/FileUrlProvider.getLocation must not return null");
    }

    @Nullable
    protected static Location createLocationFor(Project project, @NotNull VirtualFile virtualFile, int lineNum) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/FileUrlProvider.createLocationFor must not be null");
        }
        assert (lineNum > 0);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        int lineCount = doc.getLineCount();
        int lineStartOffset = lineNum <= lineCount ? doc.getLineStartOffset(lineNum - 1) : 0;
        PsiElement elementAtLine = psiFile.findElementAt(lineStartOffset);
        if (elementAtLine != null) {
            while (elementAtLine instanceof PsiWhiteSpace) {
                elementAtLine = elementAtLine.getNextSibling();
            }
        }
        PsiElement leafPsiElementAtLine = elementAtLine == null ? null : psiFile.findElementAt(elementAtLine.getTextOffset());
        return PsiLocation.fromPsiElement((Project)project, (PsiElement)(leafPsiElementAtLine != null ? leafPsiElementAtLine : psiFile));
    }
}

