/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.config.AbstractProperty;

public class TestFrameworkActions {
    public static void installFilterAction(final TestFrameworkRunningModel model) {
        final TestConsoleProperties properties = model.getProperties();
        TestFrameworkPropertyListener<Boolean> hidePropertyListener = new TestFrameworkPropertyListener<Boolean>(){

            @Override
            public void onChanged(Boolean value) {
                boolean shouldFilter = TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)properties);
                model.setFilter(shouldFilter ? Filter.NOT_PASSED.or(Filter.DEFECT) : Filter.NO_FILTER);
            }
        };
        TestFrameworkActions.addPropertyListener((AbstractProperty<Boolean>)TestConsoleProperties.HIDE_PASSED_TESTS, hidePropertyListener, model, true);
    }

    public static void addPropertyListener(final AbstractProperty<Boolean> property, final TestFrameworkPropertyListener<Boolean> propertyListener, TestFrameworkRunningModel model, boolean sendValue) {
        final TestConsoleProperties properties = model.getProperties();
        if (sendValue) {
            properties.addListenerAndSendValue(property, propertyListener);
        } else {
            properties.addListener(property, propertyListener);
        }
        Disposer.register((Disposable)model, (Disposable)new Disposable(){

            public void dispose() {
                properties.removeListener(property, propertyListener);
            }
        });
    }
}

