/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2;

import com.intellij.execution.junit2.PushReader;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import com.intellij.rt.execution.junit.segments.SegmentedStream;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.HashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class SegmentedInputStream
extends InputStream {
    private final PushReader mySourceStream;
    private PacketProcessor myEventsDispatcher;
    private int myStartupPassed = 0;

    public SegmentedInputStream(InputStream sourceStream, Charset charset) {
        this.mySourceStream = new PushReader(new BufferedReader(new InputStreamReader(sourceStream, charset)));
    }

    @Override
    public int read() throws IOException {
        if (this.myStartupPassed < "@#IJIDEA#JUnitSupport#@".length()) {
            return this.rawRead();
        }
        return this.findNextSymbol();
    }

    private int rawRead() throws IOException {
        while (this.myStartupPassed < "@#IJIDEA#JUnitSupport#@".length()) {
            int aChar = this.readNext();
            if (aChar != "@#IJIDEA#JUnitSupport#@".charAt(this.myStartupPassed)) {
                this.mySourceStream.pushBack(aChar);
                this.mySourceStream.pushBack("@#IJIDEA#JUnitSupport#@".substring(0, this.myStartupPassed).toCharArray());
                this.myStartupPassed = 0;
                return this.readNext();
            }
            ++this.myStartupPassed;
        }
        return this.read();
    }

    private int findNextSymbol() throws IOException {
        Integer packetRead;
        int nextByte;
        while ((nextByte = this.readNext()) == 47 && (packetRead = this.readControlSequence()) == null) {
        }
        return nextByte;
    }

    private Integer readControlSequence() throws IOException {
        for (int idx = 1; idx < SegmentedStream.MARKER_PREFIX.length(); ++idx) {
            int readAhead = this.readNext();
            if (readAhead == SegmentedStream.MARKER_PREFIX.charAt(idx)) continue;
            return readAhead;
        }
        char[] marker = this.readMarker();
        if (this.myEventsDispatcher != null) {
            this.myEventsDispatcher.processPacket(SegmentedInputStream.decode(marker));
        }
        return null;
    }

    public void setEventsDispatcher(PacketProcessor eventsDispatcher) {
        this.myEventsDispatcher = eventsDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] readMarker() throws IOException {
        int nextRead = 48;
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            while (nextRead != 32 && nextRead != 47) {
                buffer.append((char)nextRead);
                nextRead = this.readNext();
            }
            char[] cArray = this.readNext(Integer.valueOf(buffer.toString()));
            return cArray;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    private char[] readNext(int charCount) throws IOException {
        return this.mySourceStream.next(charCount);
    }

    private int readNext() throws IOException {
        return this.mySourceStream.next();
    }

    @Override
    public int available() throws IOException {
        HashMap map = new HashMap();
        map.keySet();
        while (this.mySourceStream.ready()) {
            while (this.myStartupPassed < "@#IJIDEA#JUnitSupport#@".length()) {
                int aChar = this.readNext();
                if (aChar != "@#IJIDEA#JUnitSupport#@".charAt(this.myStartupPassed)) {
                    this.mySourceStream.pushBack(aChar);
                    char[] charsRead = "@#IJIDEA#JUnitSupport#@".substring(0, this.myStartupPassed).toCharArray();
                    this.mySourceStream.pushBack(charsRead);
                    this.myStartupPassed = 0;
                    return charsRead.length + 1;
                }
                ++this.myStartupPassed;
            }
            int b = this.mySourceStream.next();
            if (b != 47) {
                this.mySourceStream.pushBack(b);
                return 1;
            }
            Integer packetRead = this.readControlSequence();
            if (packetRead == null) continue;
            this.mySourceStream.pushBack(packetRead);
            this.mySourceStream.pushBack(b);
            return 1;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.mySourceStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decode(char[] chars) {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            for (int i = 0; i < chars.length; ++i) {
                char decodedChar;
                char chr = chars[i];
                if (chr == '$') {
                    if ((chr = chars[++i]) != '$') {
                        StringBuffer codeBuffer = new StringBuffer(2);
                        codeBuffer.append(chr);
                        for (int j = 1; j < 2; ++j) {
                            codeBuffer.append(chars[i + j]);
                        }
                        ++i;
                        decodedChar = (char)Integer.parseInt(codeBuffer.toString());
                    } else {
                        decodedChar = chr;
                    }
                } else {
                    decodedChar = chr;
                }
                buffer.append(decodedChar);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }
}

