/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.AnyExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointPropertiesPanel;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ExceptionBreakpointPropertiesPanel
extends BreakpointPropertiesPanel {
    private JCheckBox myNotifyCaughtCheckBox;
    private JCheckBox myNotifyUncaughtCheckBox;
    private ExceptionBreakpoint myExceptionBreakpoint;

    public ExceptionBreakpointPropertiesPanel(Project project) {
        super(project, ExceptionBreakpoint.CATEGORY);
    }

    @Override
    protected TreeClassChooser.ClassFilter createClassConditionFilter() {
        return null;
    }

    @Override
    protected JComponent createSpecialBox() {
        this.myNotifyCaughtCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.exception.breakpoint.properties.panel.caught.exception", (Object[])new Object[0]));
        this.myNotifyUncaughtCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.exception.breakpoint.properties.panel.uncaught.exception", (Object[])new Object[0]));
        Box notificationsBox = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myNotifyCaughtCheckBox, "North");
        notificationsBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myNotifyUncaughtCheckBox, "North");
        notificationsBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        JPanel _panel0 = new JPanel(new BorderLayout());
        _panel0.add((Component)notificationsBox, "Center");
        _panel0.add(Box.createHorizontalStrut(3), "West");
        _panel0.add(Box.createHorizontalStrut(3), "East");
        _panel.add((Component)_panel0, "North");
        _panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), DebuggerBundle.message((String)"label.exception.breakpoint.properties.panel.group.notifications", (Object[])new Object[0])));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ExceptionBreakpointPropertiesPanel.this.myNotifyCaughtCheckBox.isSelected() && !ExceptionBreakpointPropertiesPanel.this.myNotifyUncaughtCheckBox.isSelected()) {
                    Object source = e.getSource();
                    JCheckBox toCheck = null;
                    if (ExceptionBreakpointPropertiesPanel.this.myNotifyCaughtCheckBox.equals(source)) {
                        toCheck = ExceptionBreakpointPropertiesPanel.this.myNotifyUncaughtCheckBox;
                    } else if (ExceptionBreakpointPropertiesPanel.this.myNotifyUncaughtCheckBox.equals(source)) {
                        toCheck = ExceptionBreakpointPropertiesPanel.this.myNotifyCaughtCheckBox;
                    }
                    if (toCheck != null) {
                        toCheck.setSelected(true);
                    }
                }
            }
        };
        this.myNotifyCaughtCheckBox.addActionListener(listener);
        this.myNotifyUncaughtCheckBox.addActionListener(listener);
        return _panel;
    }

    @Override
    protected void updateCheckboxes() {
        super.updateCheckboxes();
        this.myPassCountCheckbox.setEnabled(!(this.myExceptionBreakpoint instanceof AnyExceptionBreakpoint));
    }

    @Override
    public void initFrom(Breakpoint breakpoint) {
        ExceptionBreakpoint exceptionBreakpoint;
        this.myExceptionBreakpoint = exceptionBreakpoint = (ExceptionBreakpoint)breakpoint;
        super.initFrom(breakpoint);
        this.myNotifyCaughtCheckBox.setSelected(exceptionBreakpoint.NOTIFY_CAUGHT);
        this.myNotifyUncaughtCheckBox.setSelected(exceptionBreakpoint.NOTIFY_UNCAUGHT);
    }

    @Override
    public void saveTo(Breakpoint breakpoint, Runnable afterUpdate) {
        ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)breakpoint;
        exceptionBreakpoint.NOTIFY_CAUGHT = this.myNotifyCaughtCheckBox.isSelected();
        exceptionBreakpoint.NOTIFY_UNCAUGHT = this.myNotifyUncaughtCheckBox.isSelected();
        super.saveTo(breakpoint, afterUpdate);
    }
}

