/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.DebuggerView;
import com.intellij.debugger.ui.FramesPanel;
import com.intellij.debugger.ui.impl.MainWatchPanel;
import com.intellij.debugger.ui.impl.ThreadsPanel;
import com.intellij.debugger.ui.impl.VariablesPanel;
import com.intellij.debugger.ui.impl.WatchDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RestartAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.content.AlertIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.unscramble.ThreadState;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.ui.DebuggerLogConsoleManagerBase;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class DebuggerSessionTab
extends DebuggerLogConsoleManagerBase
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.DebuggerSessionTab");
    private static final Icon WATCH_RETURN_VALUES_ICON = IconLoader.getIcon((String)"/debugger/watchLastReturnValue.png");
    private static final Icon AUTO_VARS_ICONS = IconLoader.getIcon((String)"/debugger/autoVariablesMode.png");
    private final VariablesPanel myVariablesPanel;
    private final MainWatchPanel myWatchPanel;
    private ExecutionConsole myConsole;
    private ProgramRunner myRunner;
    private volatile DebuggerSession myDebuggerSession;
    private RunContentDescriptor myRunContentDescriptor;
    private final MyDebuggerStateManager myStateManager = new MyDebuggerStateManager();
    private final FramesPanel myFramesPanel;
    private final RunnerLayoutUi myUi;
    private ExecutionEnvironment myEnvironment;
    private RunProfile myConfiguration;
    public static final String BREAKPOINT_CONDITION = "breakpoint";
    private final ThreadsPanel myThreadsPanel;
    private static final String THREAD_DUMP_CONTENT_PREFIX = "Dump";
    private Icon myIcon;
    private int myThreadDumpsCount = 0;
    private int myCurrentThreadDumpId = 1;

    public DebuggerSessionTab(Project project, String sessionName, @Nullable Icon icon) {
        super(project);
        this.myIcon = icon;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("JavaDebugger", DebuggerBundle.message((String)"title.generic.debug.dialog", (Object[])new Object[0]), sessionName, (Disposable)this);
        this.myUi.getDefaults().initTabDefaults(0, "Debugger", null).initFocusContent("FrameContent", BREAKPOINT_CONDITION).initFocusContent("ConsoleContent", "startup", (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce(false));
        DefaultActionGroup focus = new DefaultActionGroup();
        focus.add(ActionManager.getInstance().getAction("Debugger.FocusOnBreakpoint"));
        this.myUi.getOptions().setAdditionalFocusActions((ActionGroup)focus);
        final DebuggerSettings debuggerSettings = DebuggerSettings.getInstance();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getContextManager().addListener(new DebuggerContextListener(){

                @Override
                public void changeEvent(DebuggerContextImpl newContext, int event) {
                    switch (event) {
                        case 1: {
                            DebuggerSessionTab.this.myUi.updateActionsNow();
                            if (!debuggerSettings.HIDE_DEBUGGER_ON_PROCESS_TERMINATION) break;
                            try {
                                ExecutionManager.getInstance((Project)DebuggerSessionTab.this.getProject()).getContentManager().hideRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), DebuggerSessionTab.this.myRunContentDescriptor);
                                break;
                            }
                            catch (NullPointerException e) {
                                LOG.debug((Throwable)e);
                            }
                        }
                    }
                }
            });
        }
        DefaultActionGroup stepping = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        stepping.add(actionManager.getAction("ShowExecutionPoint"));
        stepping.addSeparator();
        stepping.add(actionManager.getAction("StepOver"));
        stepping.add(actionManager.getAction("StepInto"));
        stepping.add(actionManager.getAction("ForceStepInto"));
        stepping.add(actionManager.getAction("StepOut"));
        stepping.addSeparator();
        stepping.add(actionManager.getAction("Debugger.PopFrame"));
        stepping.addSeparator();
        stepping.add(actionManager.getAction("RunToCursor"));
        this.myUi.getOptions().setTopToolbar((ActionGroup)stepping, "DebuggerToolbar");
        this.myWatchPanel = new MainWatchPanel(this.getProject(), this.getContextManager());
        this.myFramesPanel = new FramesPanel(this.getProject(), this.getContextManager());
        AlertIcon breakpointAlert = new AlertIcon(IconLoader.getIcon((String)"/debugger/breakpointAlert.png"));
        Content watches = this.myUi.createContent("WatchesContent", (JComponent)this.myWatchPanel, XDebuggerBundle.message((String)"debugger.session.tab.watches.title", (Object[])new Object[0]), XDebuggerUIConstants.WATCHES_TAB_ICON, null);
        watches.setCloseable(false);
        watches.setAlertIcon(breakpointAlert);
        DefaultActionGroup watchesGroup = new DefaultActionGroup();
        DebuggerSessionTab.addAction(watchesGroup, "Debugger.NewWatch");
        DebuggerSessionTab.addAction(watchesGroup, "Debugger.AddToWatch");
        DebuggerSessionTab.addAction(watchesGroup, "Debugger.RemoveWatch");
        watches.setActions((ActionGroup)watchesGroup, "DebuggerToolbar", (JComponent)((Object)this.myWatchPanel.getTree()));
        this.myUi.addContent(watches, 0, PlaceInGrid.right, false);
        Content framesContent = this.myUi.createContent("FrameContent", (JComponent)this.myFramesPanel, XDebuggerBundle.message((String)"debugger.session.tab.frames.title", (Object[])new Object[0]), XDebuggerUIConstants.FRAMES_TAB_ICON, null);
        framesContent.setCloseable(false);
        framesContent.setAlertIcon(breakpointAlert);
        DefaultActionGroup framesGroup = new DefaultActionGroup();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        framesGroup.add(actionsManager.createPrevOccurenceAction(this.myFramesPanel.getOccurenceNavigator()));
        framesGroup.add(actionsManager.createNextOccurenceAction(this.myFramesPanel.getOccurenceNavigator()));
        framesContent.setActions((ActionGroup)framesGroup, "DebuggerToolbar", (JComponent)this.myFramesPanel.getFramesList());
        this.myUi.addContent(framesContent, 0, PlaceInGrid.left, false);
        this.myVariablesPanel = new VariablesPanel(this.getProject(), this.myStateManager, this);
        this.myVariablesPanel.getFrameTree().setAutoVariablesMode(debuggerSettings.AUTO_VARIABLES_MODE);
        Content vars = this.myUi.createContent("VariablesContent", (JComponent)this.myVariablesPanel, XDebuggerBundle.message((String)"debugger.session.tab.variables.title", (Object[])new Object[0]), XDebuggerUIConstants.VARIABLES_TAB_ICON, null);
        vars.setCloseable(false);
        vars.setAlertIcon(breakpointAlert);
        DefaultActionGroup varsGroup = new DefaultActionGroup();
        DebuggerSessionTab.addAction(varsGroup, "EvaluateExpression");
        varsGroup.add((AnAction)new WatchLastMethodReturnValueAction());
        varsGroup.add((AnAction)new AutoVarsSwitchAction());
        vars.setActions((ActionGroup)varsGroup, "DebuggerToolbar", (JComponent)((Object)this.myVariablesPanel.getTree()));
        this.myUi.addContent(vars, 0, PlaceInGrid.center, false);
        this.myThreadsPanel = new ThreadsPanel(project, this.getContextManager());
        Content threadsContent = this.myUi.createContent("ThreadsContent", (JComponent)this.myThreadsPanel, XDebuggerBundle.message((String)"debugger.session.tab.threads.title", (Object[])new Object[0]), XDebuggerUIConstants.THREADS_TAB_ICON, null);
        threadsContent.setCloseable(false);
        this.myUi.addContent(threadsContent, 0, PlaceInGrid.left, true);
        for (Content each : this.myUi.getContents()) {
            DebuggerSessionTab.updateStatus(each);
        }
        this.myUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                DebuggerSessionTab.updateStatus(event.getContent());
            }
        }, (Disposable)this);
    }

    @Override
    public RunnerLayoutUi getUi() {
        return this.myUi;
    }

    private static void updateStatus(Content content) {
        if (content.getComponent() instanceof DebuggerView) {
            DebuggerView view = (DebuggerView)((Object)content.getComponent());
            if (content.isSelected()) {
                view.setUpdateEnabled(true);
                if (view.isRefreshNeeded()) {
                    view.rebuildIfVisible(8);
                }
            } else {
                view.setUpdateEnabled(false);
            }
        }
    }

    public MainWatchPanel getWatchPanel() {
        return this.myWatchPanel;
    }

    @Override
    public RunContentDescriptor getRunContentDescriptor() {
        return this.myRunContentDescriptor;
    }

    private RunContentDescriptor initUI(ExecutionResult executionResult) {
        AnAction[] actions;
        Content console;
        this.myConsole = executionResult.getExecutionConsole();
        this.myRunContentDescriptor = new RunContentDescriptor(this.myConsole, executionResult.getProcessHandler(), this.myUi.getComponent(), this.getSessionName(), this.myIcon);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myRunContentDescriptor;
        }
        this.myUi.removeContent(this.myUi.findContent("ConsoleContent"), true);
        if (this.myConsole instanceof ExecutionConsoleEx) {
            ((ExecutionConsoleEx)this.myConsole).buildUi(this.myUi);
            console = this.myUi.findContent("ConsoleContent");
            LOG.assertTrue(console != null, (Object)"Console content was not created");
        } else {
            console = this.myUi.createContent("ConsoleContent", this.myConsole.getComponent(), XDebuggerBundle.message((String)"debugger.session.tab.console.content.name", (Object[])new Object[0]), XDebuggerUIConstants.CONSOLE_TAB_ICON, this.myConsole.getPreferredFocusableComponent());
            console.setCloseable(false);
            this.myUi.addContent(console, 1, PlaceInGrid.bottom, false);
        }
        this.attachNotificationTo(console);
        if (this.myConsole != null) {
            Disposer.register((Disposable)this, (Disposable)this.myConsole);
        }
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        if (this.myConsole instanceof ConsoleView) {
            AnAction[] actions2;
            for (AnAction goaction : actions2 = ((ConsoleView)this.myConsole).createConsoleActions()) {
                consoleActions.add(goaction);
            }
        }
        console.setActions((ActionGroup)consoleActions, "DebuggerToolbar", this.myConsole.getPreferredFocusableComponent());
        this.initLogConsoles(this.myConfiguration, this.myRunContentDescriptor.getProcessHandler());
        DefaultActionGroup group = new DefaultActionGroup();
        Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
        RestartAction restarAction = new RestartAction(executor, this.myRunner, this.myRunContentDescriptor.getProcessHandler(), XDebuggerUIConstants.DEBUG_AGAIN_ICON, this.myRunContentDescriptor, this.myEnvironment);
        group.add((AnAction)restarAction);
        restarAction.registerShortcut(this.myUi.getComponent());
        if (executionResult instanceof DefaultExecutionResult && (actions = ((DefaultExecutionResult)executionResult).getRestartActions()) != null) {
            group.addAll(actions);
            if (actions.length > 0) {
                group.addSeparator();
            }
        }
        AnAction[] profileActions = executionResult.getActions();
        group.addAll(profileActions);
        DebuggerSessionTab.addActionToGroup(group, "Resume");
        DebuggerSessionTab.addActionToGroup(group, "Pause");
        DebuggerSessionTab.addActionToGroup(group, "Stop");
        if (executionResult instanceof DefaultExecutionResult) {
            group.addAll(((DefaultExecutionResult)executionResult).getAdditionalStopActions());
        }
        group.addSeparator();
        DebuggerSessionTab.addActionToGroup(group, "ViewBreakpoints");
        DebuggerSessionTab.addActionToGroup(group, "XDebugger.MuteBreakpoints");
        group.addSeparator();
        DebuggerSessionTab.addAction(group, "ExportThreads");
        DebuggerSessionTab.addAction(group, "DumpThreads");
        group.addSeparator();
        AnAction[] layout = this.myUi.getOptions().getLayoutActionsList();
        final AnAction layoutGroup = this.myUi.getOptions().getLayoutActions();
        DefaultActionGroup settings = new DefaultActionGroup("DebuggerSettings", true){

            public void update(AnActionEvent e) {
                e.getPresentation().setText(ActionsBundle.message((String)"group.XDebugger.settings.text", (Object[])new Object[0]));
                e.getPresentation().setIcon(layoutGroup.getTemplatePresentation().getIcon());
            }
        };
        for (AnAction each : layout) {
            settings.add(each);
        }
        if (layout.length > 0) {
            settings.addSeparator();
        }
        DebuggerSessionTab.addActionToGroup(settings, "XDebugger.AutoTooltip");
        group.add((AnAction)settings);
        group.addSeparator();
        DebuggerSessionTab.addActionToGroup(group, "PinToolwindowTab");
        group.add((AnAction)new CloseAction(executor, this.myRunContentDescriptor, this.getProject()));
        group.add((AnAction)new ContextHelpAction(executor.getHelpId()));
        this.myUi.getOptions().setLeftToolbar((ActionGroup)group, "DebuggerToolbar");
        return this.myRunContentDescriptor;
    }

    private void attachNotificationTo(final Content content) {
        if (this.myConsole instanceof ObservableConsoleView) {
            ObservableConsoleView observable = (ObservableConsoleView)this.myConsole;
            observable.addChangeListener(new ObservableConsoleView.ChangeListener(){

                public void contentAdded(Collection<ConsoleViewContentType> types) {
                    if (types.contains(ConsoleViewContentType.ERROR_OUTPUT) || types.contains(ConsoleViewContentType.NORMAL_OUTPUT)) {
                        content.fireAlert();
                    }
                }
            }, (Disposable)content);
        }
    }

    private static void addAction(DefaultActionGroup group, String actionId) {
        group.add(ActionManager.getInstance().getAction(actionId));
    }

    private static void addActionToGroup(DefaultActionGroup group, String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action != null) {
            group.add(action);
        }
    }

    @Override
    public void dispose() {
        this.disposeSession();
        this.myFramesPanel.dispose();
        this.myVariablesPanel.dispose();
        this.myWatchPanel.dispose();
        this.myThreadsPanel.dispose();
        this.myConsole = null;
        super.dispose();
    }

    private void disposeSession() {
        DebuggerSession session = this.myDebuggerSession;
        this.myDebuggerSession = null;
        if (session != null) {
            session.dispose();
        }
    }

    @Nullable
    private DebugProcessImpl getDebugProcess() {
        DebuggerSession session = this.myDebuggerSession;
        return session != null ? session.getProcess() : null;
    }

    public void reuse(DebuggerSessionTab reuseSession) {
        DebuggerTreeNodeImpl[] watches = reuseSession.getWatchPanel().getWatchTree().getWatches();
        WatchDebuggerTree watchTree = this.getWatchPanel().getWatchTree();
        for (DebuggerTreeNodeImpl watch : watches) {
            watchTree.addWatch((WatchItemDescriptor)watch.getDescriptor());
        }
    }

    protected void toFront() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ExecutionManager.getInstance((Project)this.getProject()).getContentManager().toFrontRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), this.myRunContentDescriptor);
            ProjectUtil.focusProjectWindow(this.getProject(), Registry.is((String)"debugger.mayBringFrameToFrontOnBreakpoint"));
        }
    }

    public String getSessionName() {
        return this.myConfiguration.getName();
    }

    public DebuggerStateManager getContextManager() {
        return this.myStateManager;
    }

    @Nullable
    public TextWithImports getSelectedExpression() {
        DebuggerSession session = this.myDebuggerSession;
        if (session == null || session.getState() != 3) {
            return null;
        }
        DebuggerTree tree = this.myVariablesPanel.getFrameTree();
        if (!(tree != null && ((Component)((Object)tree)).hasFocus() || (tree = this.myWatchPanel.getWatchTree()) != null && ((Component)((Object)tree)).hasFocus())) {
            return null;
        }
        TreePath path = ((JTree)((Object)tree)).getSelectionPath();
        if (path == null) {
            return null;
        }
        DebuggerTreeNodeImpl node = (DebuggerTreeNodeImpl)path.getLastPathComponent();
        if (node == null) {
            return null;
        }
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (!(descriptor instanceof ValueDescriptorImpl)) {
            return null;
        }
        if (descriptor instanceof WatchItemDescriptor) {
            return ((WatchItemDescriptor)descriptor).getEvaluationText();
        }
        try {
            return DebuggerTreeNodeExpression.createEvaluationText(node, this.getContextManager().getContext());
        }
        catch (EvaluateException e) {
            return null;
        }
    }

    public RunContentDescriptor attachToSession(DebuggerSession session, ProgramRunner runner, ExecutionEnvironment env) throws ExecutionException {
        this.disposeSession();
        this.myDebuggerSession = session;
        this.myRunner = runner;
        this.myEnvironment = env;
        this.myConfiguration = env.getRunProfile();
        this.registerFileMatcher(this.myConfiguration);
        session.getContextManager().addListener(new DebuggerContextListener(){

            @Override
            public void changeEvent(DebuggerContextImpl newContext, int event) {
                if (DebuggerSessionTab.this.myUi.isDisposed()) {
                    return;
                }
                DebuggerSessionTab.this.attractFramesOnPause(event);
                DebuggerSessionTab.this.myStateManager.fireStateChanged(newContext, event);
            }
        });
        return this.initUI(this.getDebugProcess().getExecutionResult());
    }

    private void attractFramesOnPause(int event) {
        if (6 == event) {
            this.myUi.attractBy(BREAKPOINT_CONDITION);
        } else if (4 == event) {
            this.myUi.clearAttractionBy(BREAKPOINT_CONDITION);
        }
    }

    public DebuggerSession getSession() {
        return this.myDebuggerSession;
    }

    public void showFramePanel() {
        this.myUi.selectAndFocus(this.myUi.findContent("FrameContent"), true, false);
    }

    public void addThreadDump(List<ThreadState> threads) {
        Project project = this.getProject();
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        consoleBuilder.addFilter((Filter)new ExceptionFilter(this.myDebuggerSession.getSearchScope()));
        ConsoleView consoleView = consoleBuilder.getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ThreadDumpPanel panel = new ThreadDumpPanel(project, consoleView, toolbarActions, threads);
        Icon icon = null;
        String id = this.createThreadDumpContentId();
        final Content content = this.myUi.createContent(id, (JComponent)panel, id, icon, null);
        content.setCloseable(true);
        content.setDescription("Thread Dump");
        this.myUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(ContentManagerEvent event) {
                if (event.getContent() == content) {
                    DebuggerSessionTab.this.myThreadDumpsCount -= 1;
                    if (DebuggerSessionTab.this.myThreadDumpsCount == 0) {
                        DebuggerSessionTab.this.myCurrentThreadDumpId = 1;
                    }
                    DebuggerSessionTab.this.myUi.removeListener((ContentManagerListener)this);
                }
            }
        }, (Disposable)content);
        this.myUi.addContent(content);
        ++this.myThreadDumpsCount;
        ++this.myCurrentThreadDumpId;
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DebuggerSessionTab.this.myUi.removeContent(content, true);
            }
        });
        this.myUi.selectAndFocus(content, true, false);
        if (threads.size() > 0) {
            panel.selectStackFrame(0);
        }
    }

    private String createThreadDumpContentId() {
        return "Dump #" + this.myCurrentThreadDumpId;
    }

    private class WatchLastMethodReturnValueAction
    extends ToggleAction {
        private volatile boolean myWatchesReturnValues;
        private final String myTextEnable;
        private final String myTextUnavailable;
        private final String myMyTextDisable;

        public WatchLastMethodReturnValueAction() {
            super("", DebuggerBundle.message((String)"action.watch.method.return.value.description", (Object[])new Object[0]), WATCH_RETURN_VALUES_ICON);
            this.myWatchesReturnValues = DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
            this.myTextEnable = DebuggerBundle.message((String)"action.watches.method.return.value.enable", (Object[])new Object[0]);
            this.myMyTextDisable = DebuggerBundle.message((String)"action.watches.method.return.value.disable", (Object[])new Object[0]);
            this.myTextUnavailable = DebuggerBundle.message((String)"action.watches.method.return.value.unavailable.reason", (Object[])new Object[0]);
        }

        public void update(AnActionEvent e) {
            String actionText;
            super.update(e);
            Presentation presentation = e.getPresentation();
            boolean watchValues = (Boolean)presentation.getClientProperty("selected");
            DebugProcessImpl process = DebuggerSessionTab.this.getDebugProcess();
            String string = actionText = watchValues ? this.myMyTextDisable : this.myTextEnable;
            if (process != null && process.canGetMethodReturnValue()) {
                presentation.setEnabled(true);
                presentation.setText(actionText);
            } else {
                presentation.setEnabled(false);
                presentation.setText(process == null ? actionText : this.myTextUnavailable);
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myWatchesReturnValues;
        }

        public void setSelected(AnActionEvent e, boolean watch) {
            this.myWatchesReturnValues = watch;
            DebuggerSettings.getInstance().WATCH_RETURN_VALUES = watch;
            DebugProcessImpl process = DebuggerSessionTab.this.getDebugProcess();
            if (process != null) {
                process.setWatchMethodReturnValuesEnabled(watch);
            }
        }
    }

    private class AutoVarsSwitchAction
    extends ToggleAction {
        private volatile boolean myAutoModeEnabled;
        private static final String myAutoModeText = "Auto-Variables Mode";
        private static final String myDefaultModeText = "All-Variables Mode";

        public AutoVarsSwitchAction() {
            super("", "", AUTO_VARS_ICONS);
            this.myAutoModeEnabled = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            boolean autoModeEnabled = (Boolean)presentation.getClientProperty("selected");
            presentation.setText(autoModeEnabled ? myDefaultModeText : myAutoModeText);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myAutoModeEnabled;
        }

        public void setSelected(AnActionEvent e, boolean enabled) {
            this.myAutoModeEnabled = enabled;
            DebuggerSettings.getInstance().AUTO_VARIABLES_MODE = enabled;
            DebuggerSessionTab.this.myVariablesPanel.getFrameTree().setAutoVariablesMode(enabled);
        }
    }

    private class MyDebuggerStateManager
    extends DebuggerStateManager {
        private MyDebuggerStateManager() {
        }

        @Override
        public void fireStateChanged(DebuggerContextImpl newContext, int event) {
            super.fireStateChanged(newContext, event);
        }

        @Override
        public DebuggerContextImpl getContext() {
            DebuggerSession session = DebuggerSessionTab.this.myDebuggerSession;
            return session != null ? session.getContextManager().getContext() : DebuggerContextImpl.EMPTY_CONTEXT;
        }

        @Override
        public void setState(DebuggerContextImpl context, int state, int event, String description) {
            DebuggerSession session = DebuggerSessionTab.this.myDebuggerSession;
            if (session != null) {
                session.getContextManager().setState(context, state, event, description);
            }
        }
    }
}

