/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;

public class MethodEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.MethodEvaluator");
    private final JVMName myClassName;
    private final JVMName myMethodSignature;
    private final String myMethodName;
    private final List myArgumentEvaluators;
    private final Evaluator myObjectEvaluator;

    public MethodEvaluator(Evaluator objectEvaluator, JVMName className, String methodName, JVMName signature, List argumentEvaluators) {
        this.myObjectEvaluator = objectEvaluator;
        this.myClassName = className;
        this.myMethodName = methodName;
        this.myMethodSignature = signature;
        this.myArgumentEvaluators = argumentEvaluators;
    }

    @Override
    public Modifier getModifier() {
        return null;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        if (!context.getDebugProcess().isAttached()) {
            return null;
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        boolean requiresSuperObject = this.myObjectEvaluator instanceof SuperEvaluator;
        Object object = this.myObjectEvaluator.evaluate(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("MethodEvaluator: object = " + object);
        }
        if (object == null) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)new NullPointerException());
        }
        if (!(object instanceof ObjectReference) && !(object instanceof ClassType)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.evaluating.method", (Object[])new Object[]{this.myMethodName}));
        }
        ArrayList<Object> args = new ArrayList<Object>(this.myArgumentEvaluators.size());
        for (Evaluator evaluator : this.myArgumentEvaluators) {
            args.add(evaluator.evaluate(context));
        }
        try {
            Method jdiMethod;
            ReferenceType qualifierType;
            ReferenceType referenceType = null;
            if (object instanceof ObjectReference) {
                qualifierType = ((ObjectReference)object).referenceType();
                referenceType = debugProcess.findClass(context, qualifierType.name(), qualifierType.classLoader());
            } else if (object instanceof ClassType) {
                qualifierType = (ClassType)object;
                referenceType = debugProcess.findClass(context, qualifierType.name(), context.getClassLoader());
            } else {
                String className;
                String string = className = this.myClassName != null ? this.myClassName.getName(debugProcess) : null;
                if (className != null) {
                    referenceType = debugProcess.findClass(context, className, context.getClassLoader());
                }
            }
            if (referenceType == null) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{this.myMethodName})));
            }
            String signature = this.myMethodSignature != null ? this.myMethodSignature.getName(debugProcess) : null;
            String methodName = DebuggerUtilsEx.methodName(referenceType.name(), this.myMethodName, signature);
            if (object instanceof ClassType) {
                List<Method> list;
                Method jdiMethod2;
                if (referenceType instanceof ClassType && (jdiMethod2 = this.myMethodSignature != null ? ((ClassType)referenceType).concreteMethodByName(this.myMethodName, this.myMethodSignature.getName(debugProcess)) : (Method)((list = referenceType.methodsByName(this.myMethodName)).size() > 0 ? list.get(0) : null)) != null && jdiMethod2.isStatic()) {
                    return debugProcess.invokeMethod((EvaluationContext)context, (ClassType)referenceType, jdiMethod2, args);
                }
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.static.method", (Object[])new Object[]{methodName}));
            }
            ObjectReference objRef = (ObjectReference)object;
            ReferenceType _refType = referenceType;
            if (requiresSuperObject && referenceType instanceof ClassType) {
                _refType = ((ClassType)referenceType).superclass();
            }
            if ((jdiMethod = DebuggerUtilsEx.findMethod((ReferenceType)_refType, (String)this.myMethodName, (String)signature)) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.instance.method", (Object[])new Object[]{methodName}));
            }
            if (requiresSuperObject) {
                return debugProcess.invokeInstanceMethod(context, objRef, jdiMethod, args, 2);
            }
            return debugProcess.invokeMethod((EvaluationContext)context, objRef, jdiMethod, args);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e);
            }
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }
}

