/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.classParsing.AnnotationConstantValue;
import com.intellij.compiler.classParsing.AnnotationNameValuePair;
import com.intellij.compiler.classParsing.ClassFileReader;
import com.intellij.compiler.classParsing.ConstantValue;
import com.intellij.compiler.classParsing.FieldInfo;
import com.intellij.compiler.classParsing.MemberInfo;
import com.intellij.compiler.classParsing.MemberReferenceInfo;
import com.intellij.compiler.classParsing.MethodInfo;
import com.intellij.compiler.classParsing.ReferenceInfo;
import com.intellij.compiler.classParsing.SignatureParsingException;
import com.intellij.compiler.impl.javaCompiler.DependencyProcessor;
import com.intellij.compiler.make.BoundsParser;
import com.intellij.compiler.make.Cache;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CacheUtils;
import com.intellij.compiler.make.CachingSearcher;
import com.intellij.compiler.make.ChangedConstantsDependencyProcessor;
import com.intellij.compiler.make.ChangedRetentionPolicyDependencyProcessor;
import com.intellij.compiler.make.ClassInfoProcessor;
import com.intellij.compiler.make.Dependency;
import com.intellij.compiler.make.DependencyCacheNavigator;
import com.intellij.compiler.make.JavaDependencyProcessor;
import com.intellij.compiler.make.MakeUtil;
import com.intellij.compiler.make.SourceFileFinder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.cls.ClsUtil;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyCache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.DependencyCache");
    private Cache myCache;
    private Cache myNewClassesCache;
    private static final String REMOTE_INTERFACE_NAME = Remote.class.getName();
    private TIntHashSet myToUpdate = new TIntHashSet();
    private final TIntHashSet myTraverseRoots = new TIntHashSet();
    private final TIntHashSet myClassesWithSourceRemoved = new TIntHashSet();
    private final TIntHashSet myPreviouslyRemoteClasses = new TIntHashSet();
    private final TIntHashSet myMarkedInfos = new TIntHashSet();
    private final Set<VirtualFile> myMarkedFiles = new HashSet<VirtualFile>();
    private DependencyCacheNavigator myCacheNavigator;
    private SymbolTable mySymbolTable;
    private final String mySymbolTableFilePath;
    private final String myStoreDirectoryPath;
    @NonNls
    private static final String SYMBOLTABLE_FILE_NAME = "symboltable.dat";

    public DependencyCache(@NonNls String storeDirectoryPath) {
        this.myStoreDirectoryPath = storeDirectoryPath;
        LOG.assertTrue(this.myStoreDirectoryPath != null);
        this.mySymbolTableFilePath = this.myStoreDirectoryPath + "/" + SYMBOLTABLE_FILE_NAME;
    }

    public DependencyCacheNavigator getCacheNavigator() throws CacheCorruptedException {
        if (this.myCacheNavigator == null) {
            this.myCacheNavigator = new DependencyCacheNavigator(this.getCache());
        }
        return this.myCacheNavigator;
    }

    public void wipe() throws CacheCorruptedException {
        this.getCache().wipe();
        this.getNewClassesCache().wipe();
    }

    public Cache getCache() throws CacheCorruptedException {
        try {
            if (this.myCache == null) {
                this.myCache = new Cache(this.myStoreDirectoryPath, 512);
            }
            return this.myCache;
        }
        catch (IOException e) {
            throw new CacheCorruptedException(e);
        }
    }

    public Cache getNewClassesCache() throws CacheCorruptedException {
        try {
            if (this.myNewClassesCache == null) {
                this.myNewClassesCache = new Cache(this.myStoreDirectoryPath + "/tmp", 16);
            }
            return this.myNewClassesCache;
        }
        catch (IOException e) {
            throw new CacheCorruptedException(e);
        }
    }

    public void addTraverseRoot(int qName) {
        this.myTraverseRoots.add(qName);
    }

    public void clearTraverseRoots() {
        this.myTraverseRoots.clear();
    }

    public boolean hasUnprocessedTraverseRoots() {
        return !this.myTraverseRoots.isEmpty();
    }

    public void markSourceRemoved(int qName) {
        this.myClassesWithSourceRemoved.add(qName);
    }

    public void addClassToUpdate(int qName) {
        this.myToUpdate.add(qName);
    }

    public int reparseClassFile(@NotNull File file, byte[] fileContent) throws ClsFormatException, CacheCorruptedException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/make/DependencyCache.reparseClassFile must not be null");
        }
        SymbolTable symbolTable = this.getSymbolTable();
        int qName = this.getNewClassesCache().importClassInfo(new ClassFileReader(file, symbolTable, fileContent), symbolTable);
        this.addClassToUpdate(qName);
        this.addTraverseRoot(qName);
        return qName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws CacheCorruptedException {
        if (this.myToUpdate.isEmpty()) {
            return;
        }
        int[] namesToUpdate = this.myToUpdate.toArray();
        final Cache cache = this.getCache();
        Cache newCache = this.getNewClassesCache();
        DependencyCacheNavigator navigator = this.getCacheNavigator();
        for (final int qName : namesToUpdate) {
            for (int referencedClassQName : cache.getReferencedClasses(qName)) {
                if (!cache.containsClass(referencedClassQName)) continue;
                cache.removeClassReferencer(referencedClassQName, qName);
            }
            cache.clearReferencedClasses(qName);
            navigator.walkSuperClasses(qName, new ClassInfoProcessor(){

                @Override
                public boolean process(int classQName) throws CacheCorruptedException {
                    cache.removeSubclass(classQName, qName);
                    return true;
                }
            });
        }
        for (final int qName : namesToUpdate) {
            cache.importClassInfo(newCache, qName);
        }
        SymbolTable symbolTable = this.getSymbolTable();
        for (int qName : namesToUpdate) {
            boolean wasRemote;
            if (!newCache.containsClass(qName)) continue;
            this.buildForwardDependencies(qName, newCache.getReferences(qName));
            boolean isRemote = false;
            int[] superInterfaces = cache.getSuperInterfaces(qName);
            if (superInterfaces.length > 0) {
                int remoteInterfaceName = symbolTable.getId(REMOTE_INTERFACE_NAME);
                for (int superInterface : superInterfaces) {
                    if (!DependencyCache.isRemoteInterface(cache, superInterface, remoteInterfaceName)) continue;
                    isRemote = true;
                    break;
                }
            }
            if ((wasRemote = cache.isRemote(qName)) && !isRemote) {
                TIntHashSet tIntHashSet = this.myPreviouslyRemoteClasses;
                synchronized (tIntHashSet) {
                    this.myPreviouslyRemoteClasses.add(qName);
                }
            }
            cache.setRemote(qName, isRemote);
        }
        for (int qName : namesToUpdate) {
            DependencyCache.buildSubclassDependencies(this.getCache(), qName, qName);
        }
        for (int qName : this.myClassesWithSourceRemoved.toArray()) {
            cache.removeClass(qName);
        }
        this.myToUpdate = new TIntHashSet();
    }

    /*
     * WARNING - void declaration
     */
    private void buildForwardDependencies(int classQName, Collection<ReferenceInfo> references) throws CacheCorruptedException {
        Cache cache = this.getCache();
        int genericSignature = cache.getGenericSignature(classQName);
        if (genericSignature != -1) {
            void var9_13;
            int[] bounds;
            String genericClassSignature = this.resolve(genericSignature);
            int[] arr$ = bounds = this.findBounds(genericClassSignature);
            int len$ = arr$.length;
            boolean bl = false;
            while (var9_13 < len$) {
                int boundClassQName = arr$[var9_13];
                cache.addClassReferencer(boundClassQName, classQName);
                ++var9_13;
            }
        }
        this.buildAnnotationDependencies(classQName, cache.getRuntimeVisibleAnnotations(classQName));
        this.buildAnnotationDependencies(classQName, cache.getRuntimeInvisibleAnnotations(classQName));
        for (ReferenceInfo refInfo : references) {
            int declaringClassName = this.getActualDeclaringClassForReference(refInfo);
            if (declaringClassName == -1) continue;
            if (refInfo instanceof MemberReferenceInfo) {
                MemberInfo memberInfo = ((MemberReferenceInfo)refInfo).getMemberInfo();
                if (memberInfo instanceof FieldInfo) {
                    cache.addFieldReferencer(declaringClassName, memberInfo.getName(), classQName);
                    continue;
                }
                if (memberInfo instanceof MethodInfo) {
                    cache.addMethodReferencer(declaringClassName, memberInfo.getName(), memberInfo.getDescriptor(), classQName);
                    continue;
                }
                LOG.error("Unknown member info class: " + memberInfo.getClass().getName());
                continue;
            }
            cache.addClassReferencer(declaringClassName, classQName);
        }
        SymbolTable symbolTable = this.getSymbolTable();
        for (FieldInfo fieldInfo : cache.getFields(classQName)) {
            this.buildAnnotationDependencies(classQName, fieldInfo.getRuntimeVisibleAnnotations());
            this.buildAnnotationDependencies(classQName, fieldInfo.getRuntimeInvisibleAnnotations());
            String className = MakeUtil.parseObjectType(symbolTable.getSymbol(fieldInfo.getDescriptor()), 0);
            if (className == null) continue;
            int cls = symbolTable.getId(className);
            cache.addClassReferencer(cls, classQName);
        }
        for (MemberInfo memberInfo : cache.getMethods(classQName)) {
            String[] parameterSignatures;
            this.buildAnnotationDependencies(classQName, memberInfo.getRuntimeVisibleAnnotations());
            this.buildAnnotationDependencies(classQName, memberInfo.getRuntimeInvisibleAnnotations());
            this.buildAnnotationDependencies(classQName, ((MethodInfo)memberInfo).getRuntimeVisibleParameterAnnotations());
            this.buildAnnotationDependencies(classQName, ((MethodInfo)memberInfo).getRuntimeInvisibleParameterAnnotations());
            if (((MethodInfo)memberInfo).isConstructor()) continue;
            String returnTypeClassName = MakeUtil.parseObjectType(((MethodInfo)memberInfo).getReturnTypeDescriptor(symbolTable), 0);
            if (returnTypeClassName != null) {
                int returnTypeClassQName = symbolTable.getId(returnTypeClassName);
                cache.addClassReferencer(returnTypeClassQName, classQName);
            }
            for (String parameterSignature : parameterSignatures = CacheUtils.getParameterSignatures((MethodInfo)memberInfo, symbolTable)) {
                String paramClassName = MakeUtil.parseObjectType(parameterSignature, 0);
                if (paramClassName == null) continue;
                int paramClassId = symbolTable.getId(paramClassName);
                cache.addClassReferencer(paramClassId, classQName);
            }
        }
    }

    private static boolean isRemoteInterface(Cache cache, int ifaceName, int remoteInterfaceName) throws CacheCorruptedException {
        if (ifaceName == remoteInterfaceName) {
            return true;
        }
        for (int superInterfaceName : cache.getSuperInterfaces(ifaceName)) {
            if (!DependencyCache.isRemoteInterface(cache, superInterfaceName, remoteInterfaceName)) continue;
            return true;
        }
        return false;
    }

    private void buildAnnotationDependencies(int classQName, AnnotationConstantValue[][] annotations) throws CacheCorruptedException {
        if (annotations == null || annotations.length == 0) {
            return;
        }
        for (AnnotationConstantValue[] annotation : annotations) {
            this.buildAnnotationDependencies(classQName, annotation);
        }
    }

    private void buildAnnotationDependencies(int classQName, AnnotationConstantValue[] annotations) throws CacheCorruptedException {
        if (annotations == null || annotations.length == 0) {
            return;
        }
        Cache cache = this.getCache();
        for (AnnotationConstantValue annotation : annotations) {
            AnnotationNameValuePair[] memberValues;
            int annotationQName = annotation.getAnnotationQName();
            cache.addClassReferencer(annotationQName, classQName);
            for (AnnotationNameValuePair nameValuePair : memberValues = annotation.getMemberValues()) {
                for (MethodInfo annotationMember : cache.findMethodsByName(annotationQName, nameValuePair.getName())) {
                    cache.addMethodReferencer(annotationQName, annotationMember.getName(), annotationMember.getDescriptor(), classQName);
                }
            }
        }
    }

    private int[] findBounds(String genericClassSignature) throws CacheCorruptedException {
        try {
            String[] boundInterfaces = BoundsParser.getBounds(genericClassSignature);
            int[] ids = ArrayUtil.newIntArray((int)boundInterfaces.length);
            for (int i = 0; i < boundInterfaces.length; ++i) {
                ids[i] = this.getSymbolTable().getId(boundInterfaces[i]);
            }
            return ids;
        }
        catch (SignatureParsingException e) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
    }

    private int getActualDeclaringClassForReference(ReferenceInfo refInfo) throws CacheCorruptedException {
        if (!(refInfo instanceof MemberReferenceInfo)) {
            return refInfo.getClassName();
        }
        int declaringClassName = refInfo.getClassName();
        Cache cache = this.getCache();
        MemberInfo memberInfo = ((MemberReferenceInfo)refInfo).getMemberInfo();
        if (memberInfo instanceof FieldInfo ? cache.findFieldByName(declaringClassName, memberInfo.getName()) != null : memberInfo instanceof MethodInfo && cache.findMethod(declaringClassName, memberInfo.getName(), memberInfo.getDescriptor()) != null) {
            return declaringClassName;
        }
        DeclaringClassFinder finder = new DeclaringClassFinder(memberInfo);
        this.getCacheNavigator().walkSuperClasses(declaringClassName, finder);
        return finder.getDeclaringClassName();
    }

    public Pair<int[], Set<VirtualFile>> findDependentClasses(CompileContext context, Project project, Set<VirtualFile> successfullyCompiled, @Nullable DependencyProcessor additionalProcessor) throws CacheCorruptedException {
        this.markDependencies(context, project, successfullyCompiled, additionalProcessor);
        return new Pair((Object)this.myMarkedInfos.toArray(), Collections.unmodifiableSet(this.myMarkedFiles));
    }

    private void markDependencies(CompileContext context, Project project, final Set<VirtualFile> successfullyCompiled, @Nullable DependencyProcessor additionalProcessor) throws CacheCorruptedException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("====================Marking dependent files=====================");
            }
            int[] traverseRoots = this.myTraverseRoots.toArray();
            final SourceFileFinder sourceFileFinder = new SourceFileFinder(project, context);
            CachingSearcher searcher = new CachingSearcher(project);
            ChangedRetentionPolicyDependencyProcessor changedRetentionPolicyDependencyProcessor = new ChangedRetentionPolicyDependencyProcessor(project, searcher, this);
            for (int qName : traverseRoots) {
                Dependency[] backDependencies;
                if (!this.getCache().containsClass(qName)) continue;
                if (this.getNewClassesCache().containsClass(qName)) {
                    new JavaDependencyProcessor(project, this, qName).run();
                    ArrayList<ChangedConstantsDependencyProcessor.FieldChangeInfo> changed = new ArrayList<ChangedConstantsDependencyProcessor.FieldChangeInfo>();
                    ArrayList<ChangedConstantsDependencyProcessor.FieldChangeInfo> removed = new ArrayList<ChangedConstantsDependencyProcessor.FieldChangeInfo>();
                    this.findModifiedConstants(qName, changed, removed);
                    if (!changed.isEmpty() || !removed.isEmpty()) {
                        new ChangedConstantsDependencyProcessor(project, searcher, this, qName, context.getProgressIndicator().isCanceled(), changed.toArray(new ChangedConstantsDependencyProcessor.FieldChangeInfo[changed.size()]), removed.toArray(new ChangedConstantsDependencyProcessor.FieldChangeInfo[removed.size()])).run();
                    }
                    changedRetentionPolicyDependencyProcessor.checkAnnotationRetentionPolicyChanges(qName);
                    if (additionalProcessor == null) continue;
                    additionalProcessor.processDependencies(context, qName);
                    continue;
                }
                boolean isSourceDeleted = false;
                if (this.myClassesWithSourceRemoved.contains(qName)) {
                    isSourceDeleted = true;
                } else if (!new File(this.getCache().getPath(qName)).exists()) {
                    final String qualifiedName = this.resolve(qName);
                    final String sourceFileName = this.getCache().getSourceFileName(qName);
                    boolean markAsRemovedSource = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                        public Boolean compute() {
                            VirtualFile sourceFile = sourceFileFinder.findSourceFile(qualifiedName, sourceFileName);
                            return sourceFile == null || successfullyCompiled.contains(sourceFile) ? Boolean.TRUE : Boolean.FALSE;
                        }
                    });
                    if (markAsRemovedSource) {
                        isSourceDeleted = true;
                        this.markSourceRemoved(qName);
                        this.myMarkedInfos.remove(qName);
                    }
                }
                if (!isSourceDeleted) continue;
                for (Dependency backDependency : backDependencies = this.getCache().getBackDependencies(qName)) {
                    if (!this.markTargetClassInfo(backDependency) || !LOG.isDebugEnabled()) continue;
                    LOG.debug("Mark dependent class " + backDependency.getClassQualifiedName() + "; reason: no class file found for " + qName);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("================================================================");
            }
        }
        catch (ProcessCanceledException ignored) {
            // empty catch block
        }
    }

    private void findModifiedConstants(int qName, Collection<ChangedConstantsDependencyProcessor.FieldChangeInfo> changedConstants, Collection<ChangedConstantsDependencyProcessor.FieldChangeInfo> removedConstants) throws CacheCorruptedException {
        Cache cache = this.getCache();
        for (FieldInfo field : cache.getFields(qName)) {
            int oldFlags = field.getFlags();
            if (!ClsUtil.isStatic((int)oldFlags) || !ClsUtil.isFinal((int)oldFlags)) continue;
            Cache newClassesCache = this.getNewClassesCache();
            FieldInfo newField = newClassesCache.findFieldByName(qName, field.getName());
            if (newField == null) {
                if (ConstantValue.EMPTY_CONSTANT_VALUE.equals(field.getConstantValue())) continue;
                removedConstants.add(new ChangedConstantsDependencyProcessor.FieldChangeInfo(field));
                continue;
            }
            boolean visibilityRestricted = MakeUtil.isMoreAccessible(oldFlags, newField.getFlags());
            if (field.getConstantValue().equals(newField.getConstantValue()) && !visibilityRestricted) continue;
            changedConstants.add(new ChangedConstantsDependencyProcessor.FieldChangeInfo(field, visibilityRestricted));
        }
    }

    private static void buildSubclassDependencies(Cache cache, int qName, int targetClassId) throws CacheCorruptedException {
        int[] interfaces;
        int superQName = cache.getSuperQualifiedName(targetClassId);
        if (superQName != -1) {
            cache.addSubclass(superQName, qName);
            DependencyCache.buildSubclassDependencies(cache, qName, superQName);
        }
        for (int interfaceName : interfaces = cache.getSuperInterfaces(targetClassId)) {
            cache.addSubclass(interfaceName, qName);
            DependencyCache.buildSubclassDependencies(cache, qName, interfaceName);
        }
    }

    public boolean markTargetClassInfo(Dependency dependency) throws CacheCorruptedException {
        return this.markClassInfo(dependency.getClassQualifiedName(), false);
    }

    public boolean markClass(int qualifiedName) throws CacheCorruptedException {
        return this.markClass(qualifiedName, false);
    }

    public boolean markClass(int qualifiedName, boolean force) throws CacheCorruptedException {
        return this.markClassInfo(qualifiedName, force);
    }

    public boolean isTargetClassInfoMarked(Dependency dependency) {
        return this.isClassInfoMarked(dependency.getClassQualifiedName());
    }

    public boolean isClassInfoMarked(int qName) {
        return this.myMarkedInfos.contains(qName);
    }

    public void markFile(VirtualFile file) {
        this.myMarkedFiles.add(file);
    }

    private boolean markClassInfo(int qName, boolean force) throws CacheCorruptedException {
        if (!this.getCache().containsClass(qName)) {
            return false;
        }
        if (this.myClassesWithSourceRemoved.contains(qName)) {
            return false;
        }
        if (!force && this.getNewClassesCache().containsClass(qName)) {
            return false;
        }
        return this.myMarkedInfos.add(qName);
    }

    public void resetState() {
        this.myClassesWithSourceRemoved.clear();
        this.myMarkedFiles.clear();
        this.myMarkedInfos.clear();
        this.myToUpdate.clear();
        this.myTraverseRoots.clear();
        if (this.myNewClassesCache != null) {
            this.myNewClassesCache.wipe();
            this.myNewClassesCache = null;
        }
        this.myCacheNavigator = null;
        try {
            if (this.myCache != null) {
                this.myCache.dispose();
                this.myCache = null;
            }
        }
        catch (CacheCorruptedException e) {
            LOG.info((Throwable)e);
        }
        try {
            if (this.mySymbolTable != null) {
                this.mySymbolTable.dispose();
                this.mySymbolTable = null;
            }
        }
        catch (CacheCorruptedException e) {
            LOG.info((Throwable)e);
        }
    }

    public SymbolTable getSymbolTable() throws CacheCorruptedException {
        if (this.mySymbolTable == null) {
            this.mySymbolTable = new SymbolTable(new File(this.mySymbolTableFilePath));
        }
        return this.mySymbolTable;
    }

    public String resolve(int id) throws CacheCorruptedException {
        return this.getSymbolTable().getSymbol(id);
    }

    public boolean wasRemote(int qName) {
        return this.myPreviouslyRemoteClasses.contains(qName);
    }

    private class DeclaringClassFinder
    implements ClassInfoProcessor {
        private final int myMemberName;
        private final int myMemberDescriptor;
        private int myDeclaringClass = -1;
        private final boolean myIsField;

        private DeclaringClassFinder(MemberInfo memberInfo) {
            this.myMemberName = memberInfo.getName();
            this.myMemberDescriptor = memberInfo.getDescriptor();
            this.myIsField = memberInfo instanceof FieldInfo;
        }

        public int getDeclaringClassName() {
            return this.myDeclaringClass;
        }

        @Override
        public boolean process(int classQName) throws CacheCorruptedException {
            Cache cache = DependencyCache.this.getCache();
            if (this.myIsField) {
                FieldInfo fieldId = cache.findField(classQName, this.myMemberName, this.myMemberDescriptor);
                if (fieldId != null) {
                    this.myDeclaringClass = classQName;
                    return false;
                }
            } else {
                MethodInfo methodId = cache.findMethod(classQName, this.myMemberName, this.myMemberDescriptor);
                if (methodId != null) {
                    this.myDeclaringClass = classQName;
                    return false;
                }
            }
            return true;
        }
    }
}

