/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.api;

import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class JavaIoFile
extends SimpleJavaFileObject {
    private final File myFile;

    JavaIoFile(File file, JavaFileObject.Kind kind) {
        super(file.toURI(), kind);
        this.myFile = file;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return new String(FileUtil.loadFileText((File)this.myFile));
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.myFile));
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return new BufferedOutputStream(new FileOutputStream(this.myFile));
    }

    @Override
    public String toString() {
        return this.toUri().toString();
    }

    public int hashCode() {
        return this.toUri().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaFileObject && this.toUri().equals(((JavaFileObject)obj).toUri());
    }
}

