/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.classParsing.ConstantValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class EnumConstantValue
extends ConstantValue {
    private final int myTypeName;
    private final int myConstantName;

    public EnumConstantValue(int typeName, int constantName) {
        this.myTypeName = typeName;
        this.myConstantName = constantName;
    }

    public EnumConstantValue(DataInput in) throws IOException {
        this.myTypeName = in.readInt();
        this.myConstantName = in.readInt();
    }

    public int getTypeName() {
        return this.myTypeName;
    }

    public int getConstantName() {
        return this.myConstantName;
    }

    @Override
    public void save(DataOutput out) throws IOException {
        super.save(out);
        out.writeInt(this.myTypeName);
        out.writeInt(this.myConstantName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnumConstantValue)) {
            return false;
        }
        EnumConstantValue enumConstantValue = (EnumConstantValue)o;
        if (this.myConstantName != enumConstantValue.myConstantName) {
            return false;
        }
        return this.myTypeName == enumConstantValue.myTypeName;
    }

    public int hashCode() {
        int result = this.myTypeName;
        result = 29 * result + this.myConstantName;
        return result;
    }
}

