/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.CleanModule;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompileModuleChunkTarget;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.ModuleChunkClasspath;
import com.intellij.compiler.ant.ModuleChunkSourcepath;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;

public class ChunkBuild
extends CompositeGenerator {
    public ChunkBuild(Project project, ModuleChunk chunk, GenerationOptions genOptions) {
        File chunkBaseDir = chunk.getBaseDir();
        if (genOptions.forceTargetJdk) {
            if (chunk.isJdkInherited()) {
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkHomeProperty((String)chunk.getName()), BuildProperties.propertyRef((String)"project.jdk.home")));
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkBinProperty((String)chunk.getName()), BuildProperties.propertyRef((String)"project.jdk.bin")));
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkClasspathProperty((String)chunk.getName()), BuildProperties.propertyRef((String)"project.jdk.classpath")));
            } else {
                Sdk jdk = chunk.getJdk();
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkHomeProperty((String)chunk.getName()), jdk != null ? BuildProperties.propertyRef((String)BuildProperties.getJdkHomeProperty((String)jdk.getName())) : ""));
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkBinProperty((String)chunk.getName()), jdk != null ? BuildProperties.propertyRef((String)BuildProperties.getJdkBinProperty((String)jdk.getName())) : ""));
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkClasspathProperty((String)chunk.getName()), jdk != null ? BuildProperties.getJdkPathId((String)jdk.getName()) : ""));
            }
        }
        this.add((Generator)new Property(BuildProperties.getModuleChunkCompilerArgsProperty((String)chunk.getName()), BuildProperties.propertyRef((String)"compiler.args")), 1);
        String outputPathUrl = chunk.getOutputDirUrl();
        String location = outputPathUrl != null ? GenerationUtils.toRelativePath((String)VirtualFileManager.extractPath((String)outputPathUrl), (File)chunkBaseDir, (String)BuildProperties.getModuleChunkBasedirProperty((ModuleChunk)chunk), (GenerationOptions)genOptions) : CompilerBundle.message((String)"value.undefined", (Object[])new Object[0]);
        this.add((Generator)new Property(BuildProperties.getOutputPathProperty((String)chunk.getName()), location), 1);
        String testOutputPathUrl = chunk.getTestsOutputDirUrl();
        if (testOutputPathUrl != null) {
            location = GenerationUtils.toRelativePath((String)VirtualFileManager.extractPath((String)testOutputPathUrl), (File)chunkBaseDir, (String)BuildProperties.getModuleChunkBasedirProperty((ModuleChunk)chunk), (GenerationOptions)genOptions);
        }
        this.add((Generator)new Property(BuildProperties.getOutputPathForTestsProperty((String)chunk.getName()), location));
        this.add(ChunkBuild.createBootclasspath(chunk), 1);
        this.add((Generator)new ModuleChunkClasspath(chunk, genOptions, false, false), 1);
        this.add((Generator)new ModuleChunkClasspath(chunk, genOptions, true, false), 1);
        this.add((Generator)new ModuleChunkClasspath(chunk, genOptions, false, true), 1);
        this.add((Generator)new ModuleChunkClasspath(chunk, genOptions, true, true), 1);
        ModuleChunkSourcepath moduleSources = new ModuleChunkSourcepath(project, chunk, genOptions);
        this.add((Generator)moduleSources, 1);
        this.add((Generator)new CompileModuleChunkTarget(project, chunk, moduleSources.getSourceRoots(), moduleSources.getTestSourceRoots(), chunkBaseDir, genOptions), 1);
        this.add((Generator)new CleanModule(chunk), 1);
        ChunkBuildExtension.process((CompositeGenerator)this, (ModuleChunk)chunk, (GenerationOptions)genOptions);
    }

    private static Generator createBootclasspath(ModuleChunk chunk) {
        Path bootclasspath = new Path(BuildProperties.getBootClasspathProperty((String)chunk.getName()));
        bootclasspath.add((Generator)new Comment(CompilerBundle.message((String)"generated.ant.build.bootclasspath.comment", (Object[])new Object[0])));
        return bootclasspath;
    }
}

