/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.visibility;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionTool;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.visibility.VisibilityExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibilityInspection
extends GlobalJavaInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.visibility.VisibilityInspection");
    public boolean SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS = true;
    public boolean SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES = true;
    public boolean SUGGEST_PRIVATE_FOR_INNERS = false;
    private static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.visibility.display.name", (Object[])new Object[0]);
    @NonNls
    private static final String SHORT_NAME = "WeakerAccess";

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/visibility/VisibilityInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/visibility/VisibilityInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/visibility/VisibilityInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext, ProblemDescriptionsProcessor processor) {
        if (refEntity instanceof RefJavaElement) {
            PsiElement psiElement;
            RefClass refClass;
            RefJavaElement refElement = (RefJavaElement)refEntity;
            if (refElement instanceof RefParameter) {
                return null;
            }
            if (refElement.isSyntheticJSP()) {
                return null;
            }
            if (refElement.isEntry()) {
                return null;
            }
            if (refElement instanceof RefImplicitConstructor) {
                return null;
            }
            if (refElement instanceof RefField && ((RefField)refElement).getElement() instanceof PsiEnumConstant) {
                return null;
            }
            if (refElement instanceof RefMethod) {
                RefMethod refMethod = (RefMethod)refElement;
                if (refMethod.isExternalOverride()) {
                    return null;
                }
                if (RefUtil.isEntryPoint((RefElement)refMethod)) {
                    return null;
                }
            }
            if (refElement instanceof RefClass) {
                refClass = (RefClass)refElement;
                if (refClass.isAnonymous() || RefUtil.isEntryPoint((RefElement)refClass) || refClass.isTestCase() || refClass.isServlet() || refClass.isApplet() || refClass.isLocalClass()) {
                    return null;
                }
                if (VisibilityInspection.isTopLevelClass((RefElement)refClass) && !this.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES) {
                    return null;
                }
            }
            if (refElement.getInReferences().isEmpty()) {
                return null;
            }
            if (refElement.getOwner() instanceof RefClass && (refClass = (RefClass)refElement.getOwner()).isInterface()) {
                return null;
            }
            String access = this.getPossibleAccess(refElement);
            if (access != refElement.getAccessModifier() && (psiElement = HighlightUsagesHandler.getNameIdentifier(refElement.getElement())) != null) {
                return new ProblemDescriptor[]{manager.createProblemDescriptor(psiElement, InspectionsBundle.message((String)"inspection.visibility.compose.suggestion", (Object[])new Object[]{VisibilityUtil.toPresentableText((String)access)}), (LocalQuickFix)new AcceptSuggestedAccess(globalContext.getRefManager(), access), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
            }
        }
        return null;
    }

    @Nullable
    @Modifier
    public String getPossibleAccess(@Nullable RefJavaElement refElement) {
        String weakerAccess;
        if (refElement == null) {
            return null;
        }
        String curAccess = refElement.getAccessModifier();
        String weakestAccess = "private";
        if (VisibilityInspection.isTopLevelClass((RefElement)refElement) || VisibilityInspection.isCalledOnSubClasses((RefElement)refElement)) {
            weakestAccess = "packageLocal";
        }
        if (VisibilityInspection.isAbstractMethod((RefElement)refElement)) {
            weakestAccess = "protected";
        }
        if (curAccess == weakestAccess) {
            return curAccess;
        }
        while ((weakerAccess = this.getWeakerAccess(curAccess, (RefElement)refElement)) != null && RefJavaUtil.getInstance().compareAccess(weakerAccess, weakestAccess) >= 0 && this.isAccessible(refElement, weakerAccess)) {
            curAccess = weakerAccess;
        }
        return curAccess;
    }

    private static boolean isCalledOnSubClasses(RefElement refElement) {
        return refElement instanceof RefMethod && ((RefMethod)refElement).isCalledOnSubClass();
    }

    private static boolean isAbstractMethod(RefElement refElement) {
        return refElement instanceof RefMethod && ((RefMethod)refElement).isAbstract();
    }

    private static boolean isTopLevelClass(RefElement refElement) {
        return refElement instanceof RefClass && RefJavaUtil.getInstance().getTopLevelClass(refElement) == refElement;
    }

    @Nullable
    @Modifier
    private String getWeakerAccess(String curAccess, RefElement refElement) {
        if (curAccess == "public") {
            return VisibilityInspection.isTopLevelClass(refElement) ? "packageLocal" : "protected";
        }
        if (curAccess == "protected") {
            return this.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS ? "packageLocal" : "private";
        }
        if (curAccess == "packageLocal") {
            return "private";
        }
        return null;
    }

    private boolean isAccessible(RefJavaElement to, String accessModifier) {
        for (RefElement refElement : to.getInReferences()) {
            if (this.isAccessibleFrom(refElement, to, accessModifier)) continue;
            return false;
        }
        if (to instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)to;
            if (refMethod.isAbstract() && (refMethod.getDerivedMethods().size() == 0 || refMethod.getAccessModifier() == "private")) {
                return false;
            }
            for (RefMethod refOverride : refMethod.getDerivedMethods()) {
                if (this.isAccessibleFrom((RefElement)refOverride, to, accessModifier)) continue;
                return false;
            }
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                if (RefJavaUtil.getInstance().compareAccess(refSuper.getAccessModifier(), accessModifier) <= 0) continue;
                return false;
            }
        }
        if (to instanceof RefClass) {
            RefClass refClass = (RefClass)to;
            for (RefClass subClass : refClass.getSubClasses()) {
                if (this.isAccessibleFrom((RefElement)subClass, to, accessModifier)) continue;
                return false;
            }
            List children = refClass.getChildren();
            if (children != null) {
                for (Object refElement : children) {
                    if (this.isAccessible((RefJavaElement)refElement, accessModifier)) continue;
                    return false;
                }
            }
            for (Object refElement : refClass.getInTypeReferences()) {
                if (this.isAccessibleFrom((RefElement)refElement, (RefJavaElement)refClass, accessModifier)) continue;
                return false;
            }
            List<RefJavaElement> classExporters = ((RefClassImpl)refClass).getClassExporters();
            if (classExporters != null) {
                for (RefJavaElement refExporter : classExporters) {
                    if (VisibilityInspection.getAccessLevel(accessModifier) >= VisibilityInspection.getAccessLevel(refExporter.getAccessModifier())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static int getAccessLevel(String access) {
        if (access == "private") {
            return 1;
        }
        if (access == "packageLocal") {
            return 2;
        }
        if (access == "protected") {
            return 3;
        }
        return 4;
    }

    private boolean isAccessibleFrom(RefElement from, RefJavaElement to, String accessModifier) {
        if (accessModifier == "public") {
            return true;
        }
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        if (accessModifier == "packageLocal") {
            return RefJavaUtil.getPackage((RefEntity)from) == RefJavaUtil.getPackage((RefEntity)to);
        }
        RefClass fromTopLevel = refUtil.getTopLevelClass(from);
        RefClass toTopLevel = refUtil.getTopLevelClass((RefElement)to);
        RefClass fromOwner = refUtil.getOwnerClass(from);
        RefClass toOwner = refUtil.getOwnerClass((RefElement)to);
        if (accessModifier == "protected") {
            if (this.SUGGEST_PRIVATE_FOR_INNERS) {
                return refUtil.isInheritor(fromTopLevel, toOwner) || fromOwner != null && refUtil.isInheritor(fromOwner, toTopLevel) || toOwner != null && refUtil.getOwnerClass((RefElement)toOwner) == from;
            }
            return refUtil.isInheritor(fromTopLevel, toOwner);
        }
        if (accessModifier == "private") {
            if (this.SUGGEST_PRIVATE_FOR_INNERS) {
                return fromTopLevel == toOwner || fromOwner == toTopLevel || toOwner != null && refUtil.getOwnerClass((RefElement)toOwner) == from;
            }
            if (fromOwner != null && fromOwner.isStatic() && !to.isStatic() && refUtil.isInheritor(fromOwner, toOwner)) {
                return false;
            }
            if (fromTopLevel == toOwner) {
                if (from instanceof RefClass && to instanceof RefClass) {
                    PsiClass fromClass = ((RefClass)from).getElement();
                    LOG.assertTrue(fromClass != null);
                    if (VisibilityInspection.isInExtendsList(to, fromClass.getExtendsList())) {
                        return false;
                    }
                    if (VisibilityInspection.isInExtendsList(to, fromClass.getImplementsList())) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isInExtendsList(RefJavaElement to, PsiReferenceList extendsList) {
        if (extendsList != null) {
            PsiJavaCodeReferenceElement[] referenceElements;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                if (parameterList == null) continue;
                for (PsiType type : parameterList.getTypeArguments()) {
                    if (!extendsList.getManager().areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)type), to.getElement())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean queryExternalUsagesRequests(final RefManager manager, final GlobalJavaInspectionContext globalContext, final ProblemDescriptionsProcessor processor) {
        final EntryPointsManager entryPointsManager = globalContext.getEntryPointsManager(manager);
        for (RefElement entryPoint : entryPointsManager.getEntryPoints()) {
            VisibilityInspection.ignoreElement(processor, (RefEntity)entryPoint);
        }
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.visibility");
        for (VisibilityExtension addin : (VisibilityExtension[])point.getExtensions()) {
            addin.fillIgnoreList(manager, processor);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(RefEntity refEntity) {
                if (!(refEntity instanceof RefElement)) {
                    return;
                }
                if (processor.getDescriptions(refEntity) == null) {
                    return;
                }
                refEntity.accept((RefVisitor)new RefJavaVisitor(){

                    public void visitField(final RefField refField) {
                        if (refField.getAccessModifier() != "private") {
                            globalContext.enqueueFieldUsagesProcessor(refField, new GlobalJavaInspectionContext.UsagesProcessor(){

                                public boolean process(PsiReference psiReference) {
                                    VisibilityInspection.ignoreElement(processor, (RefEntity)refField);
                                    return false;
                                }
                            });
                        }
                    }

                    public void visitMethod(final RefMethod refMethod) {
                        if (!refMethod.isExternalOverride() && refMethod.getAccessModifier() != "private" && !(refMethod instanceof RefImplicitConstructor)) {
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, new GlobalJavaInspectionContext.DerivedMethodsProcessor(){

                                public boolean process(PsiMethod derivedMethod) {
                                    VisibilityInspection.ignoreElement(processor, (RefEntity)refMethod);
                                    return false;
                                }
                            });
                            globalContext.enqueueMethodUsagesProcessor(refMethod, new GlobalJavaInspectionContext.UsagesProcessor(){

                                public boolean process(PsiReference psiReference) {
                                    VisibilityInspection.ignoreElement(processor, (RefEntity)refMethod);
                                    return false;
                                }
                            });
                            if (entryPointsManager.isAddNonJavaEntries()) {
                                String qualifiedName;
                                RefClass ownerClass = refMethod.getOwnerClass();
                                if (refMethod.isConstructor() && ownerClass.getDefaultConstructor() != null && (qualifiedName = ownerClass.getElement().getQualifiedName()) != null) {
                                    Project project = manager.getProject();
                                    PsiManager.getInstance((Project)project).getSearchHelper().processUsagesInNonJavaFiles(qualifiedName, new PsiNonJavaFileReferenceProcessor(){

                                        public boolean process(PsiFile file, int startOffset, int endOffset) {
                                            entryPointsManager.addEntryPoint((RefElement)refMethod, false);
                                            VisibilityInspection.ignoreElement(processor, (RefEntity)refMethod);
                                            return false;
                                        }
                                    }, GlobalSearchScope.projectScope((Project)project));
                                }
                            }
                        }
                    }

                    public void visitClass(final RefClass refClass) {
                        if (!refClass.isAnonymous()) {
                            globalContext.enqueueDerivedClassesProcessor(refClass, new GlobalJavaInspectionContext.DerivedClassesProcessor(){

                                public boolean process(PsiClass inheritor) {
                                    VisibilityInspection.ignoreElement(processor, (RefEntity)refClass);
                                    return false;
                                }
                            });
                            globalContext.enqueueClassUsagesProcessor(refClass, new GlobalJavaInspectionContext.UsagesProcessor(){

                                public boolean process(PsiReference psiReference) {
                                    VisibilityInspection.ignoreElement(processor, (RefEntity)refClass);
                                    return false;
                                }
                            });
                        }
                    }
                });
            }
        });
        return false;
    }

    private static void ignoreElement(ProblemDescriptionsProcessor processor, RefEntity refElement) {
        RefClass refClass;
        processor.ignoreElement(refElement);
        if (refElement instanceof RefClass && (refClass = (RefClass)refElement).getDefaultConstructor() != null) {
            processor.ignoreElement((RefEntity)refClass.getDefaultConstructor());
            return;
        }
        if (refElement.getOwner() instanceof RefElement) {
            processor.ignoreElement(refElement.getOwner());
        }
    }

    public void compose(StringBuffer buf, RefEntity refEntity, HTMLComposer composer) {
        composer.appendElementInReferences(buf, (RefElement)refEntity);
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new AcceptSuggestedAccess(null, hint);
    }

    @Nullable
    public String getHint(QuickFix fix) {
        return ((AcceptSuggestedAccess)fix).getHint();
    }

    private static class AcceptSuggestedAccess
    implements LocalQuickFix {
        private final RefManager myManager;
        @Modifier
        private final String myHint;

        private AcceptSuggestedAccess(RefManager manager, @Modifier String hint) {
            this.myManager = manager;
            this.myHint = hint;
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.visibility.accept.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess.applyFix must not be null");
            }
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{PsiUtilBase.getVirtualFile((PsiElement)descriptor.getPsiElement())}).hasReadonlyFiles()) {
                return;
            }
            PsiModifierListOwner element = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiModifierListOwner.class);
            if (element != null) {
                RefElement refElement = null;
                if (this.myManager != null) {
                    refElement = this.myManager.getReference((PsiElement)element);
                }
                try {
                    PsiMethod psiMethod;
                    PsiClass containingClass;
                    if (element instanceof PsiVariable) {
                        ((PsiVariable)element).normalizeDeclaration();
                    }
                    PsiModifierList list = element.getModifierList();
                    LOG.assertTrue(list != null);
                    if (element instanceof PsiMethod && (containingClass = (psiMethod = (PsiMethod)element).getContainingClass()) != null && containingClass.getParent() instanceof PsiFile && this.myHint == "private" && list.hasModifierProperty("final")) {
                        list.setModifierProperty("final", false);
                    }
                    list.setModifierProperty(this.myHint, true);
                    if (refElement instanceof RefJavaElement) {
                        RefJavaUtil.getInstance().setAccessModifier((RefJavaElement)refElement, this.myHint);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        public String getHint() {
            return this.myHint;
        }
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myPackageLocalForMembersCheckbox;
        private final JCheckBox myPrivateForInnersCheckbox;
        private final JCheckBox myPackageLocalForTopClassesCheckbox;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.anchor = 18;
            this.myPackageLocalForMembersCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.visibility.option", (Object[])new Object[0]));
            this.myPackageLocalForMembersCheckbox.setSelected(VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS);
            this.myPackageLocalForMembersCheckbox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS = OptionsPanel.this.myPackageLocalForMembersCheckbox.isSelected();
                }
            });
            gc.gridy = 0;
            this.add((Component)this.myPackageLocalForMembersCheckbox, gc);
            this.myPackageLocalForTopClassesCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.visibility.option1", (Object[])new Object[0]));
            this.myPackageLocalForTopClassesCheckbox.setSelected(VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES);
            this.myPackageLocalForTopClassesCheckbox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES = OptionsPanel.this.myPackageLocalForTopClassesCheckbox.isSelected();
                }
            });
            gc.gridy = 1;
            this.add((Component)this.myPackageLocalForTopClassesCheckbox, gc);
            this.myPrivateForInnersCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.visibility.option2", (Object[])new Object[0]));
            this.myPrivateForInnersCheckbox.setSelected(VisibilityInspection.this.SUGGEST_PRIVATE_FOR_INNERS);
            this.myPrivateForInnersCheckbox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    VisibilityInspection.this.SUGGEST_PRIVATE_FOR_INNERS = OptionsPanel.this.myPrivateForInnersCheckbox.isSelected();
                }
            });
            gc.gridy = 2;
            gc.weighty = 1.0;
            this.add((Component)this.myPrivateForInnersCheckbox, gc);
        }
    }
}

