/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;

public class DfaVariableValue
extends DfaValue {
    private PsiVariable myVariable;
    private boolean myIsNegated;

    private DfaVariableValue(PsiVariable variable, boolean isNegated, DfaValueFactory factory) {
        super(factory);
        this.myVariable = variable;
        this.myIsNegated = isNegated;
    }

    private DfaVariableValue(DfaValueFactory factory) {
        super(factory);
        this.myVariable = null;
        this.myIsNegated = false;
    }

    public PsiVariable getPsiVariable() {
        return this.myVariable;
    }

    public boolean isNegated() {
        return this.myIsNegated;
    }

    @Override
    public DfaValue createNegated() {
        return this.myFactory.getVarFactory().create(this.getPsiVariable(), !this.myIsNegated);
    }

    public String toString() {
        if (this.myVariable == null) {
            return "$currentException";
        }
        return (this.myIsNegated ? "!" : "") + this.myVariable.getName();
    }

    private boolean hardEquals(DfaVariableValue aVar) {
        return aVar.myVariable == this.myVariable && aVar.myIsNegated == this.myIsNegated;
    }

    public static class Factory {
        private final DfaVariableValue mySharedInstance;
        private final HashMap<String, ArrayList<DfaVariableValue>> myStringToObject;
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.mySharedInstance = new DfaVariableValue(factory);
            this.myStringToObject = new HashMap();
        }

        public DfaVariableValue create(PsiVariable myVariable, boolean isNegated) {
            this.mySharedInstance.myVariable = myVariable;
            this.mySharedInstance.myIsNegated = isNegated;
            String id = this.mySharedInstance.toString();
            ArrayList<DfaVariableValue> conditions = (ArrayList<DfaVariableValue>)this.myStringToObject.get((Object)id);
            if (conditions == null) {
                conditions = new ArrayList<DfaVariableValue>();
                this.myStringToObject.put((Object)id, conditions);
            } else {
                for (DfaVariableValue aVar : conditions) {
                    if (!aVar.hardEquals(this.mySharedInstance)) continue;
                    return aVar;
                }
            }
            DfaVariableValue result = new DfaVariableValue(myVariable, isNegated, this.myFactory);
            conditions.add(result);
            return result;
        }
    }
}

