/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.AnnotationsAwareDataFlowRunner;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReturnStatement;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StandardDataFlowRunner
extends AnnotationsAwareDataFlowRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.DataFlowRunner");
    private final HashSet<Instruction> myNPEInstructions = new HashSet();
    private final HashSet<Instruction> myCCEInstructions = new HashSet();
    private final HashSet<PsiExpression> myNullableArguments = new HashSet();
    private final HashSet<PsiExpression> myNullableAssignments = new HashSet();
    private final HashSet<PsiReturnStatement> myNullableReturns = new HashSet();
    private final boolean mySuggestNullableAnnotations;
    private boolean myInNullableMethod = false;
    private boolean myInNotNullMethod = false;
    private boolean myIsInMethod = false;
    private final Set<PsiExpression> myUnboxedNullables = new THashSet();

    public StandardDataFlowRunner(boolean suggestNullableAnnotations) {
        this.mySuggestNullableAnnotations = suggestNullableAnnotations;
    }

    @Override
    protected Collection<DfaMemoryState> createInitialStates(@NotNull PsiElement psiBlock, InstructionVisitor visitor) {
        if (psiBlock == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/StandardDataFlowRunner.createInitialStates must not be null");
        }
        Collection<DfaMemoryState> initialStates = super.createInitialStates(psiBlock, visitor);
        this.myIsInMethod = psiBlock.getParent() instanceof PsiMethod;
        if (this.myIsInMethod) {
            PsiMethod method = (PsiMethod)psiBlock.getParent();
            this.myInNullableMethod = AnnotationUtil.isNullable((PsiModifierListOwner)method);
            this.myInNotNullMethod = AnnotationUtil.isNotNull((PsiModifierListOwner)method);
        }
        this.myNPEInstructions.clear();
        this.myCCEInstructions.clear();
        this.myNullableArguments.clear();
        this.myNullableAssignments.clear();
        this.myNullableReturns.clear();
        this.myUnboxedNullables.clear();
        return initialStates;
    }

    public void onInstructionProducesNPE(Instruction instruction) {
        this.myNPEInstructions.add(instruction);
    }

    public void onInstructionProducesCCE(Instruction instruction) {
        this.myCCEInstructions.add(instruction);
    }

    @NotNull
    public Set<Instruction> getCCEInstructions() {
        HashSet<Instruction> hashSet = this.myCCEInstructions;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/StandardDataFlowRunner.getCCEInstructions must not return null");
        }
        return hashSet;
    }

    @NotNull
    public Set<Instruction> getNPEInstructions() {
        HashSet<Instruction> hashSet = this.myNPEInstructions;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/StandardDataFlowRunner.getNPEInstructions must not return null");
        }
        return hashSet;
    }

    @NotNull
    public Set<PsiReturnStatement> getNullableReturns() {
        HashSet<PsiReturnStatement> hashSet = this.myNullableReturns;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/StandardDataFlowRunner.getNullableReturns must not return null");
        }
        return hashSet;
    }

    public boolean isInNotNullMethod() {
        return this.myInNotNullMethod;
    }

    @NotNull
    public Set<PsiExpression> getNullableArguments() {
        HashSet<PsiExpression> hashSet = this.myNullableArguments;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/StandardDataFlowRunner.getNullableArguments must not return null");
        }
        return hashSet;
    }

    @NotNull
    public Set<PsiExpression> getNullableAssignments() {
        HashSet<PsiExpression> hashSet = this.myNullableAssignments;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/StandardDataFlowRunner.getNullableAssignments must not return null");
        }
        return hashSet;
    }

    @NotNull
    public Set<PsiExpression> getUnboxedNullables() {
        Set<PsiExpression> set = this.myUnboxedNullables;
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/StandardDataFlowRunner.getUnboxedNullables must not return null");
        }
        return set;
    }

    public void onUnboxingNullable(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/StandardDataFlowRunner.onUnboxingNullable must not be null");
        }
        LOG.assertTrue(expression.isValid());
        if (expression.isPhysical()) {
            this.myUnboxedNullables.add(expression);
        }
    }

    public void onPassingNullParameter(PsiExpression expr) {
        this.myNullableArguments.add(expr);
    }

    public void onAssigningToNotNullableVariable(PsiExpression expr) {
        this.myNullableAssignments.add(expr);
    }

    public void onNullableReturn(PsiReturnStatement statement) {
        if (this.myInNullableMethod || !this.myIsInMethod) {
            return;
        }
        if (this.myInNotNullMethod || this.mySuggestNullableAnnotations) {
            this.myNullableReturns.add(statement);
        }
    }

    public boolean problemsDetected(StandardInstructionVisitor visitor) {
        Pair<Set<Instruction>, Set<Instruction>> constConditions = this.getConstConditionalExpressions();
        return !((Set)constConditions.getFirst()).isEmpty() || !((Set)constConditions.getSecond()).isEmpty() || !this.myNPEInstructions.isEmpty() || !this.myCCEInstructions.isEmpty() || !StandardDataFlowRunner.getRedundantInstanceofs(this, visitor).isEmpty() || !this.myNullableArguments.isEmpty() || !this.myNullableAssignments.isEmpty() || !this.myNullableReturns.isEmpty() || !this.myUnboxedNullables.isEmpty();
    }

    @NotNull
    public static Set<Instruction> getRedundantInstanceofs(DataFlowRunner runner, StandardInstructionVisitor visitor) {
        HashSet<Instruction> result = new HashSet<Instruction>(1);
        for (Instruction instruction : runner.getInstructions()) {
            if (!(instruction instanceof InstanceofInstruction) || !visitor.isInstanceofRedundant((InstanceofInstruction)instruction)) continue;
            result.add(instruction);
        }
        HashSet<Instruction> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/StandardDataFlowRunner.getRedundantInstanceofs must not return null");
        }
        return hashSet;
    }
}

