/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInspection.AddAssertStatementFix;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SurroundWithIfFix;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowInspection
extends BaseLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.DataFlowInspection");
    @NonNls
    private static final String SHORT_NAME = "ConstantConditions";
    public boolean SUGGEST_NULLABLE_ANNOTATIONS = false;
    public boolean DONT_REPORT_TRUE_ASSERT_STATEMENTS = false;

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DataFlowInspection.buildVisitor must not be null");
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitField(PsiField field) {
                if (DataFlowInspection.isNullLiteralExpression(field.getInitializer()) && AnnotationUtil.isNotNull((PsiModifierListOwner)field)) {
                    holder.registerProblem((PsiElement)field.getInitializer(), InspectionsBundle.message((String)"dataflow.message.initializing.field.with.null", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitMethod(PsiMethod method) {
                DataFlowInspection.this.analyzeCodeBlock(method.getBody(), holder);
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
                DataFlowInspection.this.analyzeCodeBlock(initializer.getBody(), holder);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DataFlowInspection.buildVisitor must not return null");
        }
        return javaElementVisitor;
    }

    private void analyzeCodeBlock(PsiCodeBlock body, ProblemsHolder holder) {
        PsiMethod method;
        PsiIdentifier name;
        if (body == null) {
            return;
        }
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(this.SUGGEST_NULLABLE_ANNOTATIONS);
        DataFlowInstructionVisitor visitor = new DataFlowInstructionVisitor();
        RunnerResult rc = dfaRunner.analyzeMethod((PsiElement)body, visitor);
        if (rc == RunnerResult.OK) {
            if (dfaRunner.problemsDetected(visitor)) {
                this.createDescription(dfaRunner, holder, visitor);
            }
        } else if (rc == RunnerResult.TOO_COMPLEX && body.getParent() instanceof PsiMethod && (name = (method = (PsiMethod)body.getParent()).getNameIdentifier()) != null) {
            holder.registerProblem((PsiElement)name, InspectionsBundle.message((String)"dataflow.too.complex", (Object[])new Object[0]), ProblemHighlightType.INFO, new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static LocalQuickFix[] createNPEFixes(PsiExpression qualifier) {
        if (!(qualifier == null || qualifier instanceof PsiMethodCallExpression || qualifier instanceof PsiLiteralExpression && ((PsiLiteralExpression)qualifier).getValue() == null)) {
            try {
                SurroundWithIfFix ifFix;
                PsiBinaryExpression binary = (PsiBinaryExpression)JavaPsiFacade.getInstance((Project)qualifier.getProject()).getElementFactory().createExpressionFromText("a != null", null);
                binary.getLOperand().replace((PsiElement)qualifier);
                SmartList fixes = new SmartList();
                if (PsiUtil.getLanguageLevel((PsiElement)qualifier).hasAssertKeyword()) {
                    fixes.add(new AddAssertStatementFix((PsiExpression)binary));
                }
                if ((ifFix = new SurroundWithIfFix(qualifier)).isAvailable()) {
                    fixes.add(ifFix);
                }
                return fixes.toArray(new LocalQuickFix[fixes.size()]);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return null;
    }

    private void createDescription(StandardDataFlowRunner runner, ProblemsHolder holder, StandardInstructionVisitor visitor) {
        Pair<Set<Instruction>, Set<Instruction>> constConditions = runner.getConstConditionalExpressions();
        Set trueSet = (Set)constConditions.getFirst();
        Set falseSet = (Set)constConditions.getSecond();
        Set<Instruction> npeSet = runner.getNPEInstructions();
        Set<Instruction> cceSet = runner.getCCEInstructions();
        Set<Instruction> redundantInstanceofs = StandardDataFlowRunner.getRedundantInstanceofs(runner, visitor);
        ArrayList<Instruction> allProblems = new ArrayList<Instruction>();
        allProblems.addAll(trueSet);
        allProblems.addAll(falseSet);
        allProblems.addAll(npeSet);
        allProblems.addAll(cceSet);
        allProblems.addAll(redundantInstanceofs);
        Collections.sort(allProblems, new Comparator<Instruction>(){

            @Override
            public int compare(Instruction i1, Instruction i2) {
                return i1.getIndex() - i2.getIndex();
            }
        });
        HashSet<PsiElement> reportedAnchors = new HashSet<PsiElement>();
        for (Instruction instruction : allProblems) {
            if (instruction instanceof MethodCallInstruction) {
                MethodCallInstruction mcInstruction = (MethodCallInstruction)instruction;
                if (!(mcInstruction.getCallExpression() instanceof PsiMethodCallExpression)) continue;
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)mcInstruction.getCallExpression();
                LocalQuickFix[] fix = DataFlowInspection.createNPEFixes(callExpression.getMethodExpression().getQualifierExpression());
                holder.registerProblem((PsiElement)callExpression, InspectionsBundle.message((String)"dataflow.message.npe.method.invocation", (Object[])new Object[0]), fix);
                continue;
            }
            if (instruction instanceof FieldReferenceInstruction) {
                LocalQuickFix[] fix;
                FieldReferenceInstruction frInstruction = (FieldReferenceInstruction)instruction;
                PsiExpression elementToAssert = frInstruction.getElementToAssert();
                PsiExpression expression = frInstruction.getExpression();
                if (expression instanceof PsiArrayAccessExpression) {
                    fix = DataFlowInspection.createNPEFixes(elementToAssert);
                    holder.registerProblem((PsiElement)expression, InspectionsBundle.message((String)"dataflow.message.npe.array.access", (Object[])new Object[0]), fix);
                    continue;
                }
                fix = DataFlowInspection.createNPEFixes(elementToAssert);
                holder.registerProblem((PsiElement)elementToAssert, InspectionsBundle.message((String)"dataflow.message.npe.field.access", (Object[])new Object[0]), fix);
                continue;
            }
            if (instruction instanceof TypeCastInstruction) {
                TypeCastInstruction tcInstruction = (TypeCastInstruction)instruction;
                PsiTypeCastExpression typeCast = tcInstruction.getCastExpression();
                holder.registerProblem((PsiElement)typeCast.getCastType(), InspectionsBundle.message((String)"dataflow.message.cce", (Object[])new Object[]{typeCast.getOperand().getText()}), new LocalQuickFix[0]);
                continue;
            }
            if (!(instruction instanceof BranchingInstruction)) continue;
            PsiElement psiAnchor = ((BranchingInstruction)instruction).getPsiAnchor();
            if (instruction instanceof InstanceofInstruction && visitor.isInstanceofRedundant((InstanceofInstruction)instruction)) {
                LocalQuickFix[] localQuickFixArray;
                if (visitor.canBeNull((BinopInstruction)instruction)) {
                    holder.registerProblem(psiAnchor, InspectionsBundle.message((String)"dataflow.message.redundant.instanceof", (Object[])new Object[0]), new LocalQuickFix[]{new RedundantInstanceofFix()});
                    continue;
                }
                LocalQuickFix localQuickFix = DataFlowInspection.createSimplifyBooleanExpressionFix(psiAnchor, true);
                String string = InspectionsBundle.message((String)"dataflow.message.constant.condition", (Object[])new Object[]{Boolean.toString(true)});
                if (localQuickFix == null) {
                    localQuickFixArray = null;
                } else {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = localQuickFix;
                }
                holder.registerProblem(psiAnchor, string, localQuickFixArray);
                continue;
            }
            if (psiAnchor instanceof PsiSwitchLabelStatement) {
                if (!falseSet.contains(instruction)) continue;
                holder.registerProblem(psiAnchor, InspectionsBundle.message((String)"dataflow.message.unreachable.switch.label", (Object[])new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            if (psiAnchor == null || reportedAnchors.contains(psiAnchor) || DataFlowInspection.isCompileConstantInIfCondition(psiAnchor)) continue;
            boolean evaluatesToTrue = trueSet.contains(instruction);
            if (DataFlowInspection.onTheLeftSideOfConditionalAssignemnt(psiAnchor)) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message((String)"dataflow.message.pointless.assignment.expression", (Object[])new Object[]{Boolean.toString(evaluatesToTrue)}), new LocalQuickFix[0]);
            } else {
                boolean report;
                boolean bl = report = !(psiAnchor.getParent() instanceof PsiAssertStatement) || !this.DONT_REPORT_TRUE_ASSERT_STATEMENTS || !evaluatesToTrue;
                if (report) {
                    LocalQuickFix[] localQuickFixArray;
                    LocalQuickFix localQuickFix = DataFlowInspection.createSimplifyBooleanExpressionFix(psiAnchor, evaluatesToTrue);
                    String string = InspectionsBundle.message((String)"dataflow.message.constant.condition", (Object[])new Object[]{Boolean.toString(evaluatesToTrue)});
                    if (localQuickFix == null) {
                        localQuickFixArray = null;
                    } else {
                        LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray3;
                        localQuickFixArray3[0] = localQuickFix;
                    }
                    holder.registerProblem(psiAnchor, string, localQuickFixArray);
                }
            }
            reportedAnchors.add(psiAnchor);
        }
        Set<PsiExpression> exprs = runner.getNullableArguments();
        for (PsiExpression expr : exprs) {
            String text = DataFlowInspection.isNullLiteralExpression(expr) ? InspectionsBundle.message((String)"dataflow.message.passing.null.argument", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.passing.nullable.argument", (Object[])new Object[0]);
            LocalQuickFix[] fixes = DataFlowInspection.createNPEFixes(expr);
            holder.registerProblem((PsiElement)expr, text, fixes);
        }
        exprs = runner.getNullableAssignments();
        for (PsiExpression expr : exprs) {
            String text = DataFlowInspection.isNullLiteralExpression(expr) ? InspectionsBundle.message((String)"dataflow.message.assigning.null", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.assigning.nullable", (Object[])new Object[0]);
            holder.registerProblem((PsiElement)expr, text, new LocalQuickFix[0]);
        }
        exprs = runner.getUnboxedNullables();
        for (PsiExpression expr : exprs) {
            holder.registerProblem((PsiElement)expr, InspectionsBundle.message((String)"dataflow.message.unboxing", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
        Set<PsiReturnStatement> statements = runner.getNullableReturns();
        for (PsiReturnStatement statement : statements) {
            String text;
            PsiExpression expr = statement.getReturnValue();
            if (runner.isInNotNullMethod()) {
                text = DataFlowInspection.isNullLiteralExpression(expr) ? InspectionsBundle.message((String)"dataflow.message.return.null.from.notnull", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.return.nullable.from.notnull", (Object[])new Object[0]);
                holder.registerProblem((PsiElement)expr, text, new LocalQuickFix[0]);
                continue;
            }
            if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)statement)) continue;
            text = DataFlowInspection.isNullLiteralExpression(expr) ? InspectionsBundle.message((String)"dataflow.message.return.null.from.notnullable", (Object[])new Object[0]) : InspectionsBundle.message((String)"dataflow.message.return.nullable.from.notnullable", (Object[])new Object[0]);
            holder.registerProblem((PsiElement)expr, text, new LocalQuickFix[]{new AnnotateMethodFix("org.jetbrains.annotations.Nullable", "org.jetbrains.annotations.NotNull")});
        }
    }

    private static boolean isCompileConstantInIfCondition(PsiElement element) {
        if (!(element instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement resolved = ((PsiReferenceExpression)element).resolve();
        if (!(resolved instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)resolved;
        if (!field.hasModifierProperty("final")) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiPrefixExpression && ((PsiPrefixExpression)parent).getOperationSign().getTokenType() == JavaTokenType.EXCL) {
            element = parent;
            parent = parent.getParent();
        }
        return parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getCondition() == element;
    }

    private static boolean isNullLiteralExpression(PsiExpression expr) {
        if (expr instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expr;
            return PsiType.NULL.equals(literalExpression.getType());
        }
        return false;
    }

    private static boolean onTheLeftSideOfConditionalAssignemnt(PsiElement psiAnchor) {
        PsiAssignmentExpression expression;
        PsiElement parent = psiAnchor.getParent();
        return parent instanceof PsiAssignmentExpression && (expression = (PsiAssignmentExpression)parent).getLExpression() == psiAnchor;
    }

    @Nullable
    private static LocalQuickFix createSimplifyBooleanExpressionFix(PsiElement element, boolean value) {
        if (!(element instanceof PsiExpression)) {
            return null;
        }
        PsiExpression expression = (PsiExpression)element;
        while (element.getParent() instanceof PsiExpression) {
            element = element.getParent();
        }
        final SimplifyBooleanExpressionFix fix = new SimplifyBooleanExpressionFix(expression, value);
        if (!fix.isAvailable(element.getProject(), null, element.getContainingFile()) || SimplifyBooleanExpressionFix.canBeSimplified((PsiExpression)element)) {
            return null;
        }
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = fix.getText();
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DataFlowInspection$3.getName must not return null");
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DataFlowInspection$3.applyFix must not be null");
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DataFlowInspection$3.applyFix must not be null");
                }
                PsiElement psiElement = descriptor.getPsiElement();
                try {
                    LOG.assertTrue(psiElement.isValid());
                    fix.invoke(project, null, psiElement.getContainingFile());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            @NotNull
            public String getFamilyName() {
                String string = InspectionsBundle.message((String)"inspection.data.flow.simplify.boolean.expression.quickfix", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DataFlowInspection$3.getFamilyName must not return null");
                }
                return string;
            }
        };
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.data.flow.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DataFlowInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DataFlowInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DataFlowInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    private static class DataFlowInstructionVisitor
    extends StandardInstructionVisitor {
        private DataFlowInstructionVisitor() {
        }

        @Override
        protected void onAssigningToNotNullableVariable(AssignInstruction instruction, DataFlowRunner runner) {
            ((StandardDataFlowRunner)runner).onAssigningToNotNullableVariable(instruction.getRExpression());
        }

        @Override
        protected void onNullableReturn(CheckReturnValueInstruction instruction, DataFlowRunner runner) {
            ((StandardDataFlowRunner)runner).onNullableReturn(instruction.getReturn());
        }

        @Override
        protected void onInstructionProducesNPE(FieldReferenceInstruction instruction, DataFlowRunner runner) {
            ((StandardDataFlowRunner)runner).onInstructionProducesNPE(instruction);
        }

        @Override
        protected void onInstructionProducesCCE(TypeCastInstruction instruction, DataFlowRunner runner) {
            ((StandardDataFlowRunner)runner).onInstructionProducesCCE(instruction);
        }

        @Override
        protected void onInstructionProducesNPE(MethodCallInstruction instruction, DataFlowRunner runner) {
            ((StandardDataFlowRunner)runner).onInstructionProducesNPE(instruction);
        }

        @Override
        protected void onUnboxingNullable(MethodCallInstruction instruction, DataFlowRunner runner) {
            ((StandardDataFlowRunner)runner).onUnboxingNullable(instruction.getContext());
        }

        @Override
        protected void onPassingNullParameter(DataFlowRunner runner, PsiExpression arg) {
            ((StandardDataFlowRunner)runner).onPassingNullParameter(arg);
        }
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox mySuggestNullables;
        private final JCheckBox myDontReportTrueAsserts;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.mySuggestNullables = new JCheckBox(InspectionsBundle.message((String)"inspection.data.flow.nullable.quickfix.option", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
            this.mySuggestNullables.setSelected(DataFlowInspection.this.SUGGEST_NULLABLE_ANNOTATIONS);
            this.mySuggestNullables.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.SUGGEST_NULLABLE_ANNOTATIONS = OptionsPanel.this.mySuggestNullables.isSelected();
                }
            });
            this.myDontReportTrueAsserts = new JCheckBox(InspectionsBundle.message((String)"inspection.data.flow.true.asserts.option", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}));
            this.myDontReportTrueAsserts.setSelected(DataFlowInspection.this.DONT_REPORT_TRUE_ASSERT_STATEMENTS);
            this.myDontReportTrueAsserts.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.DONT_REPORT_TRUE_ASSERT_STATEMENTS = OptionsPanel.this.myDontReportTrueAsserts.isSelected();
                }
            });
            gc.insets = new Insets(0, 0, 15, 0);
            gc.gridy = 0;
            this.add((Component)this.mySuggestNullables, gc);
            ++gc.gridy;
            this.add((Component)this.myDontReportTrueAsserts, gc);
        }
    }

    private static class RedundantInstanceofFix
    implements LocalQuickFix {
        private RedundantInstanceofFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.data.flow.redundant.instanceof.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DataFlowInspection$RedundantInstanceofFix.getName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DataFlowInspection$RedundantInstanceofFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/dataFlow/DataFlowInspection$RedundantInstanceofFix.applyFix must not be null");
            }
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{PsiUtilBase.getVirtualFile((PsiElement)descriptor.getPsiElement())}).hasReadonlyFiles()) {
                return;
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof PsiInstanceOfExpression) {
                try {
                    PsiExpression compareToNull = JavaPsiFacade.getInstance((Project)psiElement.getProject()).getElementFactory().createExpressionFromText(((PsiInstanceOfExpression)psiElement).getOperand().getText() + " != null", psiElement.getParent());
                    psiElement.replace((PsiElement)compareToNull);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/DataFlowInspection$RedundantInstanceofFix.getFamilyName must not return null");
            }
            return string;
        }
    }
}

