/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveAnnotationQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.i18n.AnnotateNonNlsQuickfix");
    private final PsiAnnotation myAnnotation;
    private final PsiModifierListOwner myListOwner;

    public RemoveAnnotationQuickFix(PsiAnnotation annotation, PsiModifierListOwner listOwner) {
        this.myAnnotation = annotation;
        this.myListOwner = listOwner;
    }

    @NotNull
    public String getName() {
        String string = CodeInsightBundle.message((String)"remove.annotation", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/RemoveAnnotationQuickFix.getName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/RemoveAnnotationQuickFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/RemoveAnnotationQuickFix.applyFix must not be null");
        }
        if (this.myAnnotation.isPhysical()) {
            try {
                if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)this.myAnnotation)) {
                    return;
                }
                this.myAnnotation.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        } else {
            ExternalAnnotationsManager.getInstance((Project)project).deannotate(this.myListOwner, this.myAnnotation.getQualifiedName());
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/RemoveAnnotationQuickFix.getFamilyName must not return null");
        }
        return string;
    }
}

