/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl.editorActions;

import com.intellij.codeInsight.editorActions.BaseEnterHandler;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;

public class EnterHandler
extends BaseEnterHandler {
    private final EditorActionHandler myOriginalHandler;

    public EnterHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        return this.myOriginalHandler.isEnabled(editor, dataContext);
    }

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            this.myOriginalHandler.execute(editor, dataContext);
            return;
        }
        TemplateManagerImpl templateManager = (TemplateManagerImpl)TemplateManager.getInstance(project);
        if (!templateManager.startTemplate(editor, '\n')) {
            this.myOriginalHandler.execute(editor, dataContext);
        }
    }
}

