/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColorChooser;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorChooserIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        PsiElement psiElement;
        PsiReference reference;
        PsiJavaCodeReferenceElement referenceElement;
        PsiNewExpression expression;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ColorChooserIntentionAction.isAvailable must not be null");
        }
        if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PsiNewExpression.class))).accepts((Object)element) && (expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class, (boolean)false)) != null && (referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)expression, PsiJavaCodeReferenceElement.class)) != null && (reference = referenceElement.getReference()) != null && (psiElement = reference.resolve()) instanceof PsiClass && "java.awt.Color".equals(((PsiClass)psiElement).getQualifiedName())) {
            this.setText(CodeInsightBundle.message((String)"intention.color.chooser.dialog", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.color.chooser.dialog", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/ColorChooserIntentionAction.getFamilyName must not return null");
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/ColorChooserIntentionAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiNewExpression expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
        if (expression == null) {
            return;
        }
        Color c = null;
        PsiExpressionList argumentList = expression.getArgumentList();
        if (argumentList != null) {
            PsiExpression[] expressions = argumentList.getExpressions();
            int[] values = new int[expressions.length];
            float[] values2 = new float[expressions.length];
            int i = 0;
            int j = 0;
            for (PsiExpression each : expressions) {
                if (!(each instanceof PsiLiteralExpression)) continue;
                Object o = ((PsiLiteralExpression)each).getValue();
                if (o instanceof Integer) {
                    values[i] = (Integer)o;
                    ++i;
                    continue;
                }
                if (!(o instanceof Float)) continue;
                values2[j] = ((Float)o).floatValue();
                ++j;
            }
            if (i == expressions.length) {
                switch (values.length) {
                    case 1: {
                        c = new Color(values[0]);
                        break;
                    }
                    case 3: {
                        c = new Color(values[0], values[1], values[2]);
                        break;
                    }
                    case 4: {
                        c = new Color(values[0], values[1], values[2], values[3]);
                        break;
                    }
                }
            } else if (j == expressions.length) {
                switch (values2.length) {
                    case 3: {
                        c = new Color(values2[0], values2[1], values2[2]);
                        break;
                    }
                    case 4: {
                        c = new Color(values2[0], values2[1], values2[2], values2[3]);
                        break;
                    }
                }
            }
        }
        c = c == null ? Color.GRAY : c;
        Color color = ColorChooser.chooseColor((Component)editor.getComponent(), (String)CodeInsightBundle.message((String)"intention.color.chooser.dialog", (Object[])new Object[0]), (Color)c);
        if (color != null) {
            PsiManager manager = expression.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiExpression newCall = factory.createExpressionFromText("new java.awt.Color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")", (PsiElement)expression);
            PsiElement insertedElement = expression.replace((PsiElement)newCall);
            CodeStyleManager codeStyleManager = manager.getCodeStyleManager();
            codeStyleManager.reformat(insertedElement);
        }
    }
}

