/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;

public abstract class ChooseClassAndDoHighlightRunnable
implements Runnable {
    private final PsiClass[] myClasses;
    private final Editor myEditor;
    private JList myList;
    private final String myTitle;

    public ChooseClassAndDoHighlightRunnable(PsiClassType[] classTypes, Editor editor, String title) {
        List<PsiClass> classes = ChooseClassAndDoHighlightRunnable.resolveClasses(classTypes);
        this.myClasses = classes.toArray(new PsiClass[classes.size()]);
        this.myEditor = editor;
        this.myTitle = title;
    }

    protected ChooseClassAndDoHighlightRunnable(List<PsiClass> classes, Editor editor, String title) {
        this.myClasses = classes.toArray(new PsiClass[classes.size()]);
        this.myEditor = editor;
        this.myTitle = title;
    }

    public static List<PsiClass> resolveClasses(PsiClassType[] classTypes) {
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        for (PsiClassType classType : classTypes) {
            PsiClass aClass = classType.resolve();
            if (aClass == null) continue;
            classes.add(aClass);
        }
        return classes;
    }

    protected abstract void selected(PsiClass ... var1);

    @Override
    public void run() {
        if (this.myClasses.length == 1) {
            this.selected(this.myClasses[0]);
        } else if (this.myClasses.length > 0) {
            PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
            Arrays.sort(this.myClasses, renderer.getComparator());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.selected(this.myClasses);
                return;
            }
            Vector<PsiClass> model = new Vector<PsiClass>(Arrays.asList(this.myClasses));
            model.insertElementAt((PsiClass)CodeInsightBundle.message((String)"highlight.thrown.exceptions.chooser.all.entry", (Object[])new Object[0]), 0);
            this.myList = new JList<PsiClass>(model);
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer(renderer);
            final PopupChooserBuilder builder = new PopupChooserBuilder(this.myList);
            renderer.installSpeedSearch(builder);
            final Runnable callback = new Runnable(){

                @Override
                public void run() {
                    int idx = ChooseClassAndDoHighlightRunnable.this.myList.getSelectedIndex();
                    if (idx < 0) {
                        return;
                    }
                    if (idx > 0) {
                        ChooseClassAndDoHighlightRunnable.this.selected(ChooseClassAndDoHighlightRunnable.this.myClasses[idx - 1]);
                    } else {
                        ChooseClassAndDoHighlightRunnable.this.selected(ChooseClassAndDoHighlightRunnable.this.myClasses);
                    }
                }
            };
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    builder.setTitle(ChooseClassAndDoHighlightRunnable.this.myTitle).setItemChoosenCallback(callback).createPopup().showInBestPositionFor(ChooseClassAndDoHighlightRunnable.this.myEditor);
                }
            });
        }
    }
}

