/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.EncapsulatableClassMember;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.Nullable;

public class PsiFieldMember
extends PsiElementClassMember<PsiField>
implements EncapsulatableClassMember {
    private static final int FIELD_OPTIONS = 7;

    public PsiFieldMember(PsiField field) {
        super(field, PsiFormatUtil.formatVariable((PsiVariable)field, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY));
    }

    @Override
    @Nullable
    public PsiGenerationInfo generateGetter() {
        PsiField field = (PsiField)this.getElement();
        PsiMethod method = PsiFieldMember.createMethodIfNotExists(field, PropertyUtil.generateGetterPrototype((PsiField)field));
        return method != null ? new PsiGenerationInfo<PsiMethod>(method) : null;
    }

    @Nullable
    private static PsiMethod createMethodIfNotExists(PsiField field, PsiMethod template) {
        PsiMethod existing = field.getContainingClass().findMethodBySignature(template, false);
        return existing == null ? template : null;
    }

    @Override
    @Nullable
    public PsiGenerationInfo generateSetter() {
        PsiField field = (PsiField)this.getElement();
        if (field.hasModifierProperty("final")) {
            return null;
        }
        PsiMethod method = PsiFieldMember.createMethodIfNotExists(field, PropertyUtil.generateSetterPrototype((PsiField)field));
        return method == null ? null : new PsiGenerationInfo<PsiMethod>(method);
    }
}

