/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.XmlAutoLookupHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlTag;

public class XmlAutoPopupHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project, Editor editor, PsiFile file) {
        boolean spaceInTag;
        boolean isXmlLikeFile = file.getLanguage() instanceof XMLLanguage || file.getViewProvider().getBaseLanguage() instanceof XMLLanguage;
        boolean bl = spaceInTag = isXmlLikeFile && charTyped == ' ';
        if (spaceInTag) {
            PsiElement parent;
            spaceInTag = false;
            PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
            if (at != null && (parent = at.getParent()) instanceof XmlTag) {
                spaceInTag = true;
            }
        }
        if ((charTyped == '<' || charTyped == '{' || charTyped == '/' || spaceInTag) && isXmlLikeFile) {
            XmlAutoPopupHandler.autoPopupXmlLookup(project, editor);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public static void autoPopupXmlLookup(final Project project, final Editor editor) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (settings.AUTO_POPUP_XML_LOOKUP) {
            Runnable request = new Runnable(){

                @Override
                public void run() {
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                    final PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
                    if (file == null) {
                        return;
                    }
                    CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                        @Override
                        public void run() {
                            new XmlAutoLookupHandler().invoke(project, editor, file);
                        }
                    }, null, null);
                }
            };
            AutoPopupController.getInstance(project).invokeAutoPopupRunnable(request, settings.XML_LOOKUP_DELAY);
        }
    }
}

