/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MoveCatchUpFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.DeleteCatchFix");
    private final PsiCatchSection myCatchSection;
    private final PsiCatchSection myMoveBeforeSection;

    public MoveCatchUpFix(PsiCatchSection catchSection, PsiCatchSection moveBeforeSection) {
        this.myCatchSection = catchSection;
        this.myMoveBeforeSection = moveBeforeSection;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("move.catch.up.text", HighlightUtil.formatType(this.myCatchSection.getCatchType()), HighlightUtil.formatType(this.myMoveBeforeSection.getCatchType()));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("move.catch.up.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix.isAvailable must not be null");
        }
        return this.myCatchSection != null && this.myCatchSection.isValid() && this.myCatchSection.getManager().isInProject((PsiElement)this.myCatchSection) && this.myMoveBeforeSection != null && this.myMoveBeforeSection.isValid() && this.myCatchSection.getCatchType() != null && PsiUtil.resolveClassInType((PsiType)this.myCatchSection.getCatchType()) != null && this.myMoveBeforeSection.getCatchType() != null && PsiUtil.resolveClassInType((PsiType)this.myMoveBeforeSection.getCatchType()) != null && !this.myCatchSection.getManager().areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)this.myCatchSection.getCatchType()), (PsiElement)PsiUtil.resolveClassInType((PsiType)this.myMoveBeforeSection.getCatchType()));
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myCatchSection.getContainingFile())) {
            return;
        }
        try {
            PsiTryStatement statement = this.myCatchSection.getTryStatement();
            statement.addBefore((PsiElement)this.myCatchSection, (PsiElement)this.myMoveBeforeSection);
            this.myCatchSection.delete();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

