/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModifierFix
extends IntentionAndQuickFixAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.ModifierFix");
    private final PsiModifierList myModifierList;
    @Modifier
    private final String myModifier;
    private final boolean myShouldHave;
    private final boolean myShowContainingClass;
    private PsiVariable myVariable;

    public ModifierFix(PsiModifierList modifierList, @Modifier @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        if (modifier == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix.<init> must not be null");
        }
        this.myModifierList = modifierList;
        this.myModifier = modifier;
        this.myShouldHave = shouldHave;
        this.myShowContainingClass = showContainingClass;
    }

    public ModifierFix(@NotNull PsiModifierListOwner owner, @Modifier @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix.<init> must not be null");
        }
        if (modifier == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix.<init> must not be null");
        }
        this(owner.getModifierList(), modifier, shouldHave, showContainingClass);
        if (owner instanceof PsiVariable) {
            this.myVariable = (PsiVariable)owner;
        }
    }

    @NotNull
    public String getName() {
        PsiVariable parent;
        String name = null;
        Object object = parent = this.myVariable == null ? this.myModifierList.getParent() : this.myVariable;
        if (parent instanceof PsiClass) {
            name = ((PsiClass)parent).getName();
        } else {
            int options = 1 | (this.myShowContainingClass ? 4096 : 0);
            if (parent instanceof PsiMethod) {
                name = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)parent), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)0);
            } else if (parent instanceof PsiVariable) {
                name = PsiFormatUtil.formatVariable((PsiVariable)parent, (int)options, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            } else if (parent instanceof PsiClassInitializer) {
                PsiClass containingClass = ((PsiClassInitializer)parent).getContainingClass();
                String className = containingClass instanceof PsiAnonymousClass ? QuickFixBundle.message("anonymous.class.presentation", ((PsiAnonymousClass)containingClass).getBaseClassType().getPresentableText()) : containingClass.getName();
                name = QuickFixBundle.message("class.initializer.presentation", className);
            }
        }
        String modifierText = VisibilityUtil.toPresentableText((String)this.myModifier);
        String string = QuickFixBundle.message(this.myShouldHave ? "add.modifier.fix" : "remove.modifier.fix", name, modifierText);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.modifiers.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix.isAvailable must not be null");
        }
        return this.myModifierList != null && this.myModifierList.isValid() && this.myModifierList.getManager().isInProject((PsiElement)this.myModifierList) && this.myModifierList.hasModifierProperty(this.myModifier) != this.myShouldHave && (this.myVariable == null || this.myVariable.isValid());
    }

    private void changeModifierList(PsiModifierList modifierList) {
        try {
            modifierList.setModifierProperty(this.myModifier, this.myShouldHave);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public void applyFix(Project project, PsiFile file, @Nullable Editor editor) {
        PsiElement owner;
        PsiModifierList modifierList;
        if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)this.myModifierList)) {
            return;
        }
        final ArrayList modifierLists = new ArrayList();
        final PsiFile containingFile = this.myModifierList.getContainingFile();
        if (this.myVariable != null && this.myVariable.isValid()) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        ModifierFix.this.myVariable.normalizeDeclaration();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
            modifierList = this.myVariable.getModifierList();
            assert (modifierList != null);
        } else {
            modifierList = this.myModifierList;
        }
        if ((owner = modifierList.getParent()) instanceof PsiMethod) {
            PsiModifierList copy = (PsiModifierList)this.myModifierList.copy();
            this.changeModifierList(copy);
            final int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)copy);
            OverridingMethodsSearch.search((PsiMethod)((PsiMethod)owner), (SearchScope)owner.getResolveScope(), (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiMethod>(){

                public boolean execute(PsiMethod inheritor) {
                    PsiModifierList list = inheritor.getModifierList();
                    if (inheritor.getManager().isInProject((PsiElement)inheritor) && PsiUtil.getAccessLevel((PsiModifierList)list) < accessLevel) {
                        modifierLists.add(list);
                    }
                    return true;
                }
            }));
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(containingFile)) {
            return;
        }
        if (!modifierLists.isEmpty() && Messages.showYesNoDialog((Project)project, (String)QuickFixBundle.message("change.inheritors.visibility.warning.text", new Object[0]), (String)QuickFixBundle.message("change.inheritors.visibility.warning.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    if (!CodeInsightUtilBase.preparePsiElementsForWrite(modifierLists)) {
                        return;
                    }
                    for (PsiModifierList modifierList : modifierLists) {
                        ModifierFix.this.changeModifierList(modifierList);
                    }
                }
            });
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ModifierFix.this.changeModifierList(modifierList);
                UndoUtil.markPsiFileForUndo((PsiFile)containingFile);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

