/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.actions.TypeCookAction;
import org.jetbrains.annotations.NotNull;

public class GenerifyFileFix
implements IntentionAction {
    private final PsiFile myFile;

    public GenerifyFileFix(PsiFile file) {
        this.myFile = file;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("generify.text", this.myFile.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("generify.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix.isAvailable must not be null");
        }
        return this.myFile.isValid() && PsiManager.getInstance((Project)project).isInProject((PsiElement)this.myFile);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/GenerifyFileFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myFile)) {
            return;
        }
        new TypeCookAction().getHandler().invoke(project, editor, file, null);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

