/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateFieldFromUsageFix
extends CreateVarFromUsageFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageFix");

    public CreateFieldFromUsageFix(PsiReferenceExpression referenceElement) {
        super(referenceElement);
    }

    @Override
    protected String getText(String varName) {
        return QuickFixBundle.message("create.field.from.usage.text", varName);
    }

    protected boolean createConstantField() {
        return false;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        PsiClass parentClass;
        if (CreateFromUsageUtils.isValidReference((PsiReference)this.myReferenceExpression, true)) {
            return;
        }
        Project project = this.myReferenceExpression.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiReferenceExpression enclosingContext = null;
        while ((parentClass = (enclosingContext = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)(enclosingContext == null ? this.myReferenceExpression : enclosingContext), (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClassInitializer.class})) == null ? null : enclosingContext.getContainingClass()) instanceof PsiAnonymousClass) {
        }
        PsiFile targetFile = targetClass.getContainingFile();
        try {
            PsiField field;
            ExpectedTypeInfo[] expectedTypes = CreateFromUsageUtils.guessExpectedTypes((PsiExpression)this.myReferenceExpression, false);
            String fieldName = this.myReferenceExpression.getReferenceName();
            if (!this.createConstantField()) {
                field = factory.createField(fieldName, PsiType.INT);
            } else {
                PsiClass aClass = factory.createClassFromText("int i = 0;", null);
                field = aClass.getFields()[0];
                field.setName(fieldName);
            }
            if (enclosingContext != null && enclosingContext.getParent() == parentClass && targetClass == parentClass && enclosingContext instanceof PsiField) {
                field = (PsiField)targetClass.addBefore((PsiElement)field, (PsiElement)enclosingContext);
            } else if (enclosingContext != null && enclosingContext.getParent() == parentClass && targetClass == parentClass && enclosingContext instanceof PsiClassInitializer) {
                field = (PsiField)targetClass.addBefore((PsiElement)field, (PsiElement)enclosingContext);
                targetClass.addBefore(CodeEditUtil.createLineFeed(field.getManager()), (PsiElement)enclosingContext);
            } else {
                field = (PsiField)targetClass.add((PsiElement)field);
            }
            this.setupVisibility(parentClass, targetClass, field.getModifierList());
            if (CreateFieldFromUsageFix.shouldCreateStaticMember(this.myReferenceExpression, targetClass)) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
            }
            if (this.createConstantField()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
            }
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)field);
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)this.myReferenceExpression, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
            new GuessTypeParameters(factory).setupTypeElement(field.getTypeElement(), expectedTypes, CreateFieldFromUsageFix.getTargetSubstitutor((PsiElement)this.myReferenceExpression), builder, context, targetClass);
            if (this.createConstantField()) {
                builder.replaceElement((PsiElement)field.getInitializer(), (Expression)new EmptyExpression());
            }
            builder.setEndVariableAfter((PsiElement)field.getNameIdentifier());
            field = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(field);
            Template template = builder.buildTemplate();
            Editor newEditor = CreateFieldFromUsageFix.positionCursor(project, targetFile, (PsiElement)field);
            TextRange range = field.getTextRange();
            newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
            CreateFieldFromUsageFix.startTemplate(newEditor, template, project);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.field.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateFieldFromUsageFix.getFamilyName must not return null");
        }
        return string;
    }
}

