/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateClassFromUsageFix
extends CreateClassFromUsageBaseFix {
    public CreateClassFromUsageFix(PsiJavaCodeReferenceElement refElement, CreateClassKind kind) {
        super(kind, refElement);
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.class.from.usage.text", StringUtil.capitalize((String)this.myKind.getDescription()), varName);
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateClassFromUsageFix.invoke must not be null");
        }
        final PsiJavaCodeReferenceElement element = this.getRefElement();
        assert (element != null);
        if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)element)) {
            return;
        }
        final String superClassName = CreateClassFromUsageFix.getSuperClassName(element);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiJavaCodeReferenceElement refElement = element;
                PsiClass aClass = CreateFromUsageUtils.createClass(refElement, CreateClassFromUsageFix.this.myKind, superClassName);
                if (aClass == null) {
                    return;
                }
                try {
                    refElement = (PsiJavaCodeReferenceElement)refElement.bindToElement((PsiElement)aClass);
                }
                catch (IncorrectOperationException e) {
                    CreateClassFromUsageBaseFix.LOG.error((Throwable)e);
                }
                IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
                OpenFileDescriptor descriptor = new OpenFileDescriptor(refElement.getProject(), aClass.getContainingFile().getVirtualFile(), aClass.getTextOffset());
                FileEditorManager.getInstance((Project)aClass.getProject()).openTextEditor(descriptor, true);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

