/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateClassFromNewFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix");
    private final SmartPsiElementPointer myNewExpression;

    public CreateClassFromNewFix(PsiNewExpression newExpression) {
        this.myNewExpression = SmartPointerManager.getInstance((Project)newExpression.getProject()).createSmartPsiElementPointer((PsiElement)newExpression);
    }

    protected PsiNewExpression getNewExpression() {
        return (PsiNewExpression)this.myNewExpression.getElement();
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        PsiNewExpression newExpression = this.getNewExpression();
        PsiClass psiClass = CreateFromUsageUtils.createClass(CreateClassFromNewFix.getReferenceElement(newExpression), CreateClassKind.CLASS, null);
        CreateClassFromNewFix.setupClassFromNewExpression(psiClass, newExpression);
    }

    protected static void setupClassFromNewExpression(final PsiClass psiClass, final PsiNewExpression newExpression) {
        final PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)newExpression.getProject()).getElementFactory();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    PsiClass aClass = psiClass;
                    if (aClass == null) {
                        return;
                    }
                    PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
                    if (classReference != null) {
                        classReference.bindToElement((PsiElement)aClass);
                    }
                    CreateClassFromNewFix.setupInheritance(newExpression, aClass);
                    CreateClassFromNewFix.setupGenericParameters(newExpression, aClass);
                    PsiExpressionList argList = newExpression.getArgumentList();
                    Project project = aClass.getProject();
                    if (argList != null && argList.getExpressions().length > 0) {
                        PsiMethod constructor = elementFactory.createConstructor();
                        constructor = (PsiMethod)aClass.add((PsiElement)constructor);
                        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)aClass);
                        CreateFromUsageUtils.setupMethodParameters(constructor, templateBuilder, argList, CreateFromUsageBaseFix.getTargetSubstitutor((PsiElement)newExpression));
                        CreateClassFromNewFix.setupSuperCall(aClass, constructor, templateBuilder);
                        CreateClassFromNewFix.getReferenceElement(newExpression).bindToElement((PsiElement)aClass);
                        aClass = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(aClass);
                        Template template = templateBuilder.buildTemplate();
                        Editor editor = CreateFromUsageBaseFix.positionCursor(project, aClass.getContainingFile(), (PsiElement)aClass);
                        TextRange textRange = aClass.getTextRange();
                        editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
                        CreateFromUsageBaseFix.startTemplate(editor, template, project);
                    } else {
                        CreateFromUsageBaseFix.positionCursor(project, aClass.getContainingFile(), (PsiElement)aClass);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void setupSuperCall(PsiClass targetClass, PsiMethod constructor, TemplateBuilderImpl templateBuilder) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)targetClass.getProject()).getElementFactory();
        PsiClass superClass = targetClass.getSuperClass();
        if (superClass != null && !"java.lang.Object".equals(superClass.getQualifiedName()) && !"java.lang.Enum".equals(superClass.getQualifiedName())) {
            PsiMethod[] constructors = superClass.getConstructors();
            boolean hasDefaultConstructor = false;
            for (PsiMethod superConstructor : constructors) {
                if (superConstructor.getParameterList().getParametersCount() != 0) continue;
                hasDefaultConstructor = true;
                break;
            }
            if (!hasDefaultConstructor) {
                PsiExpressionStatement statement = (PsiExpressionStatement)elementFactory.createStatementFromText("super();", (PsiElement)constructor);
                statement = (PsiExpressionStatement)constructor.getBody().add((PsiElement)statement);
                PsiMethodCallExpression call = (PsiMethodCallExpression)statement.getExpression();
                PsiExpressionList argumentList = call.getArgumentList();
                templateBuilder.setEndVariableAfter(argumentList.getFirstChild());
            }
        }
        templateBuilder.setEndVariableAfter((PsiElement)constructor.getBody().getLBrace());
    }

    private static void setupGenericParameters(PsiNewExpression expr, PsiClass targetClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref = CreateClassFromNewFix.getReferenceElement(expr);
        int numParams = ref.getTypeParameters().length;
        if (numParams == 0) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
        targetClass.getTypeParameterList().add((PsiElement)factory.createTypeParameterFromText("T", null));
        for (int i = 2; i <= numParams; ++i) {
            targetClass.getTypeParameterList().add((PsiElement)factory.createTypeParameterFromText("T" + (i - 1), null));
        }
    }

    private static void setupInheritance(PsiNewExpression element, PsiClass targetClass) throws IncorrectOperationException {
        ExpectedTypeInfo[] expectedTypes;
        if (element.getParent() instanceof PsiReferenceExpression) {
            return;
        }
        for (ExpectedTypeInfo expectedType : expectedTypes = ExpectedTypesProvider.getInstance(element.getProject()).getExpectedTypes((PsiExpression)element, false)) {
            PsiClassType classType;
            PsiClass aClass;
            PsiType type = expectedType.getType();
            if (!(type instanceof PsiClassType) || (aClass = (classType = (PsiClassType)type).resolve()) == null || aClass.equals(targetClass) || aClass.hasModifierProperty("final")) continue;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
            if (aClass.isInterface()) {
                PsiReferenceList implementsList = targetClass.getImplementsList();
                implementsList.add((PsiElement)factory.createReferenceElementByType(classType));
                continue;
            }
            PsiReferenceList extendsList = targetClass.getExtendsList();
            if (extendsList.getReferencedTypes().length != 0 || "java.lang.Object".equals(classType.getCanonicalText())) continue;
            extendsList.add((PsiElement)factory.createReferenceElementByType(classType));
        }
    }

    private static PsiFile getTargetFile(PsiElement element) {
        PsiJavaCodeReferenceElement qualifier;
        PsiElement psiElement;
        PsiJavaCodeReferenceElement referenceElement = CreateClassFromNewFix.getReferenceElement((PsiNewExpression)element);
        PsiElement q = referenceElement.getQualifier();
        if (q instanceof PsiJavaCodeReferenceElement && (psiElement = (qualifier = (PsiJavaCodeReferenceElement)q).resolve()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiElement;
            return psiClass.getContainingFile();
        }
        return null;
    }

    @Override
    protected PsiElement getElement() {
        PsiNewExpression expression = this.getNewExpression();
        if (expression == null || !expression.getManager().isInProject((PsiElement)expression)) {
            return null;
        }
        PsiJavaCodeReferenceElement referenceElement = CreateClassFromNewFix.getReferenceElement(expression);
        if (referenceElement == null) {
            return null;
        }
        if (referenceElement.getReferenceNameElement() instanceof PsiIdentifier) {
            return expression;
        }
        return null;
    }

    @Override
    protected boolean isAllowOuterTargetClass() {
        return false;
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)element, PsiJavaCodeReferenceElement.class);
        return ref != null && ref.resolve() != null;
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiElement nameElement = CreateClassFromNewFix.getNameElement(this.getNewExpression());
        PsiFile targetFile = CreateClassFromNewFix.getTargetFile((PsiElement)this.getNewExpression());
        if (targetFile != null && !targetFile.getManager().isInProject((PsiElement)targetFile)) {
            return false;
        }
        if (CreateFromUsageUtils.shouldShowTag(offset, nameElement, (PsiElement)this.getNewExpression())) {
            String varName = nameElement.getText();
            this.setText(this.getText(varName));
            return true;
        }
        return false;
    }

    protected String getText(String varName) {
        return QuickFixBundle.message("create.class.from.new.text", varName);
    }

    private static PsiJavaCodeReferenceElement getReferenceElement(PsiNewExpression expression) {
        return expression.getClassOrAnonymousClassReference();
    }

    private static PsiElement getNameElement(PsiNewExpression targetElement) {
        PsiJavaCodeReferenceElement referenceElement = CreateClassFromNewFix.getReferenceElement(targetElement);
        if (referenceElement == null) {
            return null;
        }
        return referenceElement.getReferenceNameElement();
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.class.from.new.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateClassFromNewFix.getFamilyName must not return null");
        }
        return string;
    }
}

