/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class AddReturnFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddReturnFix");
    private final PsiMethod myMethod;

    public AddReturnFix(PsiMethod method) {
        this.myMethod = method;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.return.statement.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.return.statement.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix.isAvailable must not be null");
        }
        return this.myMethod != null && this.myMethod.isValid() && this.myMethod.getManager().isInProject((PsiElement)this.myMethod) && this.myMethod.getBody() != null && this.myMethod.getBody().getRBrace() != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myMethod.getContainingFile())) {
            return;
        }
        try {
            String value = this.suggestReturnValue();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
            PsiReturnStatement returnStatement = (PsiReturnStatement)factory.createStatementFromText("return " + value + ";", (PsiElement)this.myMethod);
            PsiCodeBlock body = this.myMethod.getBody();
            returnStatement = (PsiReturnStatement)body.addBefore((PsiElement)returnStatement, (PsiElement)body.getRBrace());
            TextRange range = returnStatement.getReturnValue().getTextRange();
            int offset = range.getStartOffset();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(range.getEndOffset(), range.getStartOffset());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private String suggestReturnValue() {
        PsiVariable[] variables;
        PsiType type = this.myMethod.getReturnType();
        for (PsiVariable variable : variables = this.getDeclaredVariables(this.myMethod)) {
            if (variable.getType() == null || !type.equals(variable.getType())) continue;
            return variable.getName();
        }
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type);
    }

    private PsiVariable[] getDeclaredVariables(PsiMethod method) {
        PsiStatement[] statements;
        ArrayList<Object> variables = new ArrayList<Object>();
        for (PsiStatement statement : statements = method.getBody().getStatements()) {
            PsiElement[] declaredElements;
            if (!(statement instanceof PsiDeclarationStatement)) continue;
            for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                if (!(declaredElement instanceof PsiLocalVariable)) continue;
                variables.add(declaredElement);
            }
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        variables.addAll(Arrays.asList(parameters));
        return variables.toArray(new PsiVariable[variables.size()]);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

