/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixProvider;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.htmlInspections.RequiredAttributesInspection;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.idea.LoggerFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SmartList;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlHighlightVisitor
extends XmlElementVisitor
implements HighlightVisitor,
Validator.ValidationHost {
    private static final Logger LOG = LoggerFactory.getInstance().getLoggerInstance("com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor");
    public static final Key<String> DO_NOT_VALIDATE_KEY = Key.create((String)"do not validate");
    private List<HighlightInfo> myResult;
    private static boolean ourDoJaxpTesting;
    private static final TextAttributes NONEMPTY_TEXT_ATTRIBUTES;

    private void addElementsForTag(XmlTag tag, String localizedMessage, HighlightInfoType type, IntentionAction quickFixAction) {
        this.addElementsForTagWithManyQuickFixes(tag, localizedMessage, type, quickFixAction);
    }

    private void addElementsForTagWithManyQuickFixes(XmlTag tag, String localizedMessage, HighlightInfoType type, IntentionAction ... quickFixActions) {
        this.bindMessageToTag(tag, type, -1, localizedMessage, quickFixActions);
    }

    public void visitXmlToken(XmlToken token) {
        String marker;
        String s;
        int i;
        IElementType tokenType = token.getTokenType();
        if (tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME) {
            PsiElement element = token.getPrevSibling();
            while (element instanceof PsiWhiteSpace) {
                element = element.getPrevSibling();
            }
            if (element instanceof XmlToken) {
                PsiElement parent;
                if (((XmlToken)element).getTokenType() == XmlTokenType.XML_START_TAG_START && (parent = element.getParent()) instanceof XmlTag && !(token.getNextSibling() instanceof OuterLanguageElement)) {
                    this.checkTag((XmlTag)parent);
                }
            } else {
                PsiElement parent = token.getParent();
                if (parent instanceof XmlAttribute && !(token.getNextSibling() instanceof OuterLanguageElement)) {
                    this.checkAttribute((XmlAttribute)parent);
                }
            }
        } else if (tokenType == XmlTokenType.XML_DATA_CHARACTERS && token.getParent() instanceof XmlText && token.textContains(']') && token.textContains('>') && (i = (s = token.getText()).indexOf(marker = "]]>")) != -1) {
            TextRange textRange = token.getTextRange();
            int start = textRange.getStartOffset() + i;
            this.addToResults(HighlightInfo.createHighlightInfo(PsiTreeUtil.getParentOfType((PsiElement)token, XmlTag.class) instanceof HtmlTag ? HighlightInfoType.WARNING : HighlightInfoType.ERROR, start, start + marker.length(), XmlErrorMessages.message("cdata.end.should.not.appear.in.content.unless.to.mark.end.of.cdata.section", new Object[0])));
        }
    }

    private void checkTag(XmlTag tag) {
        if (ourDoJaxpTesting) {
            return;
        }
        if (this.myResult == null) {
            this.checkTagByDescriptor(tag);
        }
        if (this.myResult == null && tag.getUserData(DO_NOT_VALIDATE_KEY) == null) {
            XmlElementDescriptor descriptor = tag.getDescriptor();
            if (tag instanceof HtmlTag && (descriptor instanceof AnyXmlElementDescriptor || descriptor == null)) {
                return;
            }
            this.checkReferences((PsiElement)tag);
        }
    }

    private void bindMessageToTag(XmlTag tag, HighlightInfoType warning, int messageLength, String localizedMessage, IntentionAction ... quickFixActions) {
        XmlToken childByRole = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        this.bindMessageToAstNode((PsiElement)childByRole, warning, 0, messageLength, localizedMessage, quickFixActions);
        childByRole = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
        this.bindMessageToAstNode((PsiElement)childByRole, warning, 0, messageLength, localizedMessage, quickFixActions);
    }

    private void bindMessageToAstNode(PsiElement childByRole, HighlightInfoType warning, int offset, int length, String localizedMessage, IntentionAction ... quickFixActions) {
        if (childByRole != null) {
            int startOffset;
            HighlightInfo highlightInfo;
            TextRange textRange = childByRole.getTextRange();
            if (length == -1) {
                length = textRange.getLength();
            }
            if ((highlightInfo = HighlightInfo.createHighlightInfo(warning, childByRole, startOffset = textRange.getStartOffset() + offset, startOffset + length, localizedMessage, HighlightInfo.htmlEscapeToolTip(localizedMessage))) == null) {
                highlightInfo = HighlightInfo.createHighlightInfo(warning, new TextRange(startOffset, startOffset + length), localizedMessage, localizedMessage, NONEMPTY_TEXT_ATTRIBUTES);
            }
            for (IntentionAction quickFixAction : quickFixActions) {
                if (quickFixAction == null) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, textRange, quickFixAction, null);
            }
            this.addToResults(highlightInfo);
        }
    }

    private void checkTagByDescriptor(XmlTag tag) {
        String name = tag.getName();
        XmlElementDescriptor elementDescriptor = null;
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag) {
            XmlTag parentTag = (XmlTag)parent;
            XmlElementDescriptor parentDescriptor = parentTag.getDescriptor();
            if (parentDescriptor != null) {
                elementDescriptor = XmlExtension.getExtension(tag.getContainingFile()).getElementDescriptor(tag, parentTag, parentDescriptor);
            }
            if (parentDescriptor != null && elementDescriptor == null && parentTag.getUserData(DO_NOT_VALIDATE_KEY) == null && !XmlUtil.tagFromTemplateFramework(tag)) {
                if (tag instanceof HtmlTag) {
                    return;
                }
                this.addElementsForTag(tag, XmlErrorMessages.message("element.is.not.allowed.here", name), XmlHighlightVisitor.getTagProblemInfoType(tag), null);
                return;
            }
            if (elementDescriptor instanceof AnyXmlElementDescriptor || elementDescriptor == null) {
                elementDescriptor = tag.getDescriptor();
            }
            if (elementDescriptor == null) {
                return;
            }
        } else {
            elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null) {
                this.addElementsForTag(tag, XmlErrorMessages.message("element.must.be.declared", name), HighlightInfoType.WRONG_REF, null);
                return;
            }
        }
        XmlAttributeDescriptor[] attributeDescriptors = elementDescriptor.getAttributesDescriptors(tag);
        HashSet<String> requiredAttributes = null;
        for (XmlAttributeDescriptor attribute : attributeDescriptors) {
            if (attribute == null || !attribute.isRequired()) continue;
            if (requiredAttributes == null) {
                requiredAttributes = new HashSet<String>();
            }
            requiredAttributes.add(attribute.getName((PsiElement)tag));
        }
        if (requiredAttributes != null) {
            for (String attrName : requiredAttributes) {
                if (tag.getAttribute(attrName, "") != null || XmlExtension.getExtension(tag.getContainingFile()).isRequiredAttributeImplicitlyPresent(tag, attrName)) continue;
                InsertRequiredAttributeFix insertRequiredAttributeIntention = new InsertRequiredAttributeFix(tag, attrName, null);
                String localizedMessage = XmlErrorMessages.message("element.doesnt.have.required.attribute", name, attrName);
                InspectionProfile profile = InspectionProjectProfileManager.getInstance(tag.getProject()).getInspectionProfile();
                LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)profile.getInspectionTool("RequiredAttributes", (PsiElement)tag);
                if (toolWrapper == null) continue;
                RequiredAttributesInspection inspection = (RequiredAttributesInspection)toolWrapper.getTool();
                this.reportOneTagProblem(tag, attrName, localizedMessage, insertRequiredAttributeIntention, HighlightDisplayKey.find((String)"RequiredAttributes"), inspection, 3);
            }
        }
        if (elementDescriptor instanceof Validator) {
            ((Validator)elementDescriptor).validate(tag, this);
        }
    }

    private void reportOneTagProblem(XmlTag tag, String name, String localizedMessage, IntentionAction basicIntention, HighlightDisplayKey key, XmlEntitiesInspection inspection, int type) {
        boolean htmlTag = false;
        if (tag instanceof HtmlTag) {
            htmlTag = true;
            if (XmlHighlightVisitor.isAdditionallyDeclared(inspection.getAdditionalEntries(type), name)) {
                return;
            }
        }
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(tag.getProject()).getInspectionProfile();
        IntentionAction intentionAction = inspection.getIntentionAction(name, type);
        if (htmlTag && profile.isToolEnabled(key, (PsiElement)tag)) {
            this.addElementsForTagWithManyQuickFixes(tag, localizedMessage, XmlHighlightVisitor.isInjectedHtmlTagForWhichNoProblemsReporting((HtmlTag)tag) ? HighlightInfoType.INFORMATION : SeverityRegistrar.getInstance(tag.getProject()).getHighlightInfoTypeBySeverity(profile.getErrorLevel(key, (PsiElement)tag).getSeverity()), intentionAction, basicIntention);
        } else if (!htmlTag) {
            this.addElementsForTag(tag, localizedMessage, HighlightInfoType.ERROR, basicIntention);
        }
    }

    private static boolean isAdditionallyDeclared(String additional, String name) {
        if (!additional.contains(name = name.toLowerCase())) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(additional, ", ");
        while (tokenizer.hasMoreTokens()) {
            if (!name.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    private static HighlightInfoType getTagProblemInfoType(XmlTag tag) {
        if (tag instanceof HtmlTag && "http://www.w3.org/1999/html".equals(tag.getNamespace())) {
            if (XmlHighlightVisitor.isInjectedHtmlTagForWhichNoProblemsReporting((HtmlTag)tag)) {
                return HighlightInfoType.INFORMATION;
            }
            return HighlightInfoType.WARNING;
        }
        return HighlightInfoType.WRONG_REF;
    }

    private static boolean isInjectedHtmlTagForWhichNoProblemsReporting(HtmlTag tag) {
        PsiElement context = tag.getContainingFile().getContext();
        return context != null && XmlHighlightVisitor.skipValidation(context);
    }

    private static boolean skipValidation(PsiElement context) {
        return context.getUserData(DO_NOT_VALIDATE_KEY) != null;
    }

    public static void setSkipValidation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor.setSkipValidation must not be null");
        }
        element.putUserData(DO_NOT_VALIDATE_KEY, (Object)"");
    }

    public void visitXmlAttribute(XmlAttribute attribute) {
    }

    private void checkAttribute(XmlAttribute attribute) {
        XmlTag tag = attribute.getParent();
        String name = attribute.getName();
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)attribute);
        if (!(prevLeaf instanceof PsiWhiteSpace)) {
            TextRange textRange = attribute.getTextRange();
            this.addToResults(HighlightInfo.createHighlightInfo(tag instanceof HtmlTag ? HighlightInfoType.WARNING : HighlightInfoType.ERROR, textRange.getStartOffset(), textRange.getStartOffset(), XmlErrorMessages.message("attribute.should.be.preceded.with.space", new Object[0])));
        }
        if (attribute.isNamespaceDeclaration()) {
            this.checkReferences((PsiElement)attribute.getValueElement());
            return;
        }
        String namespace = attribute.getNamespace();
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespace)) {
            this.checkReferences((PsiElement)attribute.getValueElement());
            return;
        }
        XmlElementDescriptor elementDescriptor = tag.getDescriptor();
        if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor || ourDoJaxpTesting) {
            return;
        }
        XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attribute);
        if (attributeDescriptor == null) {
            XmlFile xmlFile;
            String localizedMessage;
            HighlightInfo highlightInfo;
            if (!XmlUtil.attributeFromTemplateFramework(name, tag) && (highlightInfo = this.reportAttributeProblem(tag, name, attribute, localizedMessage = XmlErrorMessages.message("attribute.is.not.allowed.here", name))) != null && (xmlFile = (XmlFile)tag.getContainingFile()) != null) {
                XmlExtension.getExtension((PsiFile)xmlFile).createAddAttributeFix(attribute, highlightInfo);
            }
        } else {
            this.checkDuplicateAttribute(tag, attribute);
            if (tag instanceof HtmlTag && attribute.getValueElement() == null && !HtmlUtil.isSingleHtmlAttribute(name)) {
                String localizedMessage = XmlErrorMessages.message("empty.attribute.is.not.allowed", name);
                this.reportAttributeProblem(tag, name, attribute, localizedMessage);
            }
            PsiReference[] attrRefs = attribute.getReferences();
            this.doCheckRefs((PsiElement)attribute, attrRefs, attribute.getNamespacePrefix().length() > 0 ? 2 : 1);
        }
    }

    @Nullable
    private HighlightInfo reportAttributeProblem(XmlTag tag, String localName, XmlAttribute attribute, String localizedMessage) {
        RemoveAttributeIntentionFix removeAttributeIntention = new RemoveAttributeIntentionFix(localName, attribute);
        if (!(tag instanceof HtmlTag)) {
            HighlightInfoType tagProblemInfoType = HighlightInfoType.WRONG_REF;
            ASTNode node = SourceTreeToPsiMap.psiElementToTree((PsiElement)attribute);
            assert (node != null);
            ASTNode child = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node);
            assert (child != null);
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(tagProblemInfoType, child, localizedMessage);
            this.addToResults(highlightInfo);
            QuickFixAction.registerQuickFixAction(highlightInfo, removeAttributeIntention);
            return highlightInfo;
        }
        return null;
    }

    private void checkDuplicateAttribute(XmlTag tag, XmlAttribute attribute) {
        if (XmlHighlightVisitor.skipValidation((PsiElement)tag)) {
            return;
        }
        XmlAttribute[] attributes = tag.getAttributes();
        PsiFile containingFile = tag.getContainingFile();
        XmlExtension extension = containingFile instanceof XmlFile ? XmlExtension.getExtension(containingFile) : XmlExtension.DEFAULT_EXTENSION;
        for (XmlAttribute tagAttribute : attributes) {
            ProgressManager.checkCanceled();
            if (attribute == tagAttribute || !Comparing.strEqual((String)attribute.getName(), (String)tagAttribute.getName())) continue;
            String localName = attribute.getLocalName();
            if (extension.canBeDuplicated(tagAttribute)) continue;
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(XmlHighlightVisitor.getTagProblemInfoType(tag), XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(SourceTreeToPsiMap.psiElementToTree((PsiElement)attribute)), XmlErrorMessages.message("duplicate.attribute", localName));
            this.addToResults(highlightInfo);
            RemoveAttributeIntentionFix intentionAction = new RemoveAttributeIntentionFix(localName, attribute);
            QuickFixAction.registerQuickFixAction(highlightInfo, intentionAction);
        }
    }

    public void visitXmlDocument(XmlDocument document) {
        PsiMetaData psiMetaData;
        if (document.getLanguage() == DTDLanguage.INSTANCE && (psiMetaData = document.getMetaData()) instanceof Validator) {
            ((Validator)psiMetaData).validate(document, this);
        }
    }

    public void visitXmlTag(XmlTag tag) {
    }

    public void visitXmlAttributeValue(XmlAttributeValue value) {
        String error;
        XmlAttributeDescriptor attributeDescriptor;
        PsiElement parent = value.getParent();
        if (!(parent instanceof XmlAttribute)) {
            this.checkReferences((PsiElement)value);
            return;
        }
        XmlAttribute attribute = (XmlAttribute)parent;
        XmlTag tag = attribute.getParent();
        XmlElementDescriptor elementDescriptor = tag.getDescriptor();
        XmlAttributeDescriptor xmlAttributeDescriptor = attributeDescriptor = elementDescriptor != null ? elementDescriptor.getAttributeDescriptor(attribute) : null;
        if (attributeDescriptor != null && value.getUserData(DO_NOT_VALIDATE_KEY) == null && (error = attributeDescriptor.validateValue((XmlElement)value, attribute.getValue())) != null) {
            this.addToResults(HighlightInfo.createHighlightInfo(XmlHighlightVisitor.getTagProblemInfoType(tag), (PsiElement)value, error));
            return;
        }
        this.checkReferences((PsiElement)value);
    }

    private void checkReferences(PsiElement value) {
        if (value == null) {
            return;
        }
        this.doCheckRefs(value, value.getReferences());
    }

    private void doCheckRefs(PsiElement value, PsiReference[] references) {
        this.doCheckRefs(value, references, 0);
    }

    private void doCheckRefs(PsiElement value, PsiReference[] references, int start) {
        for (int i = start; i < references.length; ++i) {
            PsiElement parent;
            HighlightInfoType type;
            PsiReference reference = references[i];
            ProgressManager.checkCanceled();
            if (reference == null || reference.isSoft() || !XmlHighlightVisitor.hasBadResolve(reference)) continue;
            String description = XmlHighlightVisitor.getErrorDescription(reference);
            int startOffset = reference.getElement().getTextRange().getStartOffset();
            TextRange referenceRange = reference.getRangeInElement();
            if (referenceRange.getStartOffset() > referenceRange.getEndOffset()) {
                LOG.error("Reference range start offset > end offset:  " + reference + ", start offset: " + referenceRange.getStartOffset() + ", end offset: " + referenceRange.getEndOffset());
            }
            if ((type = XmlHighlightVisitor.getTagProblemInfoType((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class))).getSeverity(null).compareTo(HighlightInfoType.WARNING.getSeverity(null)) > 0 && value instanceof XmlAttributeValue && (parent = value.getParent()) instanceof XmlAttribute && ((XmlAttribute)parent).getName().toLowerCase().endsWith("stylename")) {
                type = HighlightInfoType.WARNING;
            }
            HighlightInfo info = HighlightInfo.createHighlightInfo(type, startOffset + referenceRange.getStartOffset(), startOffset + referenceRange.getEndOffset(), description);
            this.addToResults(info);
            if (reference instanceof QuickFixProvider) {
                ((QuickFixProvider)reference).registerQuickfix(info, reference);
            }
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes(reference, new QuickFixActionRegistrarImpl(info));
        }
    }

    public static String getErrorDescription(PsiReference reference) {
        String description;
        String message = reference instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)reference).getUnresolvedMessagePattern() : PsiBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[0]);
        try {
            description = MessageFormat.format(message, reference.getCanonicalText());
        }
        catch (IllegalArgumentException ex) {
            description = message;
            LOG.warn(XmlErrorMessages.message("plugin.reference.message.problem", reference.getClass().getName(), message));
        }
        return description;
    }

    public static boolean hasBadResolve(PsiReference reference) {
        if (reference instanceof PsiPolyVariantReference) {
            return ((PsiPolyVariantReference)reference).multiResolve(false).length == 0;
        }
        return reference.resolve() == null;
    }

    public void visitXmlDoctype(XmlDoctype xmlDoctype) {
        if (XmlHighlightVisitor.skipValidation((PsiElement)xmlDoctype)) {
            return;
        }
        this.checkReferences((PsiElement)xmlDoctype);
    }

    private void addToResults(HighlightInfo info) {
        if (this.myResult == null) {
            this.myResult = new SmartList();
        }
        this.myResult.add(info);
    }

    public static void setDoJaxpTesting(boolean doJaxpTesting) {
        ourDoJaxpTesting = doJaxpTesting;
    }

    @Override
    public void addMessage(PsiElement context, String message, int type) {
        if (message != null && message.length() > 0) {
            if (context instanceof XmlTag && XmlExtension.getExtension(context.getContainingFile()).shouldBeHighlightedAsTag((XmlTag)context)) {
                this.addElementsForTag((XmlTag)context, message, type == 1 ? HighlightInfoType.ERROR : (type == 0 ? HighlightInfoType.WARNING : HighlightInfoType.INFO), null);
            } else {
                this.addToResults(HighlightInfo.createHighlightInfo(HighlightInfoType.WRONG_REF, context, message));
            }
        }
    }

    @Override
    public void addMessage(PsiElement context, String message, Validator.ValidationHost.ErrorType type, IntentionAction ... fixes) {
        if (message != null && message.length() > 0) {
            HighlightInfoType defaultInfoType;
            PsiFile containingFile = context.getContainingFile();
            HighlightInfoType highlightInfoType = type == Validator.ValidationHost.ErrorType.ERROR ? HighlightInfoType.ERROR : (defaultInfoType = type == Validator.ValidationHost.ErrorType.WARNING ? HighlightInfoType.WARNING : HighlightInfoType.INFO);
            if (context instanceof XmlTag && XmlExtension.getExtension(containingFile).shouldBeHighlightedAsTag((XmlTag)context)) {
                this.addElementsForTagWithManyQuickFixes((XmlTag)context, message, defaultInfoType, fixes);
            } else {
                HighlightInfo highlightInfo;
                PsiElement contextOfFile = containingFile.getContext();
                if (contextOfFile != null) {
                    int offsetInRealDocument = PsiUtilBase.findInjectedElementOffsetInRealDocument((PsiElement)context);
                    highlightInfo = HighlightInfo.createHighlightInfo(defaultInfoType, context.getTextRange().shiftRight(offsetInRealDocument), message);
                } else {
                    highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.WRONG_REF, context, message);
                }
                if (fixes != null) {
                    for (IntentionAction quickFixAction : fixes) {
                        if (quickFixAction == null) continue;
                        QuickFixAction.registerQuickFixAction(highlightInfo, quickFixAction);
                    }
                }
                this.addToResults(highlightInfo);
            }
        }
    }

    public static void visitJspElement(OuterLanguageElement text) {
        PsiElement parent = text.getParent();
        if (parent instanceof XmlText) {
            parent = parent.getParent();
        }
        parent.putUserData(DO_NOT_VALIDATE_KEY, (Object)"");
    }

    @Override
    public boolean suitableForFile(PsiFile file) {
        return file instanceof XmlFile;
    }

    @Override
    public void visit(PsiElement element, HighlightInfoHolder holder) {
        element.accept((PsiElementVisitor)this);
        List<HighlightInfo> result = this.myResult;
        holder.addAll(result);
        this.myResult = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(Runnable action, boolean updateWholeFile, PsiFile file) {
        try {
            action.run();
        }
        finally {
            this.myResult = null;
        }
        return true;
    }

    @Override
    public HighlightVisitor clone() {
        return new XmlHighlightVisitor();
    }

    @Override
    public int order() {
        return 1;
    }

    public static String getUnquotedValue(XmlAttributeValue value, XmlTag tag) {
        String unquotedValue = StringUtil.stripQuotesAroundValue((String)value.getText());
        if (tag instanceof HtmlTag) {
            unquotedValue = unquotedValue.toLowerCase();
        }
        return unquotedValue;
    }

    static {
        NONEMPTY_TEXT_ATTRIBUTES = new TextAttributes(){

            public boolean isEmpty() {
                return false;
            }
        };
    }
}

