/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.concurrency.JobUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPass
extends ProgressableTextEditorHighlightingPass
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.LocalInspectionsPass");
    private final int myStartOffset;
    private final int myEndOffset;
    @NotNull
    private List<ProblemDescriptor> myDescriptors;
    @NotNull
    private List<HighlightInfoType> myLevels;
    @NotNull
    private List<LocalInspectionTool> myTools;
    @NotNull
    private List<InjectedPsiInspectionResult> myInjectedPsiInspectionResults;
    static final String PRESENTABLE_NAME = DaemonBundle.message((String)"pass.inspection", (Object[])new Object[0]);
    private volatile List<HighlightInfo> myInfos;
    static final Icon IN_PROGRESS_ICON = IconLoader.getIcon((String)"/general/inspectionInProgress.png");
    private final String myShortcutText;
    private final SeverityRegistrar mySeverityRegistrar;

    public LocalInspectionsPass(@NotNull PsiFile file, @Nullable Document document, int startOffset, int endOffset) {
        Keymap keymap;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.<init> must not be null");
        }
        super(file.getProject(), document, IN_PROGRESS_ICON, PRESENTABLE_NAME, file, true);
        this.myDescriptors = Collections.emptyList();
        this.myLevels = Collections.emptyList();
        this.myTools = Collections.emptyList();
        this.myInjectedPsiInspectionResults = Collections.emptyList();
        this.myInfos = Collections.emptyList();
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.setId(7);
        KeymapManager keymapManager = KeymapManager.getInstance();
        this.myShortcutText = keymapManager != null ? ((keymap = keymapManager.getActiveKeymap()) == null ? "" : "(" + KeymapUtil.getShortcutsText((Shortcut[])keymap.getShortcuts("ShowErrorDescription")) + ")") : "";
        this.mySeverityRegistrar = SeverityRegistrar.getInstance(this.myProject);
    }

    @Override
    protected void collectInformationWithProgress(ProgressIndicator progress) {
        this.myDescriptors = new ArrayList<ProblemDescriptor>();
        this.myLevels = new ArrayList<HighlightInfoType>();
        this.myTools = new ArrayList<LocalInspectionTool>();
        long startTime = System.nanoTime();
        this.inspectRoot();
        long endTime = System.nanoTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspections for " + this.myFile.getName() + " completed in " + (endTime - startTime) / 1000000L + " ms");
        }
    }

    private void inspectRoot() {
        if (!HighlightLevelUtil.shouldInspect((PsiElement)this.myFile)) {
            return;
        }
        InspectionManagerEx iManager = (InspectionManagerEx)InspectionManager.getInstance((Project)this.myProject);
        InspectionProfileWrapper profile = InspectionProjectProfileManager.getInstance(this.myProject).getProfileWrapper();
        List tools = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(this.getInspectionTools(profile));
        this.inspect(tools, iManager, true, true);
    }

    public void doInspectInBatch(InspectionManagerEx iManager, List<InspectionProfileEntry> toolWrappers, boolean ignoreSuppressed) {
        this.myDescriptors = new ArrayList<ProblemDescriptor>();
        this.myLevels = new ArrayList<HighlightInfoType>();
        this.myTools = new ArrayList<LocalInspectionTool>();
        THashMap tool2Wrapper = new THashMap(toolWrappers.size());
        for (InspectionProfileEntry toolWrapper : toolWrappers) {
            tool2Wrapper.put(((LocalInspectionToolWrapper)toolWrapper).getTool(), (LocalInspectionToolWrapper)toolWrapper);
        }
        ArrayList<LocalInspectionTool> tools = new ArrayList<LocalInspectionTool>(tool2Wrapper.keySet());
        this.inspect(tools, iManager, false, ignoreSuppressed);
        this.addDescriptorsFromInjectedResults((Map<LocalInspectionTool, LocalInspectionToolWrapper>)tool2Wrapper, iManager);
        for (int i = 0; i < this.myTools.size(); ++i) {
            LocalInspectionTool tool = this.myTools.get(i);
            ProblemDescriptor descriptor = this.myDescriptors.get(i);
            LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)((Object)tool2Wrapper.get(tool));
            toolWrapper.addProblemDescriptors(Collections.singletonList(descriptor), true);
        }
    }

    private void addDescriptorsFromInjectedResults(Map<LocalInspectionTool, LocalInspectionToolWrapper> tool2Wrapper, InspectionManagerEx iManager) {
        THashSet emptyActionRegistered = new THashSet();
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(this.myProject).getInspectionProfile();
        InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        for (int i = 0; i < this.myInjectedPsiInspectionResults.size(); ++i) {
            InjectedPsiInspectionResult result = this.myInjectedPsiInspectionResults.get(i);
            LocalInspectionTool tool = result.tool;
            HighlightSeverity severity = inspectionProfile.getErrorLevel(HighlightDisplayKey.find((String)tool.getShortName()), (PsiElement)this.myFile).getSeverity();
            PsiElement injectedPsi = result.injectedPsi;
            DocumentWindow documentRange = (DocumentWindow)documentManager.getDocument((PsiFile)injectedPsi);
            if (documentRange == null) continue;
            for (int j = 0; j < result.foundProblems.size(); ++j) {
                HighlightInfoType level;
                HighlightInfo info;
                ProblemDescriptor descriptor = result.foundProblems.get(j);
                PsiElement psiElement = descriptor.getPsiElement();
                if (InspectionManagerEx.inspectionResultSuppressed(psiElement, tool) || (info = this.createHighlightInfo(descriptor, tool, level = this.highlightTypeFromDescriptor(descriptor, severity), (Set<TextRange>)emptyActionRegistered)) == null) continue;
                List editables = ilManager.intersectWithAllEditableFragments((PsiFile)injectedPsi, new TextRange(info.startOffset, info.endOffset));
                for (TextRange editable : editables) {
                    TextRange hostRange = documentRange.injectedToHost(editable);
                    QuickFix[] fixes = descriptor.getFixes();
                    LocalQuickFix[] localFixes = null;
                    if (fixes != null) {
                        localFixes = new LocalQuickFix[fixes.length];
                        for (int k = 0; k < fixes.length; ++k) {
                            QuickFix fix = fixes[k];
                            localFixes[k] = (LocalQuickFix)fix;
                        }
                    }
                    ProblemDescriptor patchedDescriptor = iManager.createProblemDescriptor((PsiElement)this.myFile, hostRange, descriptor.getDescriptionTemplate(), descriptor.getHighlightType(), true, localFixes);
                    LocalInspectionToolWrapper toolWrapper = tool2Wrapper.get(tool);
                    toolWrapper.addProblemDescriptors(Collections.singletonList(patchedDescriptor), true);
                }
            }
        }
    }

    private void inspect(List<LocalInspectionTool> tools, final InspectionManagerEx iManager, final boolean isOnTheFly, final boolean ignoreSuppressed) {
        if (tools.isEmpty()) {
            return;
        }
        final PsiElement[] elements = LocalInspectionsPass.getElementsIntersectingRange(this.myFile, this.myStartOffset, this.myEndOffset);
        this.setProgressLimit(1L * (long)tools.size() * (long)elements.length);
        final LocalInspectionToolSession session = new LocalInspectionToolSession(this.myFile, this.myStartOffset, this.myEndOffset);
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        LOG.assertTrue(indicator != null);
        JobUtil.invokeConcurrentlyUnderMyProgress(tools, new Processor<LocalInspectionTool>(){

            public boolean process(LocalInspectionTool tool) {
                ProgressManager progressManager = ProgressManager.getInstance();
                indicator.checkCanceled();
                ProgressIndicator localIndicator = progressManager.getProgressIndicator();
                ProgressIndicator original = ((ProgressWrapper)localIndicator).getOriginalProgressIndicator();
                LOG.assertTrue(original == indicator, (Object)original);
                ApplicationManager.getApplication().assertReadAccessAllowed();
                ProblemsHolder holder = new ProblemsHolder((InspectionManager)iManager, LocalInspectionsPass.this.myFile, isOnTheFly);
                PsiElementVisitor elementVisitor = tool.buildVisitor(holder, isOnTheFly);
                if (elementVisitor == null) {
                    LOG.error("Tool " + tool + " must not return null from the buildVisitor() method");
                }
                tool.inspectionStarted(session);
                for (PsiElement element : elements) {
                    indicator.checkCanceled();
                    element.accept(elementVisitor);
                }
                tool.inspectionFinished(session);
                LocalInspectionsPass.this.advanceProgress(elements.length);
                if (holder.hasResults()) {
                    LocalInspectionsPass.this.appendDescriptors(holder.getResults(), tool, ignoreSuppressed, indicator);
                }
                return true;
            }
        }, "Inspection tools");
        indicator.checkCanceled();
        this.inspectInjectedPsi(elements, tools);
        this.myInfos = new ArrayList<HighlightInfo>(this.myDescriptors.size());
        this.addHighlightsFromDescriptors(this.myInfos);
        this.addHighlightsFromInjectedPsiProblems(this.myInfos);
    }

    void inspectInjectedPsi(PsiElement[] elements, final List<LocalInspectionTool> tools) {
        this.myInjectedPsiInspectionResults = ContainerUtil.createEmptyCOWList();
        THashSet injected = new THashSet();
        for (PsiElement element : elements) {
            InjectedLanguageUtil.enumerate(element, this.myFile, new PsiLanguageInjectionHost.InjectedPsiVisitor((Set)injected){
                final /* synthetic */ Set val$injected;
                {
                    this.val$injected = set;
                }

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$2.visit must not be null");
                    }
                    if (places == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LocalInspectionsPass$2.visit must not be null");
                    }
                    this.val$injected.add(injectedPsi);
                }
            }, false);
        }
        JobUtil.invokeConcurrentlyUnderMyProgress(injected, new Processor<PsiFile>(){

            public boolean process(PsiFile injectedPsi) {
                LocalInspectionsPass.inspectInjectedPsi(injectedPsi, LocalInspectionsPass.this.myInjectedPsiInspectionResults, tools);
                return true;
            }
        }, "Inspect injected fragments");
    }

    public Collection<HighlightInfo> getHighlights() {
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>(this.myDescriptors.size());
        this.addHighlightsFromDescriptors(highlights);
        this.addHighlightsFromInjectedPsiProblems(highlights);
        return highlights;
    }

    private static HighlightInfo highlightInfoFromDescriptor(ProblemDescriptor problemDescriptor, HighlightInfoType highlightInfoType, String message, String toolTip) {
        TextRange textRange = ((ProblemDescriptorImpl)problemDescriptor).getTextRange();
        PsiElement element = problemDescriptor.getPsiElement();
        boolean isFileLevel = element instanceof PsiFile && textRange.equals((Object)element.getTextRange());
        return new HighlightInfo(null, highlightInfoType, textRange.getStartOffset(), textRange.getEndOffset(), message, toolTip, highlightInfoType.getSeverity(element), problemDescriptor.isAfterEndOfLine(), null, isFileLevel);
    }

    private synchronized void appendDescriptors(@NotNull List<ProblemDescriptor> problemDescriptors, @NotNull LocalInspectionTool tool, boolean ignoreSuppressed, @NotNull ProgressIndicator progress) {
        if (problemDescriptors == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.appendDescriptors must not be null");
        }
        if (tool == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.appendDescriptors must not be null");
        }
        if (progress == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.appendDescriptors must not be null");
        }
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(this.myProject).getInspectionProfile();
        HighlightSeverity severity = inspectionProfile.getErrorLevel(HighlightDisplayKey.find((String)tool.getShortName()), (PsiElement)this.myFile).getSeverity();
        for (ProblemDescriptor problemDescriptor : problemDescriptors) {
            progress.checkCanceled();
            if (ignoreSuppressed && InspectionManagerEx.inspectionResultSuppressed(problemDescriptor.getPsiElement(), tool)) continue;
            this.myDescriptors.add(problemDescriptor);
            HighlightInfoType type = this.highlightTypeFromDescriptor(problemDescriptor, severity);
            this.myLevels.add(type);
            this.myTools.add(tool);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private HighlightInfoType highlightTypeFromDescriptor(ProblemDescriptor problemDescriptor, HighlightSeverity severity) {
        ProblemHighlightType highlightType = problemDescriptor.getHighlightType();
        switch (highlightType) {
            case GENERIC_ERROR_OR_WARNING: {
                HighlightInfoType highlightInfoType = this.mySeverityRegistrar.getHighlightInfoTypeBySeverity(severity);
                if (highlightInfoType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.highlightTypeFromDescriptor must not return null");
                return highlightInfoType;
            }
            case LIKE_DEPRECATED: {
                HighlightInfoType highlightInfoType = new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.DEPRECATED.getAttributesKey());
                if (highlightInfoType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.highlightTypeFromDescriptor must not return null");
                return highlightInfoType;
            }
            case LIKE_UNKNOWN_SYMBOL: {
                HighlightInfoType highlightInfoType;
                if (!(severity == HighlightSeverity.ERROR ? (highlightInfoType = new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.WRONG_REF.getAttributesKey())) != null : (severity == HighlightSeverity.WARNING ? (highlightInfoType = new HighlightInfoType.HighlightInfoTypeImpl(severity, CodeInsightColors.INFO_ATTRIBUTES)) != null : (highlightInfoType = this.mySeverityRegistrar.getHighlightInfoTypeBySeverity(severity)) != null))) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.highlightTypeFromDescriptor must not return null");
                return highlightInfoType;
            }
            case LIKE_UNUSED_SYMBOL: {
                HighlightInfoType highlightInfoType = new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
                if (highlightInfoType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.highlightTypeFromDescriptor must not return null");
                return highlightInfoType;
            }
            case INFO: {
                HighlightInfoType highlightInfoType = HighlightInfoType.INFO;
                if (highlightInfoType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.highlightTypeFromDescriptor must not return null");
                return highlightInfoType;
            }
            case ERROR: {
                HighlightInfoType highlightInfoType = HighlightInfoType.WRONG_REF;
                if (highlightInfoType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.highlightTypeFromDescriptor must not return null");
                return highlightInfoType;
            }
            case GENERIC_ERROR: {
                HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
                if (highlightInfoType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.highlightTypeFromDescriptor must not return null");
                return highlightInfoType;
            }
            case INFORMATION: {
                HighlightInfoType highlightInfoType;
                TextAttributesKey attributes = ((ProblemDescriptorImpl)problemDescriptor).getEnforcedTextAttributes();
                if (attributes != null) {
                    highlightInfoType = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, attributes);
                    if (highlightInfoType == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.highlightTypeFromDescriptor must not return null");
                    return highlightInfoType;
                }
                highlightInfoType = HighlightInfoType.INFORMATION;
                if (highlightInfoType != null) return highlightInfoType;
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LocalInspectionsPass.highlightTypeFromDescriptor must not return null");
            }
        }
        throw new RuntimeException("Cannot map " + highlightType);
    }

    @Override
    protected void applyInformationWithProgress() {
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myStartOffset, this.myEndOffset, this.myInfos, this.getId());
    }

    private void addHighlightsFromDescriptors(List<HighlightInfo> toInfos) {
        THashSet emptyActionRegistered = new THashSet();
        for (int i = 0; i < this.myDescriptors.size(); ++i) {
            HighlightInfoType level;
            LocalInspectionTool tool;
            ProblemDescriptor descriptor = this.myDescriptors.get(i);
            HighlightInfo highlightInfo = this.createHighlightInfo(descriptor, tool = this.myTools.get(i), level = this.myLevels.get(i), (Set<TextRange>)emptyActionRegistered);
            if (highlightInfo == null) continue;
            toInfos.add(highlightInfo);
        }
    }

    private void addHighlightsFromInjectedPsiProblems(List<HighlightInfo> infos) {
        THashSet emptyActionRegistered = new THashSet();
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(this.myProject).getInspectionProfile();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        InjectedLanguageManager ilManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        for (InjectedPsiInspectionResult result : this.myInjectedPsiInspectionResults) {
            LocalInspectionTool tool = result.tool;
            HighlightSeverity severity = inspectionProfile.getErrorLevel(HighlightDisplayKey.find((String)tool.getShortName()), (PsiElement)this.myFile).getSeverity();
            PsiElement injectedPsi = result.injectedPsi;
            DocumentWindow documentRange = (DocumentWindow)documentManager.getDocument((PsiFile)injectedPsi);
            if (documentRange == null) continue;
            for (int j = 0; j < result.foundProblems.size(); ++j) {
                HighlightInfoType level;
                HighlightInfo info;
                ProblemDescriptor descriptor = result.foundProblems.get(j);
                PsiElement psiElement = descriptor.getPsiElement();
                if (InspectionManagerEx.inspectionResultSuppressed(psiElement, tool) || (info = this.createHighlightInfo(descriptor, tool, level = this.highlightTypeFromDescriptor(descriptor, severity), (Set<TextRange>)emptyActionRegistered)) == null) continue;
                List editables = ilManager.intersectWithAllEditableFragments((PsiFile)injectedPsi, new TextRange(info.startOffset, info.endOffset));
                for (TextRange editable : editables) {
                    TextRange hostRange = documentRange.injectedToHost(editable);
                    HighlightInfo patched = HighlightInfo.createHighlightInfo(info.type, psiElement, hostRange.getStartOffset(), hostRange.getEndOffset(), info.description, info.toolTip);
                    if (patched == null) continue;
                    LocalInspectionsPass.registerQuickFixes(tool, descriptor, patched, (Set<TextRange>)emptyActionRegistered);
                    infos.add(patched);
                }
            }
        }
    }

    @Nullable
    private HighlightInfo createHighlightInfo(ProblemDescriptor descriptor, LocalInspectionTool tool, HighlightInfoType level, Set<TextRange> emptyActionRegistered) {
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        String message = LocalInspectionsPass.renderDescriptionMessage(descriptor);
        HighlightDisplayKey key = HighlightDisplayKey.find((String)tool.getShortName());
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(this.myProject).getInspectionProfile();
        if (!inspectionProfile.isToolEnabled(key, (PsiElement)this.myFile)) {
            return null;
        }
        HighlightInfoType.HighlightInfoTypeImpl type = new HighlightInfoType.HighlightInfoTypeImpl(level.getSeverity(psiElement), level.getAttributesKey());
        String plainMessage = message.startsWith("<html>") ? StringUtil.unescapeXml((String)message.replaceAll("<[^>]*>", "")) : message;
        String link = "<a href=\"#inspection/" + tool.getShortName() + "\"> " + DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]) + "</a>" + this.myShortcutText;
        String tooltip = null;
        if (descriptor.showTooltip()) {
            tooltip = message.startsWith("<html>") ? (message.contains("</body>") ? message.replace("</body>", link + "</body>") : message.replace("</html>", link + "</html>")) : "<html><body>" + XmlStringUtil.escapeString((String)message) + link + "</body></html>";
        }
        HighlightInfo highlightInfo = LocalInspectionsPass.highlightInfoFromDescriptor(descriptor, type, plainMessage, tooltip);
        LocalInspectionsPass.registerQuickFixes(tool, descriptor, highlightInfo, emptyActionRegistered);
        return highlightInfo;
    }

    private static void registerQuickFixes(LocalInspectionTool tool, ProblemDescriptor descriptor, HighlightInfo highlightInfo, Set<TextRange> emptyActionRegistered) {
        HintAction hintAction;
        HighlightDisplayKey key = HighlightDisplayKey.find((String)tool.getShortName());
        boolean needEmptyAction = true;
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length > 0) {
            for (int k = 0; k < fixes.length; ++k) {
                if (fixes[k] == null) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixWrapper.wrap(descriptor, k), key);
                needEmptyAction = false;
            }
        }
        if ((hintAction = ((ProblemDescriptorImpl)descriptor).getHintAction()) != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, (IntentionAction)hintAction, key);
            needEmptyAction = false;
        }
        if (((ProblemDescriptorImpl)descriptor).getEnforcedTextAttributes() != null) {
            needEmptyAction = false;
        }
        if (needEmptyAction && emptyActionRegistered.add(new TextRange(highlightInfo.fixStartOffset, highlightInfo.fixEndOffset))) {
            EmptyIntentionAction emptyIntentionAction = new EmptyIntentionAction(tool.getDisplayName());
            QuickFixAction.registerQuickFixAction(highlightInfo, emptyIntentionAction, key);
        }
    }

    private static String renderDescriptionMessage(ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        String message = descriptor.getDescriptionTemplate();
        if (message == null) {
            return "";
        }
        message = StringUtil.replace((String)message, (String)"<code>", (String)"'");
        message = StringUtil.replace((String)message, (String)"</code>", (String)"'");
        String ref = ProblemDescriptionNode.extractHighlightedText((CommonProblemDescriptor)descriptor, psiElement);
        message = StringUtil.replace((String)message, (String)"#loc", (String)"");
        message = StringUtil.replace((String)message, (String)"#ref", (String)ref);
        message = StringUtil.unescapeXml((String)message).trim();
        return message;
    }

    public static PsiElement[] getElementsIntersectingRange(PsiFile file, int startOffset, int endOffset) {
        FileViewProvider viewProvider = file.getViewProvider();
        LinkedHashSet<PsiElement> result = new LinkedHashSet<PsiElement>();
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightLevelUtil.shouldInspect((PsiElement)psiRoot)) continue;
            result.addAll(CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, startOffset, endOffset, true));
        }
        return result.toArray(new PsiElement[result.size()]);
    }

    List<LocalInspectionTool> getInspectionTools(InspectionProfileWrapper profile) {
        return profile.getHighlightingLocalInspectionTools((PsiElement)this.myFile);
    }

    private static void inspectInjectedPsi(PsiFile injectedPsi, List<InjectedPsiInspectionResult> result, List<LocalInspectionTool> tools) {
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)injectedPsi.getProject());
        ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, injectedPsi, true);
        PsiElement host = injectedPsi.getContext();
        PsiElement[] elements = LocalInspectionsPass.getElementsIntersectingRange(injectedPsi, 0, injectedPsi.getTextLength());
        if (elements.length != 0) {
            for (LocalInspectionTool tool : tools) {
                if (host != null && InspectionManagerEx.inspectionResultSuppressed(host, tool)) continue;
                PsiElementVisitor visitor = tool.buildVisitor(problemsHolder, true);
                assert (!(visitor instanceof PsiRecursiveElementVisitor)) : "The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive. " + tool;
                for (PsiElement element : elements) {
                    element.accept(visitor);
                }
                List problems = problemsHolder.getResults();
                if (problems == null || problems.isEmpty()) continue;
                InjectedPsiInspectionResult res = new InjectedPsiInspectionResult(tool, (PsiElement)injectedPsi, (List)new SmartList((Collection)problems));
                result.add(res);
            }
        }
    }

    public List<HighlightInfo> getInfos() {
        return this.myInfos;
    }

    private static class InjectedPsiInspectionResult {
        public final LocalInspectionTool tool;
        public final PsiElement injectedPsi;
        public final List<ProblemDescriptor> foundProblems;

        private InjectedPsiInspectionResult(LocalInspectionTool tool, PsiElement injectedPsi, List<ProblemDescriptor> foundProblems) {
            this.tool = tool;
            this.injectedPsi = injectedPsi;
            this.foundProblems = foundProblems;
        }
    }
}

